/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.client.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.DyeColor;
import net.swedz.little_big_redstone.LBRClientModels;
import net.swedz.little_big_redstone.entity.stickynote.StickyNoteEntity;
import net.swedz.tesseract.neoforge.helper.model.QuadColorFix;

public final class StickyNoteEntityRenderer
extends EntityRenderer<StickyNoteEntity> {
    private final RandomSource random = RandomSource.create();
    private final BlockRenderDispatcher blockRenderer;

    public StickyNoteEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.blockRenderer = context.getBlockRenderDispatcher();
    }

    public ResourceLocation getTextureLocation(StickyNoteEntity entity) {
        return InventoryMenu.BLOCK_ATLAS;
    }

    public void render(StickyNoteEntity entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        super.render((Entity)entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
        Direction attachedFace = entity.getDirection();
        poseStack.pushPose();
        poseStack.mulPose(Axis.XP.rotationDegrees(entity.getXRot()));
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f - entity.getYRot()));
        if (attachedFace.getAxis().isVertical()) {
            boolean up = attachedFace == Direction.UP;
            Direction facing = entity.getFacing();
            poseStack.mulPose(Axis.ZP.rotationDegrees(facing.toYRot() * (float)(up ? 1 : -1)));
        }
        VertexConsumer buffer = bufferSource.getBuffer(Sheets.cutoutBlockSheet());
        for (BakedQuad quad : this.getStickyNoteModel(entity.getColor()).getQuads(null, null, this.random, entity.getModelData(), null)) {
            QuadColorFix.putBulkData((VertexConsumer)buffer, (PoseStack.Pose)poseStack.last(), (BakedQuad)quad, (int)packedLight, (int)OverlayTexture.NO_OVERLAY);
        }
        poseStack.popPose();
    }

    private BakedModel getStickyNoteModel(DyeColor color) {
        ModelManager modelManager = this.blockRenderer.getBlockModelShaper().getModelManager();
        return modelManager.getModel(LBRClientModels.stickyNote(color));
    }
}

