/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.gui.logicarray.slot;

import java.util.function.Supplier;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.swedz.little_big_redstone.LBRTags;

public final class LogicArrayPlayerSlot
extends Slot {
    private final Supplier<Boolean> isLocked;

    public LogicArrayPlayerSlot(Container container, int slot, int x, int y, Supplier<Boolean> isLocked) {
        super(container, slot, x, y);
        this.isLocked = isLocked;
    }

    public LogicArrayPlayerSlot(Container container, int slot, int x, int y) {
        this(container, slot, x, y, null);
    }

    public boolean isLocked() {
        return this.isLocked != null ? this.isLocked.get().booleanValue() : this.containsLogicArray();
    }

    public boolean containsLogicArray() {
        return this.getItem().is(LBRTags.Items.LOGIC_ARRAYS);
    }

    public boolean mayPlace(ItemStack stack) {
        return !this.isLocked();
    }

    public boolean mayPickup(Player player) {
        return !this.isLocked();
    }

    public boolean allowModification(Player player) {
        return !this.isLocked();
    }
}

