/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.guide.tags.microchip;

import com.google.common.collect.Maps;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import guideme.compiler.PageCompiler;
import guideme.document.LytErrorSink;
import guideme.document.LytRect;
import guideme.document.block.LytBlock;
import guideme.document.block.LytBox;
import guideme.document.block.LytVBox;
import guideme.document.interaction.GuideTooltip;
import guideme.document.interaction.InteractiveElement;
import guideme.document.interaction.ItemTooltip;
import guideme.document.interaction.LytWidget;
import guideme.internal.screen.GuideIconButton;
import guideme.layout.LayoutContext;
import guideme.libs.mdast.mdx.model.MdxJsxElementFields;
import guideme.libs.unist.UnistNode;
import guideme.render.RenderContext;
import guideme.siteexport.ExportableResourceProvider;
import guideme.siteexport.ResourceExporter;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.world.item.DyeColor;
import net.swedz.little_big_redstone.LBR;
import net.swedz.little_big_redstone.LBRItems;
import net.swedz.little_big_redstone.gui.microchip.panel.MicrochipRenderBoardPanel;
import net.swedz.little_big_redstone.guide.PausePlayGuideIconButton;
import net.swedz.little_big_redstone.guide.tags.microchip.TimedRedstoneSignals;
import net.swedz.little_big_redstone.guide.tags.microchip.element.MicrochipObjectGuideTooltip;
import net.swedz.little_big_redstone.microchip.Microchip;
import net.swedz.little_big_redstone.microchip.MicrochipSize;
import net.swedz.little_big_redstone.microchip.awareness.AwarenessTypes;
import net.swedz.little_big_redstone.microchip.awareness.types.RedstoneAwareness;
import net.swedz.little_big_redstone.microchip.object.MicrochipObject;
import net.swedz.little_big_redstone.microchip.object.logic.LogicComponent;
import net.swedz.little_big_redstone.microchip.object.logic.LogicContext;
import net.swedz.little_big_redstone.microchip.object.logic.LogicEntry;
import net.swedz.little_big_redstone.microchip.object.logic.LogicType;
import net.swedz.little_big_redstone.microchip.object.logic.config.LogicConfig;
import net.swedz.little_big_redstone.microchip.wire.Wire;
import net.swedz.tesseract.neoforge.api.Bounds;
import net.swedz.tesseract.neoforge.helper.guigraphics.TesseractGuiGraphics;

public final class MicrochipGuidebookScene
extends LytBox
implements ExportableResourceProvider {
    public static final int PANEL_MARGIN = 5;
    private final DyeColor color;
    private final int width;
    private final int height;
    private final boolean autoWidth;
    private final boolean autoHeight;
    private final int marginWidth;
    private final int marginHeight;
    private final boolean includeToolbar;
    private Microchip microchip;
    private MicrochipRenderBoardPanel panel;
    private final Map<Integer, LogicComponent> logicDefaults = Maps.newHashMap();
    private final Map<String, Integer> logic = Maps.newHashMap();
    private final TimedRedstoneSignals redstoneSignals = new TimedRedstoneSignals();
    private final Viewport viewport = new Viewport();
    private final LytVBox toolbar = new LytVBox();
    private final LytWidget resetButton;
    private final LytWidget pausePlayButton;

    public MicrochipGuidebookScene(DyeColor color, int width, int height, int marginWidth, int marginHeight, boolean includeToolbar) {
        this.color = color;
        this.width = width;
        this.height = height;
        this.autoWidth = width == -1;
        this.autoHeight = height == -1;
        this.marginWidth = marginWidth;
        this.marginHeight = marginHeight;
        this.includeToolbar = includeToolbar;
        this.rebuildMicrochip(0, 0, this.autoWidth ? 0 : width, this.autoHeight ? 0 : height);
        this.append(this.viewport);
        this.resetButton = new LytWidget((AbstractWidget)new GuideIconButton(0, 0, GuideIconButton.Role.RESET_VIEW, () -> {
            for (LogicEntry entry : this.microchip.components()) {
                entry.component().loadFrom(this.logicDefaults.get(entry.slot()));
            }
            this.redstoneSignals.reset();
            this.tickLogic();
        }));
        this.toolbar.append((LytBlock)this.resetButton);
        this.pausePlayButton = new LytWidget((AbstractWidget)new PausePlayGuideIconButton(0, 0, () -> {}));
        this.toolbar.append((LytBlock)this.pausePlayButton);
        if (includeToolbar) {
            this.append((LytBlock)this.toolbar);
        }
    }

    private void rebuildMicrochip(int startX, int startY, int endX, int endY) {
        int width = Math.abs(endX - startX);
        int height = Math.abs(endY - startY);
        Microchip previous = this.microchip;
        this.microchip = new Microchip(MicrochipSize.create(new Bounds(0, 0, width, height), 1.0f));
        if (previous != null) {
            this.microchip.loadFrom(previous);
            this.microchip.components().loadFrom(previous.components(), before -> new LogicEntry(before.slot(), before.x() - startX, before.y() - startY, before.component()));
        }
        this.panel = new MicrochipRenderBoardPanel(this.color, this.microchip);
    }

    public void adjustSize() {
        int startX = -1;
        int startY = -1;
        int endX = 0;
        int endY = 0;
        if (this.autoWidth || this.autoHeight) {
            int firstVisibleX = -1;
            int firstVisibleY = -1;
            for (LogicEntry entry : this.microchip.components()) {
                Bounds bounds = entry.toBounds();
                if (!((LogicConfig)entry.component().config()).isVisible()) continue;
                int x = bounds.minX() - this.marginWidth;
                if (firstVisibleX == -1 || firstVisibleX > x) {
                    firstVisibleX = x;
                }
                int y = bounds.minY() - this.marginHeight;
                if (firstVisibleY != -1 && firstVisibleY <= y) continue;
                firstVisibleY = y;
            }
            for (LogicEntry entry : this.microchip.components()) {
                int entryEndY;
                int entryStartY;
                boolean visible = ((LogicConfig)entry.component().config()).isVisible();
                Bounds bounds = entry.toBounds();
                if (this.autoWidth) {
                    int entryEndX;
                    int entryStartX;
                    if (!visible && startX < (entryStartX = bounds.maxX() + 1) && entryStartX < firstVisibleX) {
                        startX = entryStartX;
                    }
                    int n = entryEndX = visible ? bounds.maxX() + this.marginWidth + 1 : bounds.minX();
                    if (endX < entryEndX) {
                        endX = entryEndX;
                    }
                }
                if (!this.autoHeight) continue;
                if (!visible && startY < (entryStartY = bounds.maxY() + 1) && entryStartY < firstVisibleY) {
                    startY = entryStartY;
                }
                if (endY >= (entryEndY = visible ? bounds.maxY() + this.marginHeight + 1 : bounds.minY())) continue;
                endY = entryEndY;
            }
            if (startX == -1) {
                startX = firstVisibleX;
            }
            if (startY == -1) {
                startY = firstVisibleY;
            }
        } else {
            startX = 0;
            startY = 0;
            endX = this.width + this.marginWidth * 2;
            endY = this.height + this.marginHeight * 2;
        }
        this.rebuildMicrochip(startX, startY, endX, endY);
    }

    public Integer getLogicSlot(String name) {
        return this.logic.get(name);
    }

    public LogicEntry getLogic(String name) {
        Integer slot = this.getLogicSlot(name);
        return slot == null ? null : (LogicEntry)this.microchip.components().get(slot);
    }

    public void addLogic(String name, int x, int y, DyeColor color, LogicType<?> type, CompoundTag data, boolean hide, PageCompiler compiler, LytErrorSink errorSink, MdxJsxElementFields el) {
        DataResult result = type.codec().codec().parse((DynamicOps)NbtOps.INSTANCE, (Object)data);
        if (result.isError()) {
            errorSink.appendError(compiler, "Failed to parse data: " + ((DataResult.Error)result.error().orElseThrow()).message(), (UnistNode)el);
            return;
        }
        LogicComponent component = (LogicComponent)result.getOrThrow();
        component.setColor(Optional.ofNullable(color));
        if (hide) {
            ((LogicConfig)component.config()).hide();
        }
        LogicEntry entry = this.microchip.components().addUnsafe(x + this.marginWidth, y + this.marginHeight, component);
        this.logicDefaults.put(entry.slot(), component);
        this.logic.put(name, entry.slot());
        this.microchip.markDirty();
    }

    public void addWire(String from, String to, int fromPort, int toPort, PageCompiler compiler, LytErrorSink errorSink, MdxJsxElementFields el) {
        Integer fromSlot = this.getLogicSlot(from);
        if (fromSlot == null) {
            errorSink.appendError(compiler, "Logic with name '" + from + "' does not exist", (UnistNode)el);
            return;
        }
        LogicEntry fromLogic = (LogicEntry)this.microchip.components().get(fromSlot);
        if (fromLogic.component().outputs() <= fromPort) {
            errorSink.appendError(compiler, "Logic with name '" + from + "' does not have an output port for that index", (UnistNode)el);
            return;
        }
        Integer toSlot = this.getLogicSlot(to);
        if (toSlot == null) {
            errorSink.appendError(compiler, "Logic with name '" + to + "' does not exist", (UnistNode)el);
            return;
        }
        LogicEntry toLogic = (LogicEntry)this.microchip.components().get(toSlot);
        if (toLogic.component().inputs() <= toPort) {
            errorSink.appendError(compiler, "Logic with name '" + from + "' does not have an input port for that index", (UnistNode)el);
            return;
        }
        this.microchip.wires().add(fromSlot, fromPort, toSlot, toPort);
        this.microchip.markDirty();
    }

    public void setRedstoneSignal(Integer step, Direction direction, int signal) {
        this.redstoneSignals.setSignal(step, direction, signal);
    }

    protected LytRect computeBoxLayout(LayoutContext context, int x, int y, int availableWidth) {
        LytRect viewportBounds = new LytRect(x, y, this.microchip.size().bounds().width() + 10, this.microchip.size().bounds().height() + 10);
        this.viewport.setBounds(viewportBounds);
        if (this.includeToolbar) {
            LytRect toolbarBounds = this.toolbar.layout(context, x + viewportBounds.width(), y, availableWidth - viewportBounds.width());
            return LytRect.union((LytRect)viewportBounds, (LytRect)toolbarBounds);
        }
        return viewportBounds;
    }

    public void tick() {
        if (!((PausePlayGuideIconButton)this.pausePlayButton.getWidget()).isPlaying()) {
            return;
        }
        this.tickLogic();
    }

    private void tickLogic() {
        RedstoneAwareness redstone = this.microchip.awarenesses().get(AwarenessTypes.REDSTONE);
        if (redstone != null) {
            this.redstoneSignals.tick();
            this.redstoneSignals.applySignals(redstone);
        }
        LogicContext context = new LogicContext(null, new BlockPos(0, 0, 0), this.microchip);
        this.microchip.tickLogic(context);
        boolean microchipDirty = this.microchip.isDirty();
        boolean contextDirty = context.isDirty();
        if (microchipDirty || contextDirty) {
            this.microchip.markClean();
        }
    }

    public void exportResources(ResourceExporter exporter) {
        exporter.exportTexture(LBR.id("textures/gui/container/microchip/circuit_background.png"));
    }

    final class Viewport
    extends LytBlock
    implements InteractiveElement {
        Viewport() {
        }

        public void setBounds(LytRect bounds) {
            this.bounds = bounds;
        }

        protected LytRect computeLayout(LayoutContext context, int x, int y, int availableWidth) {
            return this.bounds;
        }

        protected void onLayoutMoved(int deltaX, int deltaY) {
        }

        public void renderBatch(RenderContext context, MultiBufferSource buffers) {
        }

        public void render(RenderContext context) {
            TesseractGuiGraphics graphics = new TesseractGuiGraphics(context.guiGraphics());
            graphics.pose().pushPose();
            context.renderPanel(this.bounds);
            graphics.pose().translate((float)(this.bounds.x() + 5), (float)(this.bounds.y() + 5), 10.0f);
            MicrochipGuidebookScene.this.panel.render(graphics);
            graphics.pose().popPose();
        }

        public Optional<GuideTooltip> getTooltip(float mouseX, float mouseY) {
            LogicEntry entry;
            int y;
            int x = (int)(mouseX - (float)this.bounds.x() - 5.0f);
            MicrochipObject hoveredObject = MicrochipGuidebookScene.this.microchip.findAt(x, y = (int)(mouseY - (float)this.bounds.y() - 5.0f));
            if (hoveredObject != null && (!(hoveredObject instanceof LogicEntry) || ((LogicConfig)(entry = (LogicEntry)hoveredObject).component().config()).isVisible())) {
                return Optional.of(new MicrochipObjectGuideTooltip(hoveredObject));
            }
            Wire hoveredWire = MicrochipGuidebookScene.this.panel.wires().findHoveredWire(x, y);
            if (hoveredWire != null) {
                return Optional.of(new ItemTooltip(LBRItems.REDSTONE_BIT.asItem().getDefaultInstance()));
            }
            return Optional.empty();
        }
    }
}

