/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.microchip.object.logic;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.DyeColor;
import net.swedz.little_big_redstone.microchip.object.logic.LogicContext;
import net.swedz.little_big_redstone.microchip.object.logic.LogicGridSize;
import net.swedz.little_big_redstone.microchip.object.logic.LogicPortHolder;
import net.swedz.little_big_redstone.microchip.object.logic.LogicType;
import net.swedz.little_big_redstone.microchip.object.logic.LogicTypes;
import net.swedz.little_big_redstone.microchip.object.logic.config.LogicConfig;
import net.swedz.tesseract.neoforge.api.Assert;
import net.swedz.tesseract.neoforge.api.range.IntRange;

public abstract class LogicComponent<L extends LogicComponent<L, C>, C extends LogicConfig>
implements LogicPortHolder {
    public static final Codec<LogicComponent> CODEC = LogicTypes.CODEC;
    public static final StreamCodec<ByteBuf, LogicComponent> STREAM_CODEC = LogicTypes.STREAM_CODEC;
    protected final C config;
    protected Optional<DyeColor> color;

    protected LogicComponent(C config, Optional<DyeColor> color) {
        this.config = config;
        this.color = color;
    }

    protected LogicComponent(Optional<DyeColor> color) {
        this.color = color;
        this.config = this.defaultConfig();
    }

    public C config() {
        return this.config;
    }

    public void resetConfig() {
        ((LogicConfig)this.config).loadFrom(this.defaultConfig());
    }

    protected abstract C defaultConfig();

    public final Optional<DyeColor> color() {
        return this.color;
    }

    public final void setColor(Optional<DyeColor> color) {
        this.color = color;
    }

    public final void resetColor() {
        this.color = Optional.empty();
    }

    public abstract LogicType<L> type();

    @Override
    public final IntRange inputsAllowed() {
        return this.config.inputsAllowed();
    }

    @Override
    public final int inputs() {
        return this.config.inputs();
    }

    @Override
    public final IntRange outputsAllowed() {
        return this.config.outputsAllowed();
    }

    @Override
    public final int outputs() {
        return this.config.outputs();
    }

    protected abstract void processTickInternal(LogicContext var1, boolean[] var2);

    public final void processTick(LogicContext context, boolean[] inputs) {
        int expectedInputs = this.inputs();
        Assert.that((expectedInputs == inputs.length ? 1 : 0) != 0, (String)"Mismatching logic component input sizes: expected %d but got %d".formatted(expectedInputs, inputs.length));
        if (((LogicConfig)this.config).isValid()) {
            this.processTickInternal(context, inputs);
        }
    }

    protected abstract boolean outputInternal(int var1);

    public final boolean output(int index) {
        Boolean lock = ((LogicConfig)this.config).getOutputLock(index);
        if (lock != null) {
            return lock;
        }
        return this.outputInternal(index);
    }

    public LogicGridSize size() {
        return new LogicGridSize(1, 1);
    }

    public void appendNoShiftHoverText(List<Component> lines) {
    }

    public void appendShiftHoverText(List<Component> lines) {
    }

    protected abstract void internalLoadFrom(L var1);

    public final void loadFrom(L other) {
        ((LogicConfig)this.config).loadFrom(((LogicComponent)other).config);
        this.color = ((LogicComponent)other).color;
        this.internalLoadFrom(other);
    }

    protected abstract void internalResetForPickup();

    public final void resetForPickup() {
        ((LogicConfig)this.config).resetForPickup();
        this.internalResetForPickup();
    }

    public final L copy() {
        LogicComponent copy = this.type().defaultFactory().create();
        copy.loadFrom(this);
        return (L)copy;
    }

    public abstract int hashCode();

    public abstract boolean equals(Object var1);
}

