/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.client.hud;

import java.util.Objects;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.swedz.little_big_redstone.LBRClient;
import net.swedz.little_big_redstone.client.StickyNoteViewRenderer;
import net.swedz.little_big_redstone.entity.stickynote.StickyNoteEntity;
import net.swedz.little_big_redstone.entity.stickynote.StickyNoteView;
import net.swedz.little_big_redstone.network.packet.RequestStickyNoteWatcherPacket;
import net.swedz.little_big_redstone.proxy.LBRProxy;
import net.swedz.tesseract.neoforge.helper.guigraphics.TesseractGuiGraphics;
import net.swedz.tesseract.neoforge.proxy.Proxies;

@EventBusSubscriber(modid="little_big_redstone", value={Dist.CLIENT})
public final class StickyNoteViewContentsGuiOverlay {
    private static boolean SHOULD_FADE;
    private static StickyNoteView STICKY_NOTE;
    private static int DISPLAY_TIME;
    private static Integer LAST_TARGET_ENTITY_ID;

    public static void update(StickyNoteView stickyNote) {
        if ((stickyNote == null || stickyNote.text().equals((Object)Component.empty())) && STICKY_NOTE != null) {
            SHOULD_FADE = true;
        } else if (stickyNote == null || !stickyNote.text().equals((Object)Component.empty())) {
            SHOULD_FADE = false;
            STICKY_NOTE = stickyNote;
            DISPLAY_TIME = LBRClient.config().stickyNoteInWorldViewLingerTime();
        }
    }

    public static void render(GuiGraphics internal, DeltaTracker delta) {
        int alpha;
        if (Minecraft.getInstance().screen != null) {
            LBRProxy proxy = (LBRProxy)Proxies.get(LBRProxy.class);
            StickyNoteView watchedStickyNote = proxy.getWatchedStickyNote();
            proxy.updateWatchedStickyNote(null);
            if (watchedStickyNote != null) {
                new RequestStickyNoteWatcherPacket(null, false).sendToServer();
            }
            return;
        }
        if (STICKY_NOTE != null && (alpha = Math.min((int)(((float)DISPLAY_TIME - delta.getGameTimeDeltaPartialTick(false)) * 12.75f), 255)) > 8) {
            TesseractGuiGraphics graphics = new TesseractGuiGraphics(internal);
            float scale = (float)LBRClient.config().stickyNoteInWorldViewScale();
            graphics.pose().pushPose();
            graphics.pose().translate(10.0f, 10.0f, 0.0f);
            graphics.pose().scale(scale, scale, 1.0f);
            StickyNoteViewRenderer.renderBackground(graphics, STICKY_NOTE, (float)alpha / 255.0f);
            StickyNoteViewRenderer.renderText(graphics, STICKY_NOTE, (float)alpha / 255.0f);
            graphics.pose().popPose();
        }
    }

    @SubscribeEvent
    private static void tick(ClientTickEvent.Post event) {
        Entity entity;
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return;
        }
        LBRProxy proxy = (LBRProxy)Proxies.get(LBRProxy.class);
        LocalPlayer player = Minecraft.getInstance().player;
        HitResult hitResult = Minecraft.getInstance().hitResult;
        if (hitResult instanceof EntityHitResult) {
            EntityHitResult hitResult2 = (EntityHitResult)hitResult;
            entity = hitResult2.getEntity();
        } else {
            entity = null;
        }
        Entity targetEntity = entity;
        Integer targetEntityId = targetEntity != null && Minecraft.getInstance().screen == null ? Integer.valueOf(targetEntity.getId()) : null;
        StickyNoteView watchedStickyNote = proxy.getWatchedStickyNote();
        if (!Objects.equals(targetEntityId, LAST_TARGET_ENTITY_ID)) {
            proxy.updateWatchedStickyNote(null);
            if (targetEntity instanceof StickyNoteEntity) {
                StickyNoteEntity stickyNote = (StickyNoteEntity)targetEntity;
                new RequestStickyNoteWatcherPacket(targetEntityId, true).sendToServer();
            } else if (watchedStickyNote != null) {
                new RequestStickyNoteWatcherPacket(targetEntityId, false).sendToServer();
            }
        }
        if (SHOULD_FADE) {
            if (DISPLAY_TIME > 0) {
                --DISPLAY_TIME;
            } else {
                STICKY_NOTE = null;
                SHOULD_FADE = false;
            }
        }
        LAST_TARGET_ENTITY_ID = targetEntityId;
    }
}

