/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.guide.tags.truthtable.element;

import guideme.color.ColorValue;
import guideme.color.SymbolicColor;
import guideme.compiler.PageCompiler;
import guideme.document.LytErrorSink;
import guideme.document.block.LytBlock;
import guideme.document.block.LytParagraph;
import guideme.document.block.table.LytTable;
import guideme.document.block.table.LytTableCell;
import guideme.document.block.table.LytTableRow;
import guideme.document.flow.LytFlowContent;
import guideme.document.flow.LytFlowText;
import guideme.libs.mdast.mdx.model.MdxJsxElementFields;
import guideme.style.TextStyle;
import java.util.Set;
import net.swedz.little_big_redstone.guide.LBRGuide;
import net.swedz.little_big_redstone.guide.tags.truthtable.element.TruthTableElementTagCompiler;

public final class TruthTableStateTagCompiler
implements TruthTableElementTagCompiler {
    @Override
    public Set<String> getTagNames() {
        return Set.of("TruthState");
    }

    private void append(LytTableRow row, String[] values) {
        for (String value : values) {
            boolean on = false;
            if (value.equals("0") || value.equalsIgnoreCase("off")) {
                value = "OFF";
            } else {
                if (!value.equals("1") && !value.equalsIgnoreCase("on")) continue;
                value = "ON";
                on = true;
            }
            LytTableCell cell = row.appendCell();
            LytParagraph content = new LytParagraph();
            LytFlowText text = LytFlowText.of((String)value.toUpperCase());
            text.setStyle(TextStyle.builder().color((ColorValue)(on ? SymbolicColor.GREEN : SymbolicColor.RED)).build());
            content.append((LytFlowContent)text);
            cell.append((LytBlock)content);
        }
    }

    @Override
    public void compile(LytTable inputTable, LytTable outputTable, PageCompiler compiler, LytErrorSink errorSink, MdxJsxElementFields el) {
        String[] input = LBRGuide.getStringArray(compiler, errorSink, el, "input");
        String[] output = LBRGuide.getStringArray(compiler, errorSink, el, "output");
        this.append(inputTable.appendRow(), input);
        this.append(outputTable.appendRow(), output);
    }
}

