/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.microchip;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.swedz.tesseract.neoforge.api.Bounds;

public final class MicrochipSize {
    public static final Codec<MicrochipSize> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Bounds.CODEC.fieldOf("bounds").forGetter(MicrochipSize::bounds), (App)Codec.FLOAT.fieldOf("scale").forGetter(MicrochipSize::scale)).apply((Applicative)instance, MicrochipSize::new));
    public static final StreamCodec<ByteBuf, MicrochipSize> STREAM_CODEC = StreamCodec.composite((StreamCodec)Bounds.STREAM_CODEC, MicrochipSize::bounds, (StreamCodec)ByteBufCodecs.FLOAT, MicrochipSize::scale, MicrochipSize::new);
    private final Bounds bounds;
    private final float scale;

    public static MicrochipSize create(Bounds bounds, float scale) {
        return new MicrochipSize(bounds.divideCeil(scale), scale);
    }

    private MicrochipSize(Bounds bounds, float scale) {
        this.bounds = bounds;
        this.scale = scale;
    }

    public Bounds bounds() {
        return this.bounds;
    }

    public float scale() {
        return this.scale;
    }

    public int boardCoord(int coord, float zoom, double offset) {
        return (int)Math.round((double)((float)coord / (this.scale * zoom)) + offset);
    }

    public double boardCoord(double coord, float zoom, double offset) {
        return coord / (double)(this.scale * zoom) + offset;
    }

    public int scale(int coord) {
        return Math.round((float)coord * this.scale);
    }
}

