/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.microchip.object.logic.pulse;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.swedz.little_big_redstone.LBR;
import net.swedz.little_big_redstone.LBRTooltips;
import net.swedz.little_big_redstone.microchip.object.logic.config.LogicConfig;
import net.swedz.little_big_redstone.microchip.object.logic.config.LogicConfigMenuBuilder;
import net.swedz.tesseract.neoforge.api.range.IntRange;

public final class PulseThrottlerConfig
extends LogicConfig<PulseThrottlerConfig> {
    public static final MapCodec<PulseThrottlerConfig> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.LONG.optionalFieldOf("duration", (Object)1L).forGetter(config -> config.outputDuration)).apply((Applicative)instance, PulseThrottlerConfig::new));
    public static final StreamCodec<ByteBuf, PulseThrottlerConfig> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_LONG, config -> config.outputDuration, PulseThrottlerConfig::new);
    public long outputDuration;

    private PulseThrottlerConfig(long outputDuration) {
        this.outputDuration = outputDuration;
    }

    public PulseThrottlerConfig() {
        this(1L);
    }

    @Override
    public IntRange inputsAllowed() {
        return new IntRange(1, 1);
    }

    @Override
    public int inputs() {
        return 1;
    }

    @Override
    public IntRange outputsAllowed() {
        return new IntRange(1, 1);
    }

    @Override
    public int outputs() {
        return 1;
    }

    @Override
    public void appendHoverText(List<Component> lines) {
        lines.add((Component)LBR.text().logicConfigTooltipDuration(this.outputDuration));
    }

    @Override
    public boolean hasMenu() {
        return true;
    }

    @Override
    public void buildMenu(LogicConfigMenuBuilder builder, int width, int height) {
        builder.addSlider((Component)LBR.text().logicConfigButtonLabelDuration(), (Component)Component.empty(), (Component)LBR.text().logicConfigButtonTooltipDuration(), 0, 0, width, 18, 1.0, 1200.0, this.outputDuration, 1.0, 0, (arg_0, arg_1) -> LBRTooltips.TICKS_AND_SECONDS_SLIDER_PARSER.parse(arg_0, arg_1), value -> {
            this.outputDuration = value.intValue();
        });
    }

    @Override
    protected void internalLoadFrom(PulseThrottlerConfig other) {
        this.outputDuration = other.outputDuration;
    }

    @Override
    public void resetForPickup() {
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.outputDuration);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof PulseThrottlerConfig)) return false;
        PulseThrottlerConfig other = (PulseThrottlerConfig)o;
        if (this.outputDuration != other.outputDuration) return false;
        return true;
    }
}

