/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone;

import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.swedz.little_big_redstone.LBRBlocks;
import net.swedz.little_big_redstone.LBRComponents;
import net.swedz.little_big_redstone.LBRCreativeTabs;
import net.swedz.little_big_redstone.LBREntities;
import net.swedz.little_big_redstone.LBRItems;
import net.swedz.little_big_redstone.LBRMenus;
import net.swedz.little_big_redstone.LBRRecipeTypes;
import net.swedz.little_big_redstone.guide.LBRGuide;
import net.swedz.little_big_redstone.microchip.awareness.AwarenessTypes;
import net.swedz.little_big_redstone.microchip.object.logic.LogicTypes;
import net.swedz.little_big_redstone.network.LBRPackets;
import net.swedz.tesseract.neoforge.capabilities.CapabilitiesListeners;
import net.swedz.tesseract.neoforge.registry.RegisteredObjectHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="little_big_redstone")
public final class LBR {
    public static final String ID = "little_big_redstone";
    public static final String NAME = "Little Big Redstone";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Little Big Redstone");

    public static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)ID, (String)path);
    }

    public LBR(IEventBus bus, ModContainer container) {
        LogicTypes.init();
        AwarenessTypes.init();
        LBRComponents.init(bus);
        LBRItems.init(bus);
        LBRBlocks.init(bus);
        LBREntities.init(bus);
        LBRCreativeTabs.init(bus);
        LBRMenus.init(bus);
        LBRRecipeTypes.init(bus);
        LBRGuide.init();
        bus.addListener(RegisterPayloadHandlersEvent.class, LBRPackets::init);
        bus.addListener(FMLCommonSetupEvent.class, event -> {
            LBRItems.values().forEach(RegisteredObjectHolder::triggerRegistrationListener);
            LBRBlocks.values().forEach(RegisteredObjectHolder::triggerRegistrationListener);
        });
        bus.addListener(RegisterCapabilitiesEvent.class, event -> CapabilitiesListeners.triggerAll((String)ID, (RegisterCapabilitiesEvent)event));
    }
}

