/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.gui.microchip;

import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.wrapper.PlayerMainInvWrapper;
import net.swedz.little_big_redstone.LBR;
import net.swedz.little_big_redstone.LBRItems;
import net.swedz.little_big_redstone.LBRMenus;
import net.swedz.little_big_redstone.gui.logicarray.LogicArrayMenu;
import net.swedz.little_big_redstone.gui.logicarray.slot.LogicArrayPlayerSlot;
import net.swedz.little_big_redstone.gui.logicarray.slot.LogicArraySlot;
import net.swedz.little_big_redstone.gui.microchip.MicrochipViewPosition;
import net.swedz.little_big_redstone.gui.microchip.logicarray.MicrochipLogicArrayItemHandler;
import net.swedz.little_big_redstone.microchip.Microchip;
import net.swedz.little_big_redstone.microchip.wire.Wire;
import net.swedz.little_big_redstone.microchip.wire.WirePort;
import net.swedz.tesseract.neoforge.helper.TransferHelper;
import net.swedz.tesseract.neoforge.helper.gui.PlayerInventoryContainerMenu;

public final class MicrochipMenu
extends PlayerInventoryContainerMenu {
    private final BlockPos blockPos;
    private final Function<Player, Boolean> validChecker;
    private final Microchip microchip;
    private final DyeColor color;
    private final MicrochipViewPosition viewPosition;
    private final MicrochipLogicArrayItemHandler logicArrayItemHandler;
    private int carriedComponentSlot = -1;
    private List<Wire> carriedWires;

    public MicrochipMenu(int containerId, Inventory playerInventory, BlockPos blockPos, Function<Player, Boolean> validChecker, Microchip microchip, DyeColor color, MicrochipViewPosition viewPosition) {
        super(LBRMenus.MICROCHIP.get(), containerId);
        this.blockPos = blockPos;
        this.validChecker = validChecker;
        this.microchip = microchip;
        this.color = color;
        this.viewPosition = viewPosition;
        this.logicArrayItemHandler = new MicrochipLogicArrayItemHandler((AbstractContainerMenu)this, playerInventory.player);
        this.setupInventory(playerInventory);
        this.logicArrayItemHandler.pickLogicArrayFromInventory();
    }

    public MicrochipMenu(int containerId, Inventory playerInventory, RegistryFriendlyByteBuf buf) {
        super(LBRMenus.MICROCHIP.get(), containerId);
        this.blockPos = buf.readBlockPos();
        this.validChecker = null;
        this.microchip = (Microchip)Microchip.STREAM_CODEC.decode((Object)buf);
        this.color = (DyeColor)DyeColor.STREAM_CODEC.decode((Object)buf);
        this.viewPosition = (MicrochipViewPosition)MicrochipViewPosition.STREAM_CODEC.decode((Object)buf);
        this.logicArrayItemHandler = new MicrochipLogicArrayItemHandler((AbstractContainerMenu)this, playerInventory.player);
        this.setupInventory(playerInventory);
        this.logicArrayItemHandler.pickLogicArrayFromInventory();
    }

    private void setupInventory(Inventory playerInventory) {
        LogicArrayMenu.setupLogicArrayInventory((IItemHandler)this.logicArrayItemHandler, x$0 -> this.addSlot(x$0), this.logicArrayItemHandler::shouldDisplay, -75, 10, 7, 4);
        this.setupPlayerInventory(playerInventory, 48, 145, LogicArrayPlayerSlot::new);
    }

    public BlockPos blockPos() {
        return this.blockPos;
    }

    public Microchip microchip() {
        return this.microchip;
    }

    public DyeColor color() {
        return this.color;
    }

    public MicrochipViewPosition viewPosition() {
        return this.viewPosition;
    }

    public MicrochipLogicArrayItemHandler getLogicArrayItemHandler() {
        return this.logicArrayItemHandler;
    }

    public int getCarriedComponentSlot() {
        return this.carriedComponentSlot;
    }

    public void setCarriedWires(int carriedComponentSlot, List<Wire> wires) {
        this.carriedComponentSlot = carriedComponentSlot;
        this.carriedWires = wires.isEmpty() ? null : Collections.unmodifiableList(wires);
    }

    public List<Wire> getCarriedWires() {
        return this.carriedWires;
    }

    public void placeCarriedWires(int newCarriedComponentSlot) {
        if (this.carriedComponentSlot != -1 && this.carriedWires != null) {
            for (Wire wire : this.carriedWires) {
                WirePort newOutput = wire.output();
                WirePort newInput = wire.input();
                if (wire.output().slot() == this.carriedComponentSlot) {
                    newOutput = new WirePort(newCarriedComponentSlot, wire.output().index());
                } else if (wire.input().slot() == this.carriedComponentSlot) {
                    newInput = new WirePort(newCarriedComponentSlot, wire.input().index());
                } else {
                    LBR.LOGGER.warn("MicrochipMenu failed to convert wire {}", (Object)wire);
                    continue;
                }
                Wire newWire = new Wire(newOutput, newInput);
                if (this.microchip.wires().add(newWire)) continue;
                LBR.LOGGER.warn("MicrochipMenu failed to place wire {}", (Object)newWire);
            }
            this.carriedComponentSlot = -1;
            this.carriedWires = null;
        }
    }

    private void dropCarriedWires(int slotId, int button, ClickType clickType, Player player) {
        if (this.carriedComponentSlot != -1 && this.carriedWires != null && (slotId >= 0 || slotId == -999)) {
            int wiresPopped = this.carriedWires.size();
            if (!player.level().isClientSide() && !player.hasInfiniteMaterials()) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack(LBRItems.REDSTONE_BIT, wiresPopped));
            }
            this.carriedComponentSlot = -1;
            this.carriedWires = null;
        }
    }

    private boolean pickLogicArray(int slotId, int button, ClickType clickType, Player player) {
        LogicArrayPlayerSlot playerSlot;
        Slot slot;
        if (slotId >= 0 && (slot = (Slot)this.slots.get(slotId)) instanceof LogicArrayPlayerSlot && (playerSlot = (LogicArrayPlayerSlot)slot).containsLogicArray()) {
            if (slotId == this.logicArrayItemHandler.getSelectedSlot()) {
                this.logicArrayItemHandler.deselectPickedLogicArray();
            } else {
                this.logicArrayItemHandler.setPickedLogicArray(slotId);
            }
            return true;
        }
        return false;
    }

    public void clicked(int slotId, int button, ClickType clickType, Player player) {
        this.dropCarriedWires(slotId, button, clickType, player);
        if (this.pickLogicArray(slotId, button, clickType, player)) {
            return;
        }
        super.clicked(slotId, button, clickType, player);
    }

    public ItemStack quickMoveStack(Player player, int slotId) {
        ItemStack originalStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(slotId);
        if (slot != null && slot.hasItem()) {
            boolean clickedArrayInventory;
            ItemStack stack = slot.getItem();
            if (slot instanceof LogicArraySlot) {
                LogicArraySlot logicArraySlot = (LogicArraySlot)slot;
                if (this.logicArrayItemHandler.isCreativeMode()) {
                    if (this.getCarried().isEmpty() || slot.mayPlace(this.getCarried())) {
                        this.setCarried(stack.copyWithCount(64));
                    }
                    return ItemStack.EMPTY;
                }
            }
            boolean bl = clickedArrayInventory = slotId < 28;
            if (!clickedArrayInventory && this.logicArrayItemHandler.isCreativeMode()) {
                return ItemStack.EMPTY;
            }
            originalStack = stack.copy();
            Object target = clickedArrayInventory ? new PlayerMainInvWrapper(player.getInventory()) : this.logicArrayItemHandler;
            int inserted = TransferHelper.insert((IItemHandler)target, (ItemStack)stack);
            if (inserted <= 0) {
                return ItemStack.EMPTY;
            }
            stack.shrink(inserted);
            if (stack.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setByPlayer(stack);
            }
        }
        return originalStack;
    }

    public boolean canDragTo(Slot slot) {
        return !(slot instanceof LogicArraySlot) || !this.logicArrayItemHandler.isCreativeMode();
    }

    public boolean stillValid(Player player) {
        return this.validChecker == null || this.validChecker.apply(player) != false;
    }
}

