/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.gui.microchip.widget;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.PlayerMainInvWrapper;
import net.swedz.little_big_redstone.LBR;
import net.swedz.little_big_redstone.LBRColors;
import net.swedz.little_big_redstone.LBRComponents;
import net.swedz.little_big_redstone.LBRItems;
import net.swedz.little_big_redstone.LBRText;
import net.swedz.little_big_redstone.LBRTooltips;
import net.swedz.little_big_redstone.block.microchip.MicrochipBlockEntity;
import net.swedz.little_big_redstone.client.model.logic.LogicBakingModelData;
import net.swedz.little_big_redstone.client.model.logic.LogicModelColorSet;
import net.swedz.little_big_redstone.gui.microchip.MicrochipMenu;
import net.swedz.little_big_redstone.gui.microchip.MicrochipScreen;
import net.swedz.little_big_redstone.gui.microchip.MicrochipViewPosition;
import net.swedz.little_big_redstone.gui.microchip.logic.DyeComponentResult;
import net.swedz.little_big_redstone.gui.microchip.logic.LogicRenderer;
import net.swedz.little_big_redstone.gui.microchip.logic.LogicRenderers;
import net.swedz.little_big_redstone.gui.microchip.panel.MicrochipRenderBoardPanel;
import net.swedz.little_big_redstone.gui.microchip.widget.MicrochipWidgetContext;
import net.swedz.little_big_redstone.gui.stickynote.reference.MicrochipStickyNoteReference;
import net.swedz.little_big_redstone.item.stickynote.StickyNote;
import net.swedz.little_big_redstone.item.stickynote.StickyNoteItem;
import net.swedz.little_big_redstone.microchip.Microchip;
import net.swedz.little_big_redstone.microchip.MicrochipSize;
import net.swedz.little_big_redstone.microchip.object.MicrochipObject;
import net.swedz.little_big_redstone.microchip.object.logic.LogicComponent;
import net.swedz.little_big_redstone.microchip.object.logic.LogicEntry;
import net.swedz.little_big_redstone.microchip.object.logic.LogicSelectedPort;
import net.swedz.little_big_redstone.microchip.object.logic.config.LogicConfig;
import net.swedz.little_big_redstone.microchip.object.note.StickyNoteEntry;
import net.swedz.little_big_redstone.microchip.wire.Wire;
import net.swedz.little_big_redstone.network.packet.DyeMicrochipObjectPacket;
import net.swedz.little_big_redstone.network.packet.OpenLogicConfigPacket;
import net.swedz.little_big_redstone.network.packet.PlaceTakeMicrochipObjectPacket;
import net.swedz.little_big_redstone.network.packet.PlaceTakeMicrochipWirePacket;
import net.swedz.little_big_redstone.network.packet.QuickGrabMicrochipWireItemPacket;
import net.swedz.little_big_redstone.proxy.LBRProxy;
import net.swedz.tesseract.neoforge.api.Bounds;
import net.swedz.tesseract.neoforge.helper.TransferHelper;
import net.swedz.tesseract.neoforge.helper.guigraphics.TesseractGuiGraphics;
import net.swedz.tesseract.neoforge.proxy.Proxies;

public final class MicrochipWidget
implements GuiEventListener,
Renderable,
NarratableEntry {
    final int x;
    final int y;
    final int width;
    final int height;
    private boolean focused;
    private final MicrochipScreen screen;
    private final Microchip microchip;
    private final MicrochipRenderBoardPanel panel;
    private MicrochipWidgetContext context = new MicrochipWidgetContext(this, 0, 0);
    private final MicrochipViewPosition viewPosition;
    private LogicSelectedPort selectedPort;
    private boolean allowDragging = true;

    public MicrochipWidget(int x, int y, MicrochipScreen screen, MicrochipViewPosition viewPosition) {
        this.screen = screen;
        this.microchip = ((MicrochipMenu)screen.getMenu()).microchip();
        this.panel = new MicrochipRenderBoardPanel(this.color(), this.microchip, () -> this.context);
        Bounds bounds = this.microchip.size().bounds();
        this.x = x + this.microchip.size().scale(bounds.minX());
        this.y = y + this.microchip.size().scale(bounds.minY());
        this.width = bounds.width();
        this.height = bounds.height();
        this.viewPosition = viewPosition;
        this.viewPosition.init(this.microchip.size(), this.x, this.y);
    }

    public int x() {
        return this.x;
    }

    public int y() {
        return this.y;
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return this.height;
    }

    public MicrochipMenu menu() {
        return (MicrochipMenu)this.screen.getMenu();
    }

    public DyeColor color() {
        return this.menu().color();
    }

    public Microchip microchip() {
        return this.microchip;
    }

    public MicrochipRenderBoardPanel panel() {
        return this.panel;
    }

    public MicrochipWidgetContext context() {
        return this.context;
    }

    public MicrochipViewPosition viewPosition() {
        return this.viewPosition;
    }

    public boolean hasSelectedPort() {
        return this.selectedPort != null;
    }

    public LogicSelectedPort getSelectedPort() {
        return this.selectedPort;
    }

    public void handleUpdate() {
        LogicEntry component;
        if (this.hasSelectedPort() && ((component = (LogicEntry)this.microchip.components().get(this.selectedPort.slot())) == null || this.selectedPort.index() >= component.component().outputs())) {
            this.selectedPort = null;
            LBR.LOGGER.info("Cleared selected port because it doesn't exist anymore");
        }
        this.panel.wires().rebuildPaths();
    }

    private boolean dyeComponent(int x, int y, int button) {
        MicrochipMenu menu = this.menu();
        ItemStack carried = menu.getCarried();
        MicrochipObject entry = this.context.object();
        if (button == 1 && this.context.shouldDyeObject()) {
            int slot = entry.slot();
            DyeComponentResult result = DyeComponentResult.test(carried, entry.color());
            if (result.success() && entry.setColor(result.color())) {
                this.microchip.markDirty();
                if (result.consume()) {
                    carried.consume(1, (LivingEntity)this.screen.getMinecraft().player);
                }
                result.playSound((Entity)this.screen.getMinecraft().player);
                new DyeMicrochipObjectPacket(menu.containerId, entry.containerType(), slot).sendToServer();
                return true;
            }
        }
        return false;
    }

    private boolean pickupNote(int x, int y, int button) {
        MicrochipMenu menu = this.menu();
        ItemStack carried = menu.getCarried();
        StickyNoteEntry note = this.context.note();
        boolean shift = Screen.hasShiftDown();
        if (button == 0 && this.context.shouldInteractNote() && carried.isEmpty()) {
            this.microchip.stickyNotes().remove(note);
            this.microchip.markDirty();
            ItemStack stack = note.toStack();
            if (!shift || TransferHelper.insert((IItemHandler)new PlayerMainInvWrapper(Minecraft.getInstance().player.getInventory()), (ItemStack)stack) <= 0) {
                menu.setCarried(stack);
            }
            new PlaceTakeMicrochipObjectPacket(menu.containerId, x, y, false, true, shift).sendToServer();
            return true;
        }
        return false;
    }

    private boolean pickupWire(Wire wire) {
        MicrochipMenu menu = this.menu();
        ItemStack carried = menu.getCarried();
        if (wire != null && this.microchip.wires().remove(wire)) {
            this.microchip.markDirty();
            if (carried.isEmpty()) {
                menu.setCarried(LBRItems.REDSTONE_BIT.asItem().getDefaultInstance());
            } else if (!this.screen.getMinecraft().player.hasInfiniteMaterials()) {
                carried.grow(1);
            }
            this.selectedPort = new LogicSelectedPort((LogicEntry)this.microchip.components().get(wire.output().slot()), wire.output().index());
            new PlaceTakeMicrochipWirePacket(menu.containerId, wire, false).sendToServer();
            return true;
        }
        return false;
    }

    private boolean pickupWire(int x, int y, int button) {
        MicrochipMenu menu = this.menu();
        ItemStack carried = menu.getCarried();
        if (button == 0 && MicrochipWidgetContext.canInteractWire(carried) && !this.hasSelectedPort()) {
            Wire wire;
            if (carried.isEmpty() && this.context.shouldInteractWire()) {
                Wire wire2 = this.context.wire();
                return this.pickupWire(wire2);
            }
            if (this.context.shouldInteractPort()) {
                if (this.context.isPortOutput()) {
                    if (carried.isEmpty()) {
                        ItemStack extracted = TransferHelper.extractMatching((IItemHandler)menu.getLogicArrayItemHandler(), stack -> stack.is(LBRItems.REDSTONE_BIT.asItem()), (int)1);
                        if (!extracted.isEmpty()) {
                            menu.setCarried(extracted);
                            this.selectedPort = this.context.port();
                            new QuickGrabMicrochipWireItemPacket(menu.containerId).sendToServer();
                            return true;
                        }
                    } else {
                        this.selectedPort = this.context.port();
                        return true;
                    }
                }
                if (this.context.isPortInput() && (carried.isEmpty() || carried.getCount() < carried.getMaxStackSize())) {
                    wire = this.microchip.wires().getByInputSlot(this.context.port());
                    return this.pickupWire(wire);
                }
            }
            if (!carried.isEmpty() && this.context.shouldInteractWire()) {
                wire = this.context.wire();
                return this.pickupWire(wire);
            }
        }
        return false;
    }

    private boolean pickupLogic(int x, int y, int button) {
        MicrochipMenu menu = this.menu();
        ItemStack carried = menu.getCarried();
        LogicEntry logic = this.context.logic();
        boolean shift = Screen.hasShiftDown();
        if (button == 0 && this.context.shouldInteractLogic() && carried.isEmpty()) {
            List<Wire> wiresPopped = this.microchip.components().remove(logic);
            this.microchip.markDirty();
            this.panel.wires().rebuildPaths();
            ItemStack stack = logic.toStack();
            if (!shift || TransferHelper.insert((IItemHandler)new PlayerMainInvWrapper(Minecraft.getInstance().player.getInventory()), (ItemStack)stack) <= 0) {
                menu.setCarried(stack);
                menu.setCarriedWires(logic.slot(), wiresPopped);
            }
            new PlaceTakeMicrochipObjectPacket(menu.containerId, x, y, false, true, shift).sendToServer();
            return true;
        }
        return false;
    }

    private boolean placeNote(int x, int y, int button) {
        boolean rightClick;
        MicrochipMenu menu = this.menu();
        ItemStack carried = menu.getCarried();
        LocalPlayer player = this.screen.getMinecraft().player;
        boolean leftClick = button == 0;
        boolean bl = rightClick = button == 1;
        if ((leftClick || rightClick) && carried.getItem() instanceof StickyNoteItem && this.context.shouldInteractBoard()) {
            StickyNoteEntry stickyNote;
            int placeY;
            int placeX = Screen.hasControlDown() ? MicrochipScreen.getGridSnappedCoord(x) : x - 8;
            int n = placeY = Screen.hasControlDown() ? MicrochipScreen.getGridSnappedCoord(y) : y - 8;
            if (this.microchip.size().bounds().normalize().contains(new Bounds(placeX, placeY, 16, 16)) && (stickyNote = this.microchip.stickyNotes().add(placeX, placeY, carried)) != null) {
                this.microchip.markDirty();
                if (!player.hasInfiniteMaterials() || leftClick) {
                    carried.shrink(1);
                }
                new PlaceTakeMicrochipObjectPacket(menu.containerId, placeX, placeY, true, leftClick, Screen.hasShiftDown()).sendToServer();
                return true;
            }
        }
        return false;
    }

    private boolean placeWire(int x, int y, int button) {
        MicrochipMenu menu = this.menu();
        ItemStack carried = menu.getCarried();
        LogicSelectedPort port = this.context.port();
        if (carried.is(LBRItems.REDSTONE_BIT.asItem()) && this.hasSelectedPort()) {
            if (button == 0 && this.context.shouldInteractPort() && this.context.isPortInput() && this.context.isPortEmpty() && this.microchip.wires().add(this.selectedPort, port)) {
                this.microchip.markDirty();
                carried.consume(1, (LivingEntity)this.screen.getMinecraft().player);
                new PlaceTakeMicrochipWirePacket(menu.containerId, this.selectedPort, port, true).sendToServer();
                if (carried.isEmpty()) {
                    this.selectedPort = null;
                }
            } else {
                this.selectedPort = null;
            }
            return true;
        }
        return false;
    }

    private boolean placeLogic(int x, int y, int button) {
        boolean rightClick;
        MicrochipMenu menu = this.menu();
        ItemStack carried = menu.getCarried();
        LocalPlayer player = this.screen.getMinecraft().player;
        boolean leftClick = button == 0;
        boolean bl = rightClick = button == 1;
        if ((leftClick || rightClick) && carried.has(LBRComponents.LOGIC) && this.context.shouldInteractBoard()) {
            LogicEntry logic;
            int placeY;
            LogicComponent component = (LogicComponent)carried.get(LBRComponents.LOGIC);
            int placeX = Screen.hasControlDown() ? MicrochipScreen.getGridSnappedCoord(component.size().topLeftCornerX(x) + 8) : component.size().topLeftCornerX(x);
            int n = placeY = Screen.hasControlDown() ? MicrochipScreen.getGridSnappedCoord(component.size().topLeftCornerY(y) + 8) : component.size().topLeftCornerY(y);
            if (this.microchip.size().bounds().normalize().contains(component.size().toBounds(placeX, placeY)) && (logic = this.microchip.components().add(placeX, placeY, component)) != null) {
                menu.placeCarriedWires(logic.slot());
                this.microchip.markDirty();
                this.panel.wires().rebuildPaths();
                if (!player.hasInfiniteMaterials() || leftClick) {
                    carried.shrink(1);
                }
                new PlaceTakeMicrochipObjectPacket(menu.containerId, placeX, placeY, true, leftClick, Screen.hasShiftDown()).sendToServer();
                return true;
            }
        }
        return false;
    }

    private boolean openLogicConfig(int x, int y, int button) {
        MicrochipMenu menu = this.menu();
        ItemStack carried = menu.getCarried();
        LogicEntry logic = this.context.logic();
        if (button == 1 && this.context.shouldInteractLogic() && carried.isEmpty() && ((LogicConfig)logic.component().config()).hasMenu()) {
            new OpenLogicConfigPacket(menu.containerId, logic.slot(), this.viewPosition).sendToServer();
            return true;
        }
        return false;
    }

    private boolean openNote(int x, int y, int button) {
        MicrochipMenu menu = this.menu();
        ItemStack carried = menu.getCarried();
        LocalPlayer player = this.screen.getMinecraft().player;
        StickyNoteEntry note = this.context.note();
        if (button == 1 && this.context.shouldInteractNote() && carried.isEmpty()) {
            ((LBRProxy)Proxies.get(LBRProxy.class)).openStickyNote(new MicrochipStickyNoteReference(note), true);
            return true;
        }
        return false;
    }

    private boolean mouseClickedOnBoard(int mouseX, int mouseY, int boardMouseX, int boardMouseY, int button) {
        this.context = MicrochipWidgetContext.test(this, this.panel, mouseX, mouseY, boardMouseX, boardMouseY, this.context);
        return this.dyeComponent(boardMouseX, boardMouseY, button) || this.pickupNote(boardMouseX, boardMouseY, button) || this.pickupWire(boardMouseX, boardMouseY, button) || this.pickupLogic(boardMouseX, boardMouseY, button) || this.placeNote(boardMouseX, boardMouseY, button) || this.placeWire(boardMouseX, boardMouseY, button) || this.placeLogic(boardMouseX, boardMouseY, button) || this.openLogicConfig(boardMouseX, boardMouseY, button) || this.openNote(boardMouseX, boardMouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.allowDragging) {
            this.viewPosition.pan(dragX, dragY);
            return true;
        }
        return false;
    }

    public boolean mouseClicked(double mx, double my, int button) {
        int mouseX = (int)mx;
        int mouseY = (int)my;
        if (this.isMouseOver(mouseX, mouseY)) {
            int boardMouseY;
            MicrochipSize size = this.microchip.size();
            int boardMouseX = size.boardCoord(this.toLocalX(mouseX), this.viewPosition.zoom(), this.viewPosition.x());
            this.allowDragging = !this.mouseClickedOnBoard(mouseX, mouseY, boardMouseX, boardMouseY = size.boardCoord(this.toLocalY(mouseY), this.viewPosition.zoom(), this.viewPosition.y()), button);
            return this.allowDragging;
        }
        if (this.hasSelectedPort()) {
            this.selectedPort = null;
            return true;
        }
        return false;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.context.isOnBoard()) {
            this.viewPosition.zoom(scrollY > 0.0 ? 0.25f : -0.25f, mouseX, mouseY);
            return true;
        }
        return false;
    }

    public void render(GuiGraphics vanilla, int mouseX, int mouseY, float partialTick) {
        MicrochipSize size = this.microchip.size();
        int boardMouseX = size.boardCoord(this.toLocalX(mouseX), this.viewPosition.zoom(), this.viewPosition.x());
        int boardMouseY = size.boardCoord(this.toLocalY(mouseY), this.viewPosition.zoom(), this.viewPosition.y());
        this.context = MicrochipWidgetContext.test(this, this.panel, mouseX, mouseY, boardMouseX, boardMouseY, this.context);
        TesseractGuiGraphics graphics = new TesseractGuiGraphics(vanilla);
        vanilla.enableScissor(this.x, this.y, this.x + MicrochipBlockEntity.CIRCUIT_BOUNDS.width(), this.y + MicrochipBlockEntity.CIRCUIT_BOUNDS.height());
        graphics.pose().pushPose();
        graphics.pose().translate((float)this.x, (float)this.y, 0.0f);
        graphics.pose().scale(this.microchip.size().scale(), this.microchip.size().scale(), 1.0f);
        graphics.pose().scale(this.viewPosition.zoom(), this.viewPosition.zoom(), 1.0f);
        graphics.pose().translate(-this.viewPosition.x(), -this.viewPosition.y(), 0.0);
        this.panel.render(graphics);
        graphics.pose().popPose();
        vanilla.disableScissor();
        this.renderTooltip(graphics);
    }

    private void renderTooltip(TesseractGuiGraphics graphics) {
        if (this.context.shouldRenderTooltip()) {
            int x = this.x + this.microchip.size().scale(this.microchip.size().bounds().width()) + 10 + 4;
            int y = this.y + 4;
            if (this.context.hasNote()) {
                StickyNoteEntry entry = this.context.note();
                StickyNote note = entry.note();
                if (!note.isEmpty()) {
                    int minWidth = graphics.guiWidth() - x - 6;
                    graphics.setColor(LBRColors.stickyNoteText(entry.textColor()));
                    graphics.setStringDropShadow(false);
                    graphics.setTooltipFirstLinePadded(false);
                    graphics.setTooltipBackgroundPadding(4, 21, 4, 4);
                    graphics.renderTooltipBounded(List.of(note.parsed()), x, y, minWidth, minWidth / 2, graphics.guiWidth(), graphics.guiHeight(), LBR.id("textures/gui/sticky_note/background_%s.png".formatted(entry.noteColor().getName())), 64, 64, 21);
                    graphics.resetTooltipBackgroundPadding();
                    graphics.setTooltipFirstLinePadded(true);
                    graphics.setStringDropShadow(true);
                    graphics.resetColor();
                }
            } else if (this.context.hasLogic()) {
                LogicComponent component = this.context.logic().component();
                ArrayList lines = Lists.newArrayList();
                lines.add(component.type().displayName().withStyle(Style.EMPTY.withUnderlined(Boolean.valueOf(true))));
                component.type().tooltip(component, false, true, false).ifPresent(lines::addAll);
                if (((LogicConfig)component.config()).hasMenu()) {
                    lines.add(Component.empty());
                    lines.add(LBRText.LOGIC_CONFIG_TOOLTIP_CLICK_TO_OPEN.text().withStyle(LBRTooltips.DEFAULT_STYLE));
                }
                LogicModelColorSet colorSet = LogicBakingModelData.get(component).getColorSet(component, this.color());
                int backgroundColor = colorSet.background();
                int borderColor = colorSet.foreground();
                graphics.renderTooltip((List)lines, x, y, backgroundColor, backgroundColor, borderColor, borderColor);
                if (this.microchip.isDebug()) {
                    graphics.pose().pushPose();
                    graphics.pose().translate((float)(this.x + 211), (float)(this.y + 139), 0.0f);
                    graphics.pose().scale(2.0f, 2.0f, 2.0f);
                    graphics.enableBatching();
                    LogicRenderer.Context context = LogicRenderer.Context.create(this.color(), component, this.menu().getCarriedWires() != null, this.hasSelectedPort(), false);
                    LogicRenderers.render(context, graphics, component, 0, 0);
                    graphics.drawBatches();
                    graphics.pose().popPose();
                }
            }
        }
    }

    public void setFocused(boolean focused) {
        this.focused = focused;
    }

    public boolean isFocused() {
        return this.focused;
    }

    public NarratableEntry.NarrationPriority narrationPriority() {
        return NarratableEntry.NarrationPriority.NONE;
    }

    public void updateNarration(NarrationElementOutput narrationElementOutput) {
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return this.getRectangle().containsPoint((int)mouseX, (int)mouseY);
    }

    public ScreenRectangle getRectangle() {
        return new ScreenRectangle(this.x, this.y, this.microchip.size().scale(this.width), this.microchip.size().scale(this.height));
    }

    public int toLocalX(int x) {
        return x - this.x;
    }

    public int toLocalY(int y) {
        return y - this.y;
    }
}

