/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.gui.stickynote.view;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.swedz.little_big_redstone.LBRText;
import net.swedz.little_big_redstone.client.StickyNoteViewRenderer;
import net.swedz.little_big_redstone.entity.stickynote.StickyNoteView;
import net.swedz.little_big_redstone.gui.stickynote.StickyNoteScreen;
import net.swedz.little_big_redstone.gui.stickynote.edit.StickyNoteEditScreen;
import net.swedz.little_big_redstone.gui.stickynote.reference.StickyNoteReference;
import net.swedz.little_big_redstone.item.stickynote.StickyNote;
import net.swedz.tesseract.neoforge.helper.guigraphics.TesseractGuiGraphics;

public final class StickyNoteViewScreen
extends StickyNoteScreen {
    private final Component text;
    private Button doneButton;
    private Button editButton;

    public StickyNoteViewScreen(StickyNoteReference reference) {
        super(reference);
        this.text = StickyNote.parse(reference.text());
    }

    @Override
    protected void init() {
        super.init();
        this.doneButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, b -> this.close()).bounds(this.leftPos, this.topPos + this.uiHeight - 20, 87, 20).build());
        this.editButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)LBRText.STICKY_NOTE_EDIT.text(), b -> this.edit()).bounds(this.leftPos + 87 + 6, this.topPos + this.uiHeight - 20, 87, 20).build());
    }

    private void close() {
        this.minecraft.setScreen(null);
    }

    private void edit() {
        this.minecraft.setScreen((Screen)new StickyNoteEditScreen(this.reference, true));
    }

    public void render(GuiGraphics vanilla, int mouseX, int mouseY, float partialTick) {
        super.render(vanilla, mouseX, mouseY, partialTick);
        TesseractGuiGraphics graphics = new TesseractGuiGraphics(vanilla);
        graphics.pose().pushPose();
        graphics.pose().translate((float)this.leftPos, (float)this.topPos, 0.0f);
        StickyNoteViewRenderer.renderText(graphics, new StickyNoteView(this.color, this.textColor, this.text));
        graphics.pose().popPose();
    }
}

