/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.guide;

import guideme.color.SymbolicColor;
import guideme.internal.GuideMEClient;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.swedz.little_big_redstone.LBR;
import net.swedz.little_big_redstone.LBRText;
import net.swedz.tesseract.neoforge.helper.guigraphics.TesseractGuiGraphics;

public final class PausePlayGuideIconButton
extends Button {
    private static final int WIDTH = 16;
    private static final int HEIGHT = 16;
    private boolean playing = true;

    public PausePlayGuideIconButton(int x, int y, Runnable callback) {
        this(x, y, (PausePlayGuideIconButton __) -> callback.run());
    }

    public PausePlayGuideIconButton(int x, int y, Consumer<PausePlayGuideIconButton> callback) {
        super(x, y, 16, 16, (Component)LBRText.GUIDE_BUTTON_PAUSE.text(), b -> {
            PausePlayGuideIconButton button = (PausePlayGuideIconButton)b;
            button.toggle();
            callback.accept(button);
        }, Supplier::get);
        this.setTooltip(Tooltip.create((Component)this.getMessage()));
    }

    private void toggle() {
        this.playing = !this.playing;
        this.setMessage((Component)(this.playing ? LBRText.GUIDE_BUTTON_PAUSE.text() : LBRText.GUIDE_BUTTON_RESUME.text()));
        this.setTooltip(Tooltip.create((Component)this.getMessage()));
    }

    public boolean isPlaying() {
        return this.playing;
    }

    public void renderWidget(GuiGraphics vanilla, int mouseX, int mouseY, float partialTick) {
        TesseractGuiGraphics graphics = new TesseractGuiGraphics(vanilla);
        SymbolicColor color = SymbolicColor.ICON_BUTTON_NORMAL;
        if (!this.isActive()) {
            color = SymbolicColor.ICON_BUTTON_DISABLED;
        } else if (this.isHovered()) {
            color = SymbolicColor.ICON_BUTTON_HOVER;
        }
        int resolved = color.resolve(GuideMEClient.currentLightDarkMode());
        graphics.setTextures(new ResourceLocation[]{LBR.id("textures/gui/guide/buttons.png")});
        graphics.blit(this.getX(), this.getY(), this.playing ? 0.0f : 16.0f, 0.0f, 16, 16, 64, 64, resolved);
    }
}

