/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.guide.tags.block;

import guideme.PageAnchor;
import guideme.compiler.PageCompiler;
import guideme.compiler.ParsedGuidePage;
import guideme.compiler.tags.BlockTagCompiler;
import guideme.document.block.AlignItems;
import guideme.document.block.LytBlock;
import guideme.document.block.LytBlockContainer;
import guideme.document.block.LytHBox;
import guideme.document.block.LytList;
import guideme.document.block.LytListItem;
import guideme.document.block.LytParagraph;
import guideme.document.flow.LytFlowContent;
import guideme.document.flow.LytFlowLink;
import guideme.indices.CategoryIndex;
import guideme.internal.util.NavigationUtil;
import guideme.libs.mdast.mdx.model.MdxJsxElementFields;
import guideme.navigation.NavigationNode;
import guideme.scene.LytItemImage;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import net.minecraft.world.item.ItemStack;

public final class LogicIndexTagCompiler
extends BlockTagCompiler {
    private static final Comparator<NavigationNode> ALPHABETICAL_COMPARATOR = Comparator.comparing(NavigationNode::title);

    public Set<String> getTagNames() {
        return Set.of("LogicIndex");
    }

    protected void compile(PageCompiler compiler, LytBlockContainer parent, MdxJsxElementFields el) {
        List categories = ((CategoryIndex)compiler.getIndex(CategoryIndex.class)).get((Object)"logic");
        LytList list = new LytList(false, 0);
        for (PageAnchor pageAnchor : categories) {
            LytParagraph listItemPar;
            ParsedGuidePage page = compiler.getPageCollection().getParsedPage(pageAnchor.pageId());
            LytListItem listItem = new LytListItem();
            LytParagraph listItemBlock = listItemPar = new LytParagraph();
            if (page == null) {
                listItemPar.appendText("Unknown page id: " + String.valueOf(pageAnchor.pageId()));
            } else {
                LytFlowLink link = new LytFlowLink();
                link.setClickCallback(screen -> screen.navigateTo(pageAnchor));
                link.appendText(page.getFrontmatter().navigationEntry().title());
                listItemPar.append((LytFlowContent)link);
                ItemStack itemIcon = NavigationUtil.createNavigationIcon((ParsedGuidePage)page);
                if (!itemIcon.isEmpty()) {
                    LytHBox lytHBox = new LytHBox();
                    LytItemImage icon = new LytItemImage();
                    icon.setItem(itemIcon);
                    icon.setScale(0.5f);
                    icon.setMarginRight(2);
                    lytHBox.append((LytBlock)icon);
                    lytHBox.append((LytBlock)listItemPar);
                    lytHBox.setAlignItems(AlignItems.CENTER);
                    listItemBlock = lytHBox;
                }
            }
            listItem.append((LytBlock)listItemBlock);
            list.append((LytBlock)listItem);
        }
        parent.append((LytBlock)list);
    }
}

