/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.item.stickynote;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public final class StickyNote {
    private static final Pattern MARKDOWN_PATTERN = Pattern.compile("(?<!\\*)\\*\\*\\*(?<bolditalic>.+?)\\*\\*\\*(?!\\*)|(?<!\\*)\\*\\*(?<bold>.+?)\\*\\*(?!\\*)|(?<!\\*)\\*(?<italic>.+?)\\*(?!\\*)|(?<!_)__(?<underline>.+?)__(?!_)|(?<!~)~~(?<strikethrough>.+?)~~(?!~)");
    public static final StickyNote EMPTY = new StickyNote("");
    public static final Codec<StickyNote> CODEC = Codec.STRING.xmap(StickyNote::new, StickyNote::text);
    public static final StreamCodec<ByteBuf, StickyNote> STREAM_CODEC = ByteBufCodecs.STRING_UTF8.map(StickyNote::new, StickyNote::text);
    private final String text;
    private Component parsed;

    public static MutableComponent parse(String text) {
        MutableComponent result = Component.empty();
        Matcher matcher = MARKDOWN_PATTERN.matcher(text);
        int lastEndIndex = 0;
        while (matcher.find()) {
            if (matcher.start() > lastEndIndex) {
                result = result.append((Component)Component.literal((String)text.substring(lastEndIndex, matcher.start())));
            }
            Style style = Style.EMPTY;
            String matchedText = matcher.group("bolditalic");
            if (matchedText != null) {
                style = style.withBold(Boolean.valueOf(true)).withItalic(Boolean.valueOf(true));
            } else {
                matchedText = matcher.group("bold");
                if (matchedText != null) {
                    style = style.withBold(Boolean.valueOf(true));
                } else {
                    matchedText = matcher.group("italic");
                    if (matchedText != null) {
                        style = style.withItalic(Boolean.valueOf(true));
                    } else {
                        matchedText = matcher.group("underline");
                        if (matchedText != null) {
                            style = style.withUnderlined(Boolean.valueOf(true));
                        } else {
                            matchedText = matcher.group("strikethrough");
                            if (matchedText != null) {
                                style = style.withStrikethrough(Boolean.valueOf(true));
                            }
                        }
                    }
                }
            }
            if (matchedText != null) {
                result = result.append((Component)StickyNote.parse(matchedText).withStyle(style));
            }
            lastEndIndex = matcher.end();
        }
        if (lastEndIndex < text.length()) {
            result = result.append((Component)Component.literal((String)text.substring(lastEndIndex)));
        }
        return result;
    }

    public StickyNote(String text) {
        this.text = text;
    }

    public String text() {
        return this.text;
    }

    public boolean isEmpty() {
        return this.text.isEmpty();
    }

    public Component parsed() {
        if (this.parsed == null) {
            this.parsed = StickyNote.parse(this.text);
        }
        return this.parsed;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        StickyNote other = (StickyNote)o;
        return Objects.equals(this.text, other.text);
    }

    public int hashCode() {
        return Objects.hash(this.text);
    }
}

