/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.microchip.awareness;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.swedz.little_big_redstone.microchip.Microchip;
import net.swedz.little_big_redstone.microchip.awareness.AwarenessContext;
import net.swedz.little_big_redstone.microchip.awareness.AwarenessListener;
import net.swedz.little_big_redstone.microchip.awareness.AwarenessType;
import net.swedz.little_big_redstone.microchip.awareness.MicrochipAware;
import net.swedz.little_big_redstone.microchip.awareness.MicrochipAwareness;
import net.swedz.little_big_redstone.microchip.object.logic.LogicEntry;

public final class MicrochipAwarenesses
implements AwarenessListener {
    private final Map<AwarenessType<?>, MicrochipAwareness<?>> awarenesses = Maps.newHashMap();

    public <A extends MicrochipAwareness<A>> A get(AwarenessType<A> type) {
        return (A)this.awarenesses.get(type);
    }

    public void rebuild(Microchip microchip) {
        HashSet irrelevantTypes = Sets.newHashSet(this.awarenesses.keySet());
        for (LogicEntry entry : microchip.components()) {
            AwarenessType<?>[] awarenessTypeArray = entry.component();
            if (!(awarenessTypeArray instanceof MicrochipAware)) continue;
            MicrochipAware aware = (MicrochipAware)awarenessTypeArray;
            for (AwarenessType<?> type : aware.awarenessTypes()) {
                if (!this.awarenesses.containsKey(type)) {
                    this.awarenesses.put(type, (MicrochipAwareness<?>)type.create());
                }
                irrelevantTypes.remove(type);
            }
        }
        for (AwarenessType type : irrelevantTypes) {
            this.awarenesses.remove(type);
        }
    }

    @Override
    public void load(Microchip microchip) {
        for (MicrochipAwareness<?> awareness : this.awarenesses.values()) {
            awareness.load(microchip);
        }
    }

    @Override
    public void neighborChanged(AwarenessContext context, Block neighborBlock, BlockPos neighborPos, Direction neighborDirection, boolean movedByPiston) {
        for (MicrochipAwareness<?> awareness : this.awarenesses.values()) {
            awareness.neighborChanged(context, neighborBlock, neighborPos, neighborDirection, movedByPiston);
        }
    }

    @Override
    public void preTick(AwarenessContext context) {
        for (MicrochipAwareness<?> awareness : this.awarenesses.values()) {
            awareness.preTick(context);
        }
    }

    @Override
    public void postTick(AwarenessContext context, boolean microchipDirty, boolean contextDirty) {
        for (MicrochipAwareness<?> awareness : this.awarenesses.values()) {
            awareness.postTick(context, microchipDirty, contextDirty);
        }
    }
}

