/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.microchip.object.logic.gate;

import com.mojang.serialization.MapCodec;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.DyeColor;
import net.swedz.little_big_redstone.LBRText;
import net.swedz.little_big_redstone.LBRTextLine;
import net.swedz.little_big_redstone.microchip.object.logic.LogicContext;
import net.swedz.little_big_redstone.microchip.object.logic.LogicType;
import net.swedz.little_big_redstone.microchip.object.logic.LogicTypes;
import net.swedz.little_big_redstone.microchip.object.logic.gate.LogicGate;
import net.swedz.little_big_redstone.microchip.object.logic.gate.config.SingleLogicGateConfig;

public final class NOTGate
extends LogicGate<NOTGate, SingleLogicGateConfig> {
    public static final MapCodec<NOTGate> CODEC = NOTGate.mapCodec(NOTGate::new);
    public static final StreamCodec<ByteBuf, NOTGate> STREAM_CODEC = NOTGate.streamCodec(NOTGate::new);

    private NOTGate(Optional<DyeColor> color, boolean outputState) {
        super(color, outputState);
    }

    public NOTGate() {
        this(Optional.empty(), false);
    }

    @Override
    protected SingleLogicGateConfig defaultConfig() {
        return new SingleLogicGateConfig();
    }

    @Override
    public LogicType<NOTGate> type() {
        return LogicTypes.NOT;
    }

    @Override
    public boolean processInputs(LogicContext context, boolean[] inputs) {
        return !inputs[0];
    }

    @Override
    public void appendNoShiftHoverText(List<Component> lines) {
        lines.add((Component)LBRTextLine.line(LBRText.LOGIC_GATE_ALGEBRA).arg(LBRText.LOGIC_GATE_ALGEBRA_NOT.text()));
    }

    @Override
    public void appendShiftHoverText(List<Component> lines) {
        lines.add((Component)LBRTextLine.line(LBRText.LOGIC_HELP_NOT_GATE));
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.type(), this.color);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof NOTGate)) return false;
        NOTGate other = (NOTGate)o;
        if (!Objects.equals(this.color, other.color)) return false;
        return true;
    }
}

