/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.microchip.object.logic.gate.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.swedz.little_big_redstone.LBRText;
import net.swedz.little_big_redstone.LBRTextLine;
import net.swedz.little_big_redstone.microchip.object.logic.config.LogicConfig;
import net.swedz.little_big_redstone.microchip.object.logic.config.LogicConfigMenuBuilder;
import net.swedz.tesseract.neoforge.api.range.IntRange;

public final class MultiLogicGateConfig
extends LogicConfig<MultiLogicGateConfig> {
    public static final Codec<MultiLogicGateConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.optionalFieldOf("input_count", (Object)2).forGetter(config -> config.inputs)).apply((Applicative)instance, MultiLogicGateConfig::new));
    public static final StreamCodec<ByteBuf, MultiLogicGateConfig> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, config -> config.inputs, MultiLogicGateConfig::new);
    public int inputs;

    private MultiLogicGateConfig(int inputs) {
        this.inputs = inputs;
    }

    public MultiLogicGateConfig() {
        this.inputs = this.inputsAllowed().min();
    }

    @Override
    public IntRange inputsAllowed() {
        return new IntRange(2, 10);
    }

    @Override
    public int inputs() {
        return this.inputs;
    }

    @Override
    public IntRange outputsAllowed() {
        return new IntRange(1, 1);
    }

    @Override
    public int outputs() {
        return 1;
    }

    @Override
    public void appendHoverText(List<Component> lines) {
        lines.add((Component)LBRTextLine.line(LBRText.LOGIC_CONFIG_TOOLTIP_INPUTS).arg(this.inputs));
    }

    @Override
    public boolean hasMenu() {
        return true;
    }

    @Override
    public void buildMenu(LogicConfigMenuBuilder builder, int width, int height) {
        builder.addSlider((Component)LBRText.LOGIC_CONFIG_BUTTON_LABEL_INPUTS.text(), (Component)Component.empty(), (Component)LBRText.LOGIC_CONFIG_BUTTON_TOOLTIP_INPUTS.text(), 0, 0, width, 18, this.inputsAllowed().min(), this.inputsAllowed().max(), this.inputs, 1.0, 0, value -> {
            this.inputs = value.intValue();
        });
    }

    @Override
    protected void internalLoadFrom(MultiLogicGateConfig other) {
        this.inputs = this.inputsAllowed().clamp(other.inputs);
    }

    @Override
    public void resetForPickup() {
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.inputs);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof MultiLogicGateConfig)) return false;
        MultiLogicGateConfig other = (MultiLogicGateConfig)o;
        if (this.inputs != other.inputs) return false;
        return true;
    }
}

