/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.microchip.object.logic.selector;

import com.google.common.base.Objects;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.DyeColor;
import net.swedz.little_big_redstone.LBRText;
import net.swedz.little_big_redstone.LBRTextLine;
import net.swedz.little_big_redstone.microchip.object.logic.LogicComponent;
import net.swedz.little_big_redstone.microchip.object.logic.LogicContext;
import net.swedz.little_big_redstone.microchip.object.logic.LogicGridSize;
import net.swedz.little_big_redstone.microchip.object.logic.LogicType;
import net.swedz.little_big_redstone.microchip.object.logic.LogicTypes;
import net.swedz.little_big_redstone.microchip.object.logic.selector.LogicSelectorConfig;
import net.swedz.little_big_redstone.microchip.object.logic.selector.LogicSelectorMode;

public final class LogicSelector
extends LogicComponent<LogicSelector, LogicSelectorConfig> {
    public static final MapCodec<LogicSelector> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)LogicSelectorConfig.CODEC.fieldOf("config").forGetter(LogicComponent::config), (App)DyeColor.CODEC.optionalFieldOf("color").forGetter(LogicComponent::color), (App)Codec.INT.optionalFieldOf("selected", (Object)0).forGetter(LogicSelector::selected)).apply((Applicative)instance, LogicSelector::new));
    public static final StreamCodec<ByteBuf, LogicSelector> STREAM_CODEC = StreamCodec.composite(LogicSelectorConfig.STREAM_CODEC, LogicComponent::config, (StreamCodec)ByteBufCodecs.optional((StreamCodec)DyeColor.STREAM_CODEC), LogicComponent::color, (StreamCodec)ByteBufCodecs.VAR_INT, LogicSelector::selected, LogicSelector::new);
    private int selected;

    private LogicSelector(LogicSelectorConfig config, Optional<DyeColor> color, int selected) {
        super(config, color);
        this.selected = selected;
    }

    private LogicSelector(Optional<DyeColor> color, int selected) {
        super(color);
        this.selected = selected;
    }

    public LogicSelector() {
        this(Optional.empty(), 0);
    }

    public int selected() {
        return this.selected;
    }

    @Override
    protected void processTickInternal(LogicContext context, boolean[] inputs) {
        int originalSelected = this.selected;
        if (((LogicSelectorConfig)this.config).mode == LogicSelectorMode.COUNTER) {
            boolean decrement = inputs[0];
            boolean increment = inputs[1];
            int newSelected = this.selected;
            if (decrement && --newSelected < 0) {
                newSelected = ((LogicSelectorConfig)this.config).outputs - 1;
            }
            if (increment && ++newSelected >= ((LogicSelectorConfig)this.config).outputs) {
                newSelected = 0;
            }
            this.selected = newSelected;
        } else if (((LogicSelectorConfig)this.config).mode == LogicSelectorMode.SETTER) {
            for (int index = inputs.length - 1; index >= 0; --index) {
                if (!inputs[index]) continue;
                this.selected = index;
                break;
            }
        }
        if (this.selected != originalSelected) {
            context.markDirty(this);
        }
    }

    @Override
    protected boolean outputInternal(int index) {
        return index == this.selected;
    }

    @Override
    public LogicGridSize size() {
        int outputs = this.outputs();
        return new LogicGridSize(1, Math.max(1, outputs / 2));
    }

    @Override
    public void appendShiftHoverText(List<Component> lines) {
        lines.add((Component)LBRTextLine.line(LBRText.LOGIC_HELP_SELECTOR));
    }

    @Override
    protected void internalLoadFrom(LogicSelector other) {
        this.selected = other.selected;
    }

    @Override
    protected void internalResetForPickup() {
        this.selected = 0;
    }

    @Override
    protected LogicSelectorConfig defaultConfig() {
        return new LogicSelectorConfig();
    }

    @Override
    public LogicType<LogicSelector> type() {
        return LogicTypes.SELECTOR;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.type(), this.config, this.color, this.selected});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof LogicSelector)) return false;
        LogicSelector other = (LogicSelector)o;
        if (!Objects.equal((Object)this.config, (Object)other.config)) return false;
        if (!Objects.equal((Object)this.color, (Object)other.color)) return false;
        if (this.selected != other.selected) return false;
        return true;
    }
}

