/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.microchip.object.logic.selector;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.swedz.little_big_redstone.LBRText;
import net.swedz.little_big_redstone.LBRTextLine;
import net.swedz.little_big_redstone.LBRTooltips;
import net.swedz.little_big_redstone.microchip.object.logic.config.LogicConfig;
import net.swedz.little_big_redstone.microchip.object.logic.config.LogicConfigButtonReference;
import net.swedz.little_big_redstone.microchip.object.logic.config.LogicConfigMenuBuilder;
import net.swedz.little_big_redstone.microchip.object.logic.selector.LogicSelectorMode;
import net.swedz.tesseract.neoforge.api.range.IntRange;
import net.swedz.tesseract.neoforge.helper.CodecHelper;
import net.swedz.tesseract.neoforge.tooltip.Parser;

public final class LogicSelectorConfig
extends LogicConfig<LogicSelectorConfig> {
    public static final MapCodec<LogicSelectorConfig> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CodecHelper.forLowercaseEnum(LogicSelectorMode.class).optionalFieldOf("mode", (Object)LogicSelectorMode.COUNTER).forGetter(config -> config.mode), (App)Codec.intRange((int)2, (int)10).optionalFieldOf("outputs", (Object)2).forGetter(config -> config.outputs)).apply((Applicative)instance, LogicSelectorConfig::new));
    public static final StreamCodec<ByteBuf, LogicSelectorConfig> STREAM_CODEC = StreamCodec.composite((StreamCodec)CodecHelper.forLowercaseEnumStream(LogicSelectorMode.class), config -> config.mode, (StreamCodec)ByteBufCodecs.INT, config -> config.outputs, LogicSelectorConfig::new);
    public LogicSelectorMode mode;
    public int outputs;

    private LogicSelectorConfig(LogicSelectorMode mode, int outputs) {
        this.mode = mode;
        this.outputs = outputs;
    }

    public LogicSelectorConfig() {
        this(LogicSelectorMode.COUNTER, 2);
    }

    @Override
    public void appendHoverText(List<Component> lines) {
        lines.add((Component)LBRTextLine.line(LBRText.LOGIC_CONFIG_TOOLTIP_MODE).arg((Object)this.mode, (Parser)LBRTooltips.SELECTOR_MODE_PARSER));
        lines.add((Component)LBRTextLine.line(LBRText.LOGIC_CONFIG_TOOLTIP_OUTPUTS).arg(this.outputs));
    }

    @Override
    public boolean hasMenu() {
        return true;
    }

    @Override
    public void buildMenu(LogicConfigMenuBuilder builder, int width, int height) {
        AtomicReference<LogicConfigButtonReference> modeButton = new AtomicReference<LogicConfigButtonReference>();
        modeButton.set(builder.addCycleButton((Component)LBRText.LOGIC_CONFIG_BUTTON_LABEL_MODE.text(), (Component)this.mode.tooltip().text(), 0, 0, width, 18, false, this.mode, Arrays.asList(LogicSelectorMode.values()), value -> LBRTooltips.SELECTOR_MODE_PARSER.parse((Object)value).plainCopy(), value -> {
            this.mode = value;
            if (modeButton.get() != null) {
                ((LogicConfigButtonReference)modeButton.get()).setTooltip((Component)this.mode.tooltip().text());
            }
        }));
        builder.addSlider((Component)LBRText.LOGIC_CONFIG_BUTTON_LABEL_OUTPUTS.text(), (Component)Component.empty(), (Component)LBRText.LOGIC_CONFIG_BUTTON_TOOLTIP_OUTPUTS.text(), 0, 22, width, 18, this.outputsAllowed().min(), this.outputsAllowed().max(), this.outputs, 1.0, 0, value -> {
            this.outputs = value.intValue();
        });
    }

    @Override
    protected void internalLoadFrom(LogicSelectorConfig other) {
        this.mode = other.mode;
        this.outputs = other.outputs;
    }

    @Override
    public void resetForPickup() {
    }

    @Override
    public IntRange inputsAllowed() {
        return new IntRange(2, 10);
    }

    @Override
    public int inputs() {
        return this.mode == LogicSelectorMode.COUNTER ? 2 : this.outputs;
    }

    @Override
    public IntRange outputsAllowed() {
        return new IntRange(2, 10);
    }

    @Override
    public int outputs() {
        return this.outputs;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.mode, this.outputs});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof LogicSelectorConfig)) return false;
        LogicSelectorConfig other = (LogicSelectorConfig)o;
        if (this.mode != other.mode) return false;
        if (this.outputs != other.outputs) return false;
        return true;
    }
}

