/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone;

import java.util.List;
import net.minecraft.world.item.DyeColor;
import org.apache.commons.lang3.function.TriConsumer;

public final class LBRColors {
    private static final List<DyeColor> COLORS = List.of(DyeColor.WHITE, DyeColor.LIGHT_GRAY, DyeColor.GRAY, DyeColor.BLACK, DyeColor.BROWN, DyeColor.RED, DyeColor.ORANGE, DyeColor.YELLOW, DyeColor.LIME, DyeColor.GREEN, DyeColor.CYAN, DyeColor.LIGHT_BLUE, DyeColor.BLUE, DyeColor.PURPLE, DyeColor.MAGENTA, DyeColor.PINK);
    private static final List<String> ENGLISH_NAMES = List.of("White", "Light Gray", "Gray", "Black", "Brown", "Red", "Orange", "Yellow", "Lime", "Green", "Cyan", "Light Blue", "Blue", "Purple", "Magenta", "Pink");

    public static int circuitboard(DyeColor color) {
        return 0xFF000000 | (switch (color) {
            case DyeColor.WHITE -> 8621206;
            case DyeColor.ORANGE -> 9252352;
            case DyeColor.MAGENTA -> 9579660;
            case DyeColor.LIGHT_BLUE -> 2578571;
            case DyeColor.YELLOW -> 8873737;
            case DyeColor.LIME -> 3497992;
            case DyeColor.PINK -> 10428766;
            case DyeColor.GRAY -> 5460331;
            case DyeColor.LIGHT_GRAY -> 6253179;
            case DyeColor.CYAN -> 1663854;
            case DyeColor.PURPLE -> 6496901;
            case DyeColor.BLUE -> 1056161;
            case DyeColor.BROWN -> 6958607;
            case DyeColor.GREEN -> 1399058;
            case DyeColor.RED -> 0x720000;
            case DyeColor.BLACK -> 4272975;
            default -> color.getTextColor() & 0xFFFFFF;
        });
    }

    public static int componentForeground(DyeColor color) {
        return 0xFF000000 | (switch (color) {
            case DyeColor.WHITE -> 0xEFF5FF;
            case DyeColor.ORANGE -> 16749071;
            case DyeColor.MAGENTA -> 16744695;
            case DyeColor.LIGHT_BLUE -> 7005439;
            case DyeColor.YELLOW -> 16771072;
            case DyeColor.LIME -> 10808064;
            case DyeColor.PINK -> 16759018;
            case DyeColor.GRAY -> 11054015;
            case DyeColor.LIGHT_GRAY -> 12964576;
            case DyeColor.CYAN -> 4707759;
            case DyeColor.PURPLE -> 14178303;
            case DyeColor.BLUE -> 4957937;
            case DyeColor.BROWN -> 13003290;
            case DyeColor.GREEN -> 1617711;
            case DyeColor.RED -> 0xFF0000;
            case DyeColor.BLACK -> 7499137;
            default -> color.getTextColor() & 0xFFFFFF;
        });
    }

    public static int componentBackground(DyeColor color) {
        return -16777216;
    }

    public static int stickyNoteText(DyeColor color) {
        return 0xFF000000 | color.getTextColor();
    }

    public static void forEachIndexed(TriConsumer<DyeColor, String, Integer> action) {
        for (int i = 0; i < COLORS.size(); ++i) {
            DyeColor color = COLORS.get(i);
            String englishName = ENGLISH_NAMES.get(i);
            action.accept((Object)color, (Object)englishName, (Object)i);
        }
    }
}

