/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderHighlightEvent;
import net.swedz.little_big_redstone.LBRClientRenderTypes;
import net.swedz.little_big_redstone.block.microchip.MicrochipBlock;
import net.swedz.tesseract.neoforge.helper.CubeOverlayRenderHelper;

@EventBusSubscriber(modid="little_big_redstone", bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
public final class MicrochipOverlayRenderer {
    @SubscribeEvent
    private static void onRenderBlockHighlight(RenderHighlightEvent.Block event) {
        if (Minecraft.getInstance().player.isCrouching()) {
            BlockHitResult hitResult = event.getTarget();
            Direction direction = hitResult.getDirection();
            BlockPos pos = hitResult.getBlockPos();
            Camera camera = event.getCamera();
            BlockState state = Minecraft.getInstance().level.getBlockState(pos);
            if (state.getBlock() instanceof MicrochipBlock) {
                PoseStack poseStack = event.getPoseStack();
                MultiBufferSource buffer = event.getMultiBufferSource();
                poseStack.pushPose();
                poseStack.translate((double)pos.getX() - camera.getPosition().x(), (double)pos.getY() - camera.getPosition().y(), (double)pos.getZ() - camera.getPosition().z());
                poseStack.translate(-0.005, -0.005, -0.005);
                poseStack.scale(1.01f, 1.01f, 1.01f);
                CubeOverlayRenderHelper.render((PoseStack)poseStack, (VertexConsumer)buffer.getBuffer(LBRClientRenderTypes.microchipOverlay(direction)), (Direction)direction, (float)1.0f, (float)1.0f, (float)1.0f, (int)OverlayTexture.NO_OVERLAY);
                poseStack.popPose();
            }
        }
    }
}

