/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.gui.logicarray;

import java.util.function.Supplier;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.PlayerMainInvWrapper;
import net.swedz.little_big_redstone.LBRMenus;
import net.swedz.little_big_redstone.gui.logicarray.slot.LogicArrayPlayerSlot;
import net.swedz.little_big_redstone.gui.logicarray.slot.LogicArraySlot;
import net.swedz.tesseract.neoforge.helper.TransferHelper;
import net.swedz.tesseract.neoforge.helper.gui.PlayerInventoryContainerMenu;

public final class LogicArrayMenu
extends PlayerInventoryContainerMenu {
    private final IItemHandler itemHandler;
    private final int logicArraySlot;

    public LogicArrayMenu(int containerId, Inventory playerInventory, IItemHandler itemHandler, int logicArraySlot) {
        super(LBRMenus.LOGIC_ARRAY.get(), containerId);
        this.itemHandler = itemHandler;
        this.logicArraySlot = logicArraySlot;
        LogicArrayMenu.setupLogicArrayInventory(itemHandler, x$0 -> this.addSlot(x$0), 26, 18, 4, 7);
        this.setupPlayerInventory(playerInventory, 8, 104, (container, slot, x, y) -> new LogicArrayPlayerSlot((Container)container, slot, x, y, () -> slot == logicArraySlot));
    }

    public LogicArrayMenu(int containerId, Inventory playerInventory, RegistryFriendlyByteBuf buf) {
        this(containerId, playerInventory, (IItemHandler)new ItemStackHandler(28), buf.readVarInt());
    }

    public static void setupLogicArrayInventory(IItemHandler itemHandler, SlotAdder slotAdder, Supplier<Boolean> isActive, int startX, int startY, int rows, int columns) {
        for (int row = 0; row < rows; ++row) {
            for (int column = 0; column < columns; ++column) {
                slotAdder.addSlot((Slot)new LogicArraySlot(itemHandler, column + row * columns, startX + column * 18, row * 18 + startY, isActive));
            }
        }
    }

    public static void setupLogicArrayInventory(IItemHandler itemHandler, SlotAdder slotAdder, int startX, int startY, int rows, int columns) {
        LogicArrayMenu.setupLogicArrayInventory(itemHandler, slotAdder, null, startX, startY, rows, columns);
    }

    public int getLogicArraySlot() {
        return this.logicArraySlot;
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack originalStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack stack = slot.getItem();
            originalStack = stack.copy();
            Object target = index < 28 ? new PlayerMainInvWrapper(player.getInventory()) : this.itemHandler;
            int inserted = TransferHelper.insert((IItemHandler)target, (ItemStack)stack);
            if (inserted <= 0) {
                return ItemStack.EMPTY;
            }
            stack.shrink(inserted);
            if (stack.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return originalStack;
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public static interface SlotAdder {
        public void addSlot(Slot var1);
    }
}

