/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.microchip.object.logic.gate;

import com.mojang.serialization.MapCodec;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.DyeColor;
import net.swedz.little_big_redstone.LBRText;
import net.swedz.little_big_redstone.LBRTextLine;
import net.swedz.little_big_redstone.microchip.object.logic.LogicContext;
import net.swedz.little_big_redstone.microchip.object.logic.LogicType;
import net.swedz.little_big_redstone.microchip.object.logic.LogicTypes;
import net.swedz.little_big_redstone.microchip.object.logic.gate.LogicGate;
import net.swedz.little_big_redstone.microchip.object.logic.gate.config.MultiLogicGateConfig;

public final class ORGate
extends LogicGate<ORGate, MultiLogicGateConfig> {
    public static final MapCodec<ORGate> CODEC = ORGate.mapCodec(MultiLogicGateConfig.CODEC, ORGate::new);
    public static final StreamCodec<ByteBuf, ORGate> STREAM_CODEC = ORGate.streamCodec(MultiLogicGateConfig.STREAM_CODEC, ORGate::new);

    private ORGate(MultiLogicGateConfig config, Optional<DyeColor> color, boolean outputState) {
        super(config, color, outputState);
    }

    private ORGate(Optional<DyeColor> color, boolean outputState) {
        super(color, outputState);
    }

    public ORGate() {
        this(Optional.empty(), false);
    }

    @Override
    protected MultiLogicGateConfig defaultConfig() {
        return new MultiLogicGateConfig();
    }

    @Override
    public LogicType<ORGate> type() {
        return LogicTypes.OR;
    }

    @Override
    public boolean processInputs(LogicContext context, boolean[] inputs) {
        for (boolean input : inputs) {
            if (!input) continue;
            return true;
        }
        return false;
    }

    @Override
    public void appendNoShiftHoverText(List<Component> lines) {
        lines.add((Component)LBRTextLine.line(LBRText.LOGIC_GATE_ALGEBRA).arg(LBRText.LOGIC_GATE_ALGEBRA_OR.text()));
    }

    @Override
    public void appendShiftHoverText(List<Component> lines) {
        lines.add((Component)LBRTextLine.line(LBRText.LOGIC_HELP_OR_GATE));
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.type(), this.config, this.color);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof ORGate)) return false;
        ORGate other = (ORGate)o;
        if (!Objects.equals(this.config, other.config)) return false;
        if (!Objects.equals(this.color, other.color)) return false;
        return true;
    }
}

