/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.microchip.object.logic.io;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.Mth;
import net.swedz.little_big_redstone.LBR;
import net.swedz.little_big_redstone.LBRText;
import net.swedz.little_big_redstone.LBRTextLine;
import net.swedz.little_big_redstone.LBRTooltips;
import net.swedz.little_big_redstone.microchip.object.logic.LogicComponents;
import net.swedz.little_big_redstone.microchip.object.logic.LogicEntry;
import net.swedz.little_big_redstone.microchip.object.logic.config.LogicComparisonMode;
import net.swedz.little_big_redstone.microchip.object.logic.config.LogicConfig;
import net.swedz.little_big_redstone.microchip.object.logic.config.LogicConfigButtonReference;
import net.swedz.little_big_redstone.microchip.object.logic.config.LogicConfigMenuBuilder;
import net.swedz.tesseract.neoforge.api.range.IntRange;
import net.swedz.tesseract.neoforge.helper.CodecHelper;
import net.swedz.tesseract.neoforge.tooltip.BiParser;
import net.swedz.tesseract.neoforge.tooltip.Parser;

public final class LogicIOConfig
extends LogicConfig<LogicIOConfig> {
    public static final MapCodec<LogicIOConfig> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("input", (Object)true).forGetter(config -> config.input), (App)Direction.CODEC.optionalFieldOf("direction", (Object)Direction.NORTH).forGetter(config -> config.direction), (App)Codec.intRange((int)1, (int)15).optionalFieldOf("signal_strength", (Object)1).forGetter(config -> config.signalStrength), (App)CodecHelper.forLowercaseEnum(LogicComparisonMode.class).optionalFieldOf("signal_comparison", (Object)LogicComparisonMode.GREATER_THAN_OR_EQUAL_TO).forGetter(config -> config.signalComparison)).apply((Applicative)instance, (input, direction, signalStrength, precise) -> new LogicIOConfig(true, (boolean)input, (Direction)direction, (int)signalStrength, (LogicComparisonMode)precise)));
    public static final StreamCodec<ByteBuf, LogicIOConfig> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, config -> config.valid, (StreamCodec)ByteBufCodecs.BOOL, config -> config.input, (StreamCodec)Direction.STREAM_CODEC, config -> config.direction, (StreamCodec)ByteBufCodecs.INT, config -> config.signalStrength, (StreamCodec)CodecHelper.forEnumStream(LogicComparisonMode.class), config -> config.signalComparison, LogicIOConfig::new);
    public boolean input;
    public Direction direction;
    public int signalStrength;
    public LogicComparisonMode signalComparison;

    private LogicIOConfig(boolean valid, boolean input, Direction direction, int signalStrength, LogicComparisonMode signalComparison) {
        this.valid = valid;
        this.input = input;
        this.direction = direction;
        this.signalStrength = Mth.clamp((int)signalStrength, (int)1, (int)15);
        this.signalComparison = signalComparison;
    }

    public LogicIOConfig() {
        this(true, true, Direction.NORTH, 1, LogicComparisonMode.GREATER_THAN_OR_EQUAL_TO);
    }

    @Override
    protected boolean calculateValidity(LogicComponents components) {
        for (LogicEntry entry : components) {
            Object c;
            if (entry.component().config() == this || !((c = entry.component().config()) instanceof LogicIOConfig)) continue;
            LogicIOConfig entryConfig = (LogicIOConfig)c;
            if (this.input == entryConfig.input || this.direction != entryConfig.direction) continue;
            return false;
        }
        return true;
    }

    @Override
    public IntRange inputsAllowed() {
        return this.input ? new IntRange(0, 0) : new IntRange(1, 1);
    }

    @Override
    public int inputs() {
        return this.input ? 0 : 1;
    }

    @Override
    public IntRange outputsAllowed() {
        return this.input ? new IntRange(1, 1) : new IntRange(0, 0);
    }

    @Override
    public int outputs() {
        return this.input ? 1 : 0;
    }

    @Override
    public void appendHoverText(List<Component> lines) {
        lines.add((Component)LBRTextLine.line(LBRText.LOGIC_CONFIG_TOOLTIP_MODE).arg((Object)this.input, (Parser)LBRTooltips.INPUT_OUTPUT_PARSER));
        lines.add((Component)LBRTextLine.line(LBRText.LOGIC_CONFIG_TOOLTIP_DIRECTION).arg(this.direction, (Parser)LBRTooltips.DIRECTION_PARSER));
        if (this.input) {
            lines.add((Component)LBRTextLine.line(LBRText.LOGIC_CONFIG_TOOLTIP_IO_SIGNAL).arg(this.signalComparison, (Object)this.signalStrength, (BiParser)LBRTooltips.COMPARISON_PARSER));
        } else {
            lines.add((Component)LBRTextLine.line(LBRText.LOGIC_CONFIG_TOOLTIP_IO_SIGNAL).arg(this.signalStrength));
        }
    }

    @Override
    public boolean hasMenu() {
        return true;
    }

    private LBRText signalComparisonTooltip() {
        return switch (this.signalComparison) {
            default -> throw new MatchException(null, null);
            case LogicComparisonMode.LESS_THAN_OR_EQUAL_TO -> LBRText.LOGIC_CONFIG_BUTTON_TOOLTIP_IO_SIGNAL_COMPARISON_MODE_LESS_THAN_OR_EQUAL_TO;
            case LogicComparisonMode.EQUAL_TO -> LBRText.LOGIC_CONFIG_BUTTON_TOOLTIP_IO_SIGNAL_COMPARISON_MODE_EQUAL_TO;
            case LogicComparisonMode.GREATER_THAN_OR_EQUAL_TO -> LBRText.LOGIC_CONFIG_BUTTON_TOOLTIP_IO_SIGNAL_COMPARISON_MODE_GREATER_THAN_OR_EQUAL_TO;
        };
    }

    @Override
    public void buildMenu(LogicConfigMenuBuilder builder, int width, int height) {
        AtomicReference<LogicConfigButtonReference<Double>> signalStrengthSlider = new AtomicReference<LogicConfigButtonReference<Double>>();
        AtomicReference<LogicConfigButtonReference<LogicComparisonMode>> comparisonButton = new AtomicReference<LogicConfigButtonReference<LogicComparisonMode>>();
        Runnable updateComparisonButtonTooltip = () -> {
            LogicConfigButtonReference button = (LogicConfigButtonReference)comparisonButton.get();
            if (button != null) {
                button.setTooltip((Component)(button.isActive() ? this.signalComparisonTooltip().text(new Object[]{this.signalStrength}) : LBRText.LOGIC_CONFIG_BUTTON_TOOLTIP_IO_SIGNAL_COMPARISON_OUTPUT.text(new Object[]{this.signalStrength})));
            }
        };
        builder.addCycleButton((Component)LBRText.LOGIC_CONFIG_BUTTON_LABEL_MODE.text(), (Component)LBRText.LOGIC_CONFIG_BUTTON_TOOLTIP_IO_MODE.text(), 0, 0, width, 18, false, this.input, List.of(Boolean.valueOf(true), Boolean.valueOf(false)), value -> LBRTooltips.INPUT_OUTPUT_PARSER.parse(value).plainCopy(), value -> {
            this.input = value;
            int n = this.signalStrength = this.input ? 1 : 15;
            if (signalStrengthSlider.get() != null) {
                ((LogicConfigButtonReference)signalStrengthSlider.get()).setValue(Double.valueOf(this.signalStrength));
                ((LogicConfigButtonReference)signalStrengthSlider.get()).setTooltip((Component)(this.input ? LBRText.LOGIC_CONFIG_BUTTON_TOOLTIP_IO_SIGNAL_STRENGTH_INPUT : LBRText.LOGIC_CONFIG_BUTTON_TOOLTIP_IO_SIGNAL_STRENGTH_OUTPUT).text());
            }
            if (comparisonButton.get() != null) {
                ((LogicConfigButtonReference)comparisonButton.get()).setActive(this.input);
            }
            updateComparisonButtonTooltip.run();
        });
        builder.addCycleButton((Component)LBRText.LOGIC_CONFIG_BUTTON_LABEL_DIRECTION.text(), (Component)LBRText.LOGIC_CONFIG_BUTTON_TOOLTIP_IO_DIRECTION.text(), 0, 22, width, 18, false, this.direction, Arrays.asList(Direction.values()), arg_0 -> LBRTooltips.DIRECTION_PARSER.parse(arg_0), value -> {
            this.direction = value;
        });
        signalStrengthSlider.set(builder.addSlider((Component)LBRText.LOGIC_CONFIG_BUTTON_LABEL_IO_SIGNAL_STRENGTH.text(), (Component)Component.empty(), (Component)(this.input ? LBRText.LOGIC_CONFIG_BUTTON_TOOLTIP_IO_SIGNAL_STRENGTH_INPUT : LBRText.LOGIC_CONFIG_BUTTON_TOOLTIP_IO_SIGNAL_STRENGTH_OUTPUT).text(), 22, 44, width - 18 - 4, 18, 1.0, 15.0, this.signalStrength, 1.0, 0, value -> {
            this.signalStrength = value.intValue();
            updateComparisonButtonTooltip.run();
        }));
        comparisonButton.set(builder.addCycleButton((Component)this.signalComparisonTooltip().text(new Object[]{this.signalStrength}), 0, 44, LBR.id("textures/gui/slot_atlas.png"), this.signalComparison, Arrays.asList(LogicComparisonMode.values()), value -> {
            this.signalComparison = value;
            updateComparisonButtonTooltip.run();
        }));
        ((LogicConfigButtonReference)comparisonButton.get()).setActive(this.input);
        updateComparisonButtonTooltip.run();
    }

    @Override
    protected void internalLoadFrom(LogicIOConfig other) {
        this.input = other.input;
        this.direction = other.direction;
        this.signalStrength = other.signalStrength;
        this.signalComparison = other.signalComparison;
    }

    @Override
    public void resetForPickup() {
        this.valid = true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.input, this.direction, this.signalStrength, this.signalComparison);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof LogicIOConfig)) return false;
        LogicIOConfig other = (LogicIOConfig)o;
        if (this.input != other.input) return false;
        if (this.direction != other.direction) return false;
        if (this.signalStrength != other.signalStrength) return false;
        if (this.signalComparison != other.signalComparison) return false;
        return true;
    }
}

