/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.microchip.object.logic.latch.tflipflop;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.DyeColor;
import net.swedz.little_big_redstone.LBRText;
import net.swedz.little_big_redstone.LBRTextLine;
import net.swedz.little_big_redstone.microchip.object.logic.LogicComponent;
import net.swedz.little_big_redstone.microchip.object.logic.LogicContext;
import net.swedz.little_big_redstone.microchip.object.logic.LogicType;
import net.swedz.little_big_redstone.microchip.object.logic.LogicTypes;
import net.swedz.little_big_redstone.microchip.object.logic.latch.tflipflop.TFlipFlopConfig;

public final class TFlipFlop
extends LogicComponent<TFlipFlop, TFlipFlopConfig> {
    public static final MapCodec<TFlipFlop> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DyeColor.CODEC.optionalFieldOf("color").forGetter(LogicComponent::color), (App)Codec.BOOL.optionalFieldOf("last_input", (Object)false).forGetter(TFlipFlop::lastInput), (App)Codec.BOOL.optionalFieldOf("output", (Object)false).forGetter(TFlipFlop::output)).apply((Applicative)instance, TFlipFlop::new));
    public static final StreamCodec<ByteBuf, TFlipFlop> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.optional((StreamCodec)DyeColor.STREAM_CODEC), LogicComponent::color, (StreamCodec)ByteBufCodecs.BOOL, TFlipFlop::lastInput, (StreamCodec)ByteBufCodecs.BOOL, TFlipFlop::output, TFlipFlop::new);
    private boolean lastInputState;
    private boolean outputState;

    private TFlipFlop(Optional<DyeColor> color, boolean lastInputState, boolean outputState) {
        super(color);
        this.lastInputState = lastInputState;
        this.outputState = outputState;
    }

    public TFlipFlop() {
        this(Optional.empty(), false, false);
    }

    @Override
    protected TFlipFlopConfig defaultConfig() {
        return new TFlipFlopConfig();
    }

    @Override
    public LogicType<TFlipFlop> type() {
        return LogicTypes.T_FLIP_FLOP;
    }

    @Override
    protected void processTickInternal(LogicContext context, boolean[] inputs) {
        boolean input = inputs[0];
        if (!this.lastInputState && input) {
            this.outputState = !this.outputState;
            context.markDirty(this);
        }
        this.lastInputState = input;
    }

    public boolean lastInput() {
        return this.lastInputState;
    }

    @Override
    protected boolean outputInternal(int index) {
        return this.outputState;
    }

    public boolean output() {
        return this.output(0);
    }

    @Override
    public void appendShiftHoverText(List<Component> lines) {
        lines.add((Component)LBRTextLine.line(LBRText.LOGIC_HELP_T_FLIP_FLOP));
    }

    @Override
    protected void internalLoadFrom(TFlipFlop other) {
        this.lastInputState = other.lastInputState;
        this.outputState = other.outputState;
    }

    @Override
    public void internalResetForPickup() {
        this.lastInputState = false;
        this.outputState = false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.type(), this.color);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof TFlipFlop)) return false;
        TFlipFlop other = (TFlipFlop)o;
        if (!Objects.equals(this.color, other.color)) return false;
        return true;
    }
}

