/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.network.packet;

import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.swedz.little_big_redstone.LBR;
import net.swedz.little_big_redstone.LBRItems;
import net.swedz.little_big_redstone.gui.microchip.MicrochipMenu;
import net.swedz.little_big_redstone.microchip.Microchip;
import net.swedz.little_big_redstone.microchip.object.logic.LogicComponents;
import net.swedz.little_big_redstone.microchip.object.logic.LogicEntry;
import net.swedz.little_big_redstone.microchip.wire.MicrochipWires;
import net.swedz.little_big_redstone.microchip.wire.PortReference;
import net.swedz.little_big_redstone.microchip.wire.Wire;
import net.swedz.little_big_redstone.network.LBRCustomPacket;
import net.swedz.tesseract.neoforge.packet.PacketContext;

public record PlaceTakeMicrochipWirePacket(int containerId, int outputSlot, int outputPort, int inputSlot, int inputPort, boolean place) implements LBRCustomPacket
{
    public static final StreamCodec<ByteBuf, PlaceTakeMicrochipWirePacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, PlaceTakeMicrochipWirePacket::containerId, (StreamCodec)ByteBufCodecs.VAR_INT, PlaceTakeMicrochipWirePacket::outputSlot, (StreamCodec)ByteBufCodecs.VAR_INT, PlaceTakeMicrochipWirePacket::outputPort, (StreamCodec)ByteBufCodecs.VAR_INT, PlaceTakeMicrochipWirePacket::inputSlot, (StreamCodec)ByteBufCodecs.VAR_INT, PlaceTakeMicrochipWirePacket::inputPort, (StreamCodec)ByteBufCodecs.BOOL, PlaceTakeMicrochipWirePacket::place, PlaceTakeMicrochipWirePacket::new);

    public PlaceTakeMicrochipWirePacket(int containerId, PortReference output, PortReference input, boolean place) {
        this(containerId, output.slot(), output.index(), input.slot(), input.index(), place);
    }

    public PlaceTakeMicrochipWirePacket(int containerId, Wire wire, boolean place) {
        this(containerId, wire.output().slot(), wire.output().index(), wire.input().slot(), wire.input().index(), place);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void handle(PacketContext context) {
        AbstractContainerMenu abstractContainerMenu;
        context.assertServerbound();
        ServerPlayer player = (ServerPlayer)context.getPlayer();
        String playerName = player.getGameProfile().getName();
        if (player.hasContainerOpen() && (abstractContainerMenu = player.containerMenu) instanceof MicrochipMenu) {
            MicrochipMenu menu = (MicrochipMenu)abstractContainerMenu;
            if (menu.containerId == this.containerId) {
                Microchip microchip = menu.microchip();
                LogicComponents components = microchip.components();
                MicrochipWires wires = microchip.wires();
                ItemStack heldItem = menu.getCarried();
                if (heldItem.is(LBRItems.REDSTONE_BIT.asItem())) {
                    LogicEntry outputLogic = (LogicEntry)components.get(this.outputSlot);
                    LogicEntry inputLogic = (LogicEntry)components.get(this.inputSlot);
                    if (outputLogic != null && this.outputPort < outputLogic.component().outputs() && inputLogic != null && this.inputPort < inputLogic.component().inputs()) {
                        if (this.place) {
                            if (wires.add(this.outputSlot, this.outputPort, this.inputSlot, this.inputPort)) {
                                microchip.markDirty();
                                heldItem.consume(1, (LivingEntity)player);
                                return;
                            }
                            LBR.LOGGER.warn("Received PlaceTakeMicrochipWirePacket from {} with already existing wire: {}#{} -> {}#{}, discarding", new Object[]{playerName, this.outputSlot, this.outputPort, this.inputSlot, this.inputPort});
                            return;
                        }
                        if (heldItem.getCount() >= heldItem.getMaxStackSize()) {
                            LBR.LOGGER.warn("Received PlaceTakeMicrochipWirePacket from {} with too many items: {} >= {}, discarding", new Object[]{playerName, heldItem.getCount(), heldItem.getMaxStackSize()});
                            return;
                        }
                        Wire wire = wires.get(this.outputSlot, this.outputPort, this.inputSlot, this.inputPort);
                        if (wire != null) {
                            wires.remove(wire);
                            microchip.markDirty();
                            if (player.hasInfiniteMaterials()) return;
                            heldItem.grow(1);
                            return;
                        }
                        LBR.LOGGER.warn("Received PlaceTakeMicrochipWirePacket from {} for non-existing wire: {}#{} -> {}#{}, discarding", new Object[]{playerName, this.outputSlot, this.outputPort, this.inputSlot, this.inputPort});
                        return;
                    }
                    LBR.LOGGER.warn("Received PlaceTakeMicrochipWirePacket from {} with invalid output/input parameters: {}#{} -> {}#{}, discarding", new Object[]{playerName, this.outputSlot, this.outputPort, this.inputSlot, this.inputPort});
                    return;
                }
                if (this.place) {
                    LBR.LOGGER.warn("Received PlaceTakeMicrochipWirePacket from {} without holding a microchip wire item, discarding", (Object)playerName);
                    return;
                }
                if (!heldItem.isEmpty()) {
                    LBR.LOGGER.warn("Received PlaceTakeMicrochipWirePacket from {} while holding an item other than a microchip wire item, discarding", (Object)playerName);
                    return;
                }
                Wire wire = wires.get(this.outputSlot, this.outputPort, this.inputSlot, this.inputPort);
                if (wire != null) {
                    wires.remove(wire);
                    microchip.markDirty();
                    menu.setCarried(LBRItems.REDSTONE_BIT.asItem().getDefaultInstance());
                    return;
                }
                LBR.LOGGER.warn("Received PlaceTakeMicrochipWirePacket from {} for non-existing wire: {}#{} -> {}#{}, discarding", new Object[]{playerName, this.outputSlot, this.outputPort, this.inputSlot, this.inputPort});
                return;
            }
        }
        LBR.LOGGER.warn("Received PlaceTakeMicrochipWirePacket from {} while not in a microchip menu (or in expired one?), discarding", (Object)playerName);
    }
}

