/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.recipe;

import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.swedz.little_big_redstone.LBRComponents;
import net.swedz.little_big_redstone.LBRRecipeTypes;
import net.swedz.little_big_redstone.microchip.object.logic.LogicComponent;

public final class ClearConfigRecipe
extends CustomRecipe {
    public ClearConfigRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingInput input, Level level) {
        boolean hasLogic = false;
        for (ItemStack stack : input.items()) {
            if (!stack.has(LBRComponents.LOGIC)) continue;
            if (hasLogic) {
                return false;
            }
            hasLogic = true;
        }
        return hasLogic;
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider registries) {
        for (ItemStack stack : input.items()) {
            if (!stack.has(LBRComponents.LOGIC)) continue;
            ItemStack copy = stack.copyWithCount(1);
            Object logic = ((LogicComponent)stack.get(LBRComponents.LOGIC)).copy();
            ((LogicComponent)logic).resetConfig();
            ((LogicComponent)logic).resetColor();
            copy.set(LBRComponents.LOGIC, logic);
            return copy;
        }
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height > 0;
    }

    public RecipeSerializer<?> getSerializer() {
        return LBRRecipeTypes.CLEAR_CONFIG_RECIPE_SERIALIZER.get();
    }
}

