/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.screenshotcompression_common_fabric.compression.managers;

import com.natamus.screenshotcompression_common_fabric.data.Constants;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;

public class QuantizationManager {
    public static BufferedImage applyQuantization(BufferedImage image, int numColors) {
        List<Color> colors = QuantizationManager.extractColors(image);
        List<Color> quantizedColors = QuantizationManager.medianCutQuantization(colors, numColors);
        return QuantizationManager.applyQuantizedColors(image, quantizedColors);
    }

    private static List<Color> extractColors(BufferedImage image) {
        HashSet<Color> uniqueColors = new HashSet<Color>();
        for (int x = 0; x < image.getWidth(); ++x) {
            for (int y = 0; y < image.getHeight(); ++y) {
                Color color = new Color(image.getRGB(x, y));
                uniqueColors.add(color);
            }
        }
        return new ArrayList<Color>(uniqueColors);
    }

    private static List<Color> medianCutQuantization(List<Color> colors, int numColors) {
        ArrayList<RGBColor> rgbColors = new ArrayList<RGBColor>();
        for (Color color : colors) {
            rgbColors.add(new RGBColor(color.getRed(), color.getGreen(), color.getBlue()));
        }
        List<RGBColor> reducedColors = QuantizationManager.medianCut(rgbColors, numColors);
        ArrayList<Color> quantizedColors = new ArrayList<Color>();
        for (RGBColor rgbColor : reducedColors) {
            quantizedColors.add(new Color(rgbColor.r(), rgbColor.g(), rgbColor.b()));
        }
        return quantizedColors;
    }

    private static List<RGBColor> medianCut(List<RGBColor> colors, int numColors) {
        if (colors.size() <= numColors) {
            return colors;
        }
        ArrayList<RGBColorRange> ranges = new ArrayList<RGBColorRange>();
        ranges.add(new RGBColorRange(colors));
        while (ranges.size() < numColors) {
            RGBColorRange largestRange = QuantizationManager.findLargestRange(ranges);
            ranges.remove(largestRange);
            ranges.addAll(largestRange.split());
        }
        ArrayList<RGBColor> reducedColors = new ArrayList<RGBColor>();
        for (RGBColorRange range : ranges) {
            reducedColors.add(range.getMedianColor());
        }
        return reducedColors;
    }

    private static RGBColorRange findLargestRange(List<RGBColorRange> ranges) {
        RGBColorRange largestRange = ranges.getFirst();
        for (RGBColorRange range : ranges) {
            if (range.getRangeSize() <= largestRange.getRangeSize()) continue;
            largestRange = range;
        }
        return largestRange;
    }

    private static BufferedImage applyQuantizedColors(BufferedImage image, List<Color> quantizedColors) {
        BufferedImage quantizedImage = new BufferedImage(image.getWidth(), image.getHeight(), 2);
        for (int x = 0; x < image.getWidth(); ++x) {
            for (int y = 0; y < image.getHeight(); ++y) {
                Color originalColor = new Color(image.getRGB(x, y));
                Color closestColor = QuantizationManager.findClosestColor(originalColor, quantizedColors);
                quantizedImage.setRGB(x, y, closestColor.getRGB());
            }
        }
        return quantizedImage;
    }

    private static Color findClosestColor(Color targetColor, List<Color> palette) {
        Color closestColor = palette.getFirst();
        double closestDistance = QuantizationManager.getColorDistance(targetColor, closestColor);
        for (Color color : palette) {
            double distance = QuantizationManager.getColorDistance(targetColor, color);
            if (!(distance < closestDistance)) continue;
            closestColor = color;
            closestDistance = distance;
        }
        return closestColor;
    }

    private static double getColorDistance(Color c1, Color c2) {
        int rDiff = c1.getRed() - c2.getRed();
        int gDiff = c1.getGreen() - c2.getGreen();
        int bDiff = c1.getBlue() - c2.getBlue();
        return Math.sqrt(rDiff * rDiff + gDiff * gDiff + bDiff * bDiff);
    }

    private record RGBColor(int r, int g, int b) {
    }

    private record RGBColorRange(List<RGBColor> colors) {
        public Collection<? extends RGBColorRange> split() {
            int maxDimension = this.findMaxDimension();
            this.colors.sort(Comparator.comparingInt(color -> this.getDimensionValue((RGBColor)color, maxDimension)));
            int mid = this.colors.size() / 2;
            List<RGBColor> left = this.colors.subList(0, mid);
            List<RGBColor> right = this.colors.subList(mid, this.colors.size());
            ArrayList<RGBColorRange> ranges = new ArrayList<RGBColorRange>();
            ranges.add(new RGBColorRange(left));
            ranges.add(new RGBColorRange(right));
            return ranges;
        }

        public RGBColor getMedianColor() {
            int mid = this.colors.size() / 2;
            return this.colors.get(mid);
        }

        public int getRangeSize() {
            int rMin = Integer.MAX_VALUE;
            int gMin = Integer.MAX_VALUE;
            int bMin = Integer.MAX_VALUE;
            int rMax = Integer.MIN_VALUE;
            int gMax = Integer.MIN_VALUE;
            int bMax = Integer.MIN_VALUE;
            for (RGBColor color : this.colors) {
                rMin = Math.min(rMin, color.r());
                gMin = Math.min(gMin, color.g());
                bMin = Math.min(bMin, color.b());
                rMax = Math.max(rMax, color.r());
                gMax = Math.max(gMax, color.g());
                bMax = Math.max(bMax, color.b());
            }
            return rMax - rMin + (gMax - gMin) + (bMax - bMin);
        }

        private int findMaxDimension() {
            int rMin = Integer.MAX_VALUE;
            int gMin = Integer.MAX_VALUE;
            int bMin = Integer.MAX_VALUE;
            int rMax = Integer.MIN_VALUE;
            int gMax = Integer.MIN_VALUE;
            int bMax = Integer.MIN_VALUE;
            for (RGBColor color : this.colors) {
                rMin = Math.min(rMin, color.r());
                gMin = Math.min(gMin, color.g());
                bMin = Math.min(bMin, color.b());
                rMax = Math.max(rMax, color.r());
                gMax = Math.max(gMax, color.g());
                bMax = Math.max(bMax, color.b());
            }
            int rRange = rMax - rMin;
            int gRange = gMax - gMin;
            int bRange = bMax - bMin;
            if (rRange >= gRange && rRange >= bRange) {
                return 0;
            }
            if (gRange >= bRange) {
                return 1;
            }
            return 2;
        }

        private int getDimensionValue(RGBColor color, int dimension) {
            return switch (dimension) {
                case 0 -> color.r();
                case 1 -> color.g();
                case 2 -> color.b();
                default -> {
                    Constants.logger.warn("[screenshotcompression] Invalid dimension: {}", (Object)dimension);
                    yield 0;
                }
            };
        }
    }
}

