/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.screenshotcompression_common_forge.compression.managers;

import com.natamus.screenshotcompression_common_forge.data.Constants;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

public class ImageResizeManager {
    public static BufferedImage resize(BufferedImage original, int percentage) {
        if (percentage <= 0 || percentage > 100) {
            Constants.logger.warn("[screenshotcompression] Resize percentage must be between 1 and 100");
            return original;
        }
        int newWidth = original.getWidth() * percentage / 100;
        int newHeight = original.getHeight() * percentage / 100;
        BufferedImage resizedImage = new BufferedImage(newWidth, newHeight, original.getType());
        Graphics2D g2d = resizedImage.createGraphics();
        g2d.drawImage(original.getScaledInstance(newWidth, newHeight, 4), 0, 0, null);
        g2d.dispose();
        return resizedImage;
    }
}

