/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.screenshotcompression_common_neoforge.compression;

import com.natamus.screenshotcompression_common_neoforge.compression.managers.DitheringManager;
import com.natamus.screenshotcompression_common_neoforge.compression.managers.ImageResizeManager;
import com.natamus.screenshotcompression_common_neoforge.compression.managers.QuantizationManager;
import com.natamus.screenshotcompression_common_neoforge.compression.managers.StripAlphaManager;
import com.natamus.screenshotcompression_common_neoforge.config.ConfigHandler;
import com.natamus.screenshotcompression_common_neoforge.data.Constants;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.text.DecimalFormat;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageOutputStream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;

public class ImageCompressor {
    public static void runScreenshotCompressThread(File screenshotFile) {
        new Thread(() -> {
            for (int attempts = 0; attempts < 20; ++attempts) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!screenshotFile.exists() || !ImageCompressor.isValidImage(screenshotFile)) {
                    continue;
                }
                try {
                    ImageCompressor.compressPNG(screenshotFile);
                }
                catch (IOException ex) {
                    Constants.logger.warn("[screenshotcompression] Unable to compress screenshot.");
                }
                break;
            }
        }).start();
    }

    private static void compressPNG(File inputFile) throws IOException {
        File outputFile;
        if (!inputFile.exists()) {
            Constants.logger.warn("[screenshotcompression] Input file does not exist: {}", (Object)inputFile.getAbsolutePath());
            return;
        }
        double inputSize = inputFile.length();
        if (ConfigHandler.keepOriginalScreenshot) {
            File originalFolder = new File(inputFile.getParent(), "original");
            if (!originalFolder.exists()) {
                boolean bl = originalFolder.mkdirs();
            }
            File backupFile = new File(originalFolder, inputFile.getName());
            Files.copy(inputFile.toPath(), backupFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        String inputPath = inputFile.getPath();
        BufferedImage image = ImageIO.read(inputFile);
        boolean ignored = inputFile.delete();
        if (image == null) {
            Constants.logger.warn("[screenshotcompression] Failed to load the image. It might not be a valid PNG: {}", (Object)inputFile.getAbsolutePath());
            return;
        }
        if (ConfigHandler.screenshotResizePercentage != 100) {
            image = ImageResizeManager.resize(image, ConfigHandler.screenshotResizePercentage);
        }
        if (ConfigHandler.reduceGradient) {
            image = DitheringManager.applyDithering(image);
        }
        if (ConfigHandler.reduceAmountOfColours) {
            image = QuantizationManager.applyQuantization(image, ConfigHandler.reducedColourAmount);
        }
        if (ConfigHandler.stripPngAlphaChannel && image.getColorModel().hasAlpha()) {
            image = StripAlphaManager.stripAlphaChannel(image);
        }
        Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName("PNG");
        ImageWriter writer = null;
        if (writers.hasNext()) {
            writer = writers.next();
        }
        if (writer == null) {
            Constants.logger.warn("[screenshotcompression] No PNG writer found!");
            return;
        }
        IIOMetadata metadata = null;
        if (!ConfigHandler.stripScreenshotMetadata) {
            metadata = writer.getDefaultImageMetadata(ImageTypeSpecifier.createFromRenderedImage(image), null);
        }
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            try (ImageOutputStream ios = ImageIO.createImageOutputStream(byteArrayOutputStream);){
                writer.setOutput(ios);
                ImageWriteParam param = writer.getDefaultWriteParam();
                param.setCompressionMode(2);
                param.setCompressionQuality(ConfigHandler.compressionQuality);
                writer.write(null, new IIOImage(image, null, metadata), param);
            }
            outputFile = new File(inputPath);
            try (ImageOutputStream outputIOS = ImageIO.createImageOutputStream(outputFile);){
                writer.setOutput(outputIOS);
                writer.write(null, new IIOImage(image, null, metadata), null);
            }
        }
        if (!ConfigHandler.sendScreenshotCompressMessage) {
            return;
        }
        double outputSize = outputFile.length();
        String percentage = new DecimalFormat("#.00").format((1.0 - Math.abs((outputSize - inputSize) / inputSize)) * 100.0);
        Minecraft.getInstance().gui.getChat().addMessage((Component)Component.literal((String)" > Compressed screenshot output size: ").withStyle(ChatFormatting.DARK_GRAY).append((Component)Component.literal((String)(percentage + "%")).withStyle(ChatFormatting.GRAY)));
    }

    private static boolean isValidImage(File file) {
        try {
            return ImageIO.read(file) != null;
        }
        catch (IOException ex) {
            return false;
        }
    }
}

