/*
 * Decompiled with CFR 0.152.
 */
package net.essentialsx.discordlink;

import com.earth2me.essentials.IEssentialsModule;
import com.earth2me.essentials.User;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import net.ess3.api.IUser;
import net.essentialsx.api.v2.events.discordlink.DiscordLinkStatusChangeEvent;
import net.essentialsx.api.v2.services.discord.InteractionMember;
import net.essentialsx.api.v2.services.discordlink.DiscordLinkService;
import net.essentialsx.discordlink.AccountStorage;
import net.essentialsx.discordlink.EssentialsDiscordLink;
import net.essentialsx.discordlink.rolesync.RoleSyncManager;
import org.bukkit.event.Event;

public class AccountLinkManager
implements IEssentialsModule,
DiscordLinkService {
    private static final char[] CODE_CHARACTERS = "abcdefghijklmnopqrstuvwxyz0123456789".toCharArray();
    private final EssentialsDiscordLink ess;
    private final AccountStorage storage;
    private final RoleSyncManager roleSyncManager;
    private final Map<String, UUID> codeToUuidMap = new ConcurrentHashMap<String, UUID>();

    public AccountLinkManager(EssentialsDiscordLink ess, AccountStorage storage, RoleSyncManager roleSyncManager) {
        this.ess = ess;
        this.storage = storage;
        this.roleSyncManager = roleSyncManager;
    }

    public String createCode(UUID uuid) throws IllegalArgumentException {
        Optional<Map.Entry> prevCode = this.codeToUuidMap.entrySet().stream().filter(stringUUIDEntry -> ((UUID)stringUUIDEntry.getValue()).equals(uuid)).findFirst();
        if (prevCode.isPresent()) {
            throw new IllegalArgumentException((String)prevCode.get().getKey());
        }
        String code = this.generateCode();
        this.codeToUuidMap.put(code, uuid);
        return code;
    }

    public UUID getPendingUUID(String code) {
        return this.codeToUuidMap.remove(code);
    }

    @Override
    public String getDiscordId(UUID uuid) {
        return this.storage.getDiscordId(uuid);
    }

    public IUser getUser(String discordId) {
        UUID uuid = this.getUUID(discordId);
        if (uuid == null) {
            return null;
        }
        return this.ess.getEss().getUser(uuid);
    }

    @Override
    public UUID getUUID(String discordId) {
        return this.storage.getUUID(discordId);
    }

    @Override
    public boolean unlinkAccount(InteractionMember member) {
        Preconditions.checkNotNull((Object)member, (Object)"member cannot be null");
        return this.isLinked(member.getId()) && this.removeAccount(member, DiscordLinkStatusChangeEvent.Cause.UNSYNC_API);
    }

    public boolean removeAccount(InteractionMember member, DiscordLinkStatusChangeEvent.Cause cause) {
        UUID uuid = this.getUUID(member.getId());
        if (this.storage.remove(member.getId())) {
            this.ensureAsync(() -> {
                User user = this.ess.getEss().getUser(uuid);
                this.ensureSync(() -> this.lambda$removeAccount$1((IUser)user, member, cause));
                this.roleSyncManager.unSync(uuid, member.getId());
            });
            return true;
        }
        return false;
    }

    @Override
    public boolean unlinkAccount(UUID uuid) {
        Preconditions.checkNotNull((Object)uuid, (Object)"uuid cannot be null");
        if (!this.isLinked(uuid)) {
            return false;
        }
        this.ensureAsync(() -> this.removeAccount((IUser)this.ess.getEss().getUser(uuid), DiscordLinkStatusChangeEvent.Cause.UNSYNC_API));
        return true;
    }

    public boolean removeAccount(IUser user, DiscordLinkStatusChangeEvent.Cause cause) {
        String id = this.getDiscordId(user.getBase().getUniqueId());
        if (this.storage.remove(user.getBase().getUniqueId())) {
            this.ess.getApi().getMemberById(id).thenAccept(member -> this.ensureSync(() -> this.ess.getServer().getPluginManager().callEvent((Event)new DiscordLinkStatusChangeEvent(user, (InteractionMember)member, id, false, cause))));
            this.ensureAsync(() -> this.roleSyncManager.unSync(user.getBase().getUniqueId(), id));
            return true;
        }
        return false;
    }

    @Override
    public boolean linkAccount(UUID uuid, InteractionMember member) {
        Preconditions.checkNotNull((Object)uuid, (Object)"uuid cannot be null");
        Preconditions.checkNotNull((Object)member, (Object)"member cannot be null");
        if (this.isLinked(uuid) || this.isLinked(member.getId())) {
            return false;
        }
        this.registerAccount(uuid, member, DiscordLinkStatusChangeEvent.Cause.SYNC_API);
        return true;
    }

    public void registerAccount(UUID uuid, InteractionMember member, DiscordLinkStatusChangeEvent.Cause cause) {
        this.storage.add(uuid, member.getId());
        this.ensureAsync(() -> this.roleSyncManager.sync(uuid, member.getId()));
        this.ensureAsync(() -> {
            User user = this.ess.getEss().getUser(uuid);
            this.ensureSync(() -> this.lambda$registerAccount$8((IUser)user, member, cause));
        });
    }

    private void ensureSync(Runnable runnable) {
        if (this.ess.getServer().isPrimaryThread()) {
            runnable.run();
            return;
        }
        this.ess.getEss().scheduleSyncDelayedTask(runnable);
    }

    private void ensureAsync(Runnable runnable) {
        if (!this.ess.getServer().isPrimaryThread()) {
            runnable.run();
            return;
        }
        this.ess.getEss().runTaskAsynchronously(runnable);
    }

    private String generateCode() {
        char[] code = new char[8];
        ThreadLocalRandom random = ThreadLocalRandom.current();
        for (int i = 0; i < 8; ++i) {
            code[i] = CODE_CHARACTERS[((Random)random).nextInt(CODE_CHARACTERS.length)];
        }
        String result = new String(code);
        if (this.codeToUuidMap.containsKey(result)) {
            return this.generateCode();
        }
        return result;
    }

    @Override
    public Map<String, String> getAllLinkedPlayers() {
        return Collections.unmodifiableMap(this.storage.getRawStorageMap());
    }

    private /* synthetic */ void lambda$registerAccount$8(IUser user, InteractionMember member, DiscordLinkStatusChangeEvent.Cause cause) {
        this.ess.getServer().getPluginManager().callEvent((Event)new DiscordLinkStatusChangeEvent(user, member, member.getId(), true, cause));
    }

    private /* synthetic */ void lambda$removeAccount$1(IUser user, InteractionMember member, DiscordLinkStatusChangeEvent.Cause cause) {
        this.ess.getServer().getPluginManager().callEvent((Event)new DiscordLinkStatusChangeEvent(user, member, member.getId(), false, cause));
    }
}

