/*
 * Decompiled with CFR 0.152.
 */
package net.essentialsx.discordlink;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import net.essentialsx.discordlink.EssentialsDiscordLink;

public class AccountStorage {
    private final Gson gson = new Gson();
    private final EssentialsDiscordLink plugin;
    private final File accountFile;
    private final BiMap<String, String> uuidToDiscordIdMap;
    private final AtomicBoolean mapDirty = new AtomicBoolean(false);
    private final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();

    public AccountStorage(EssentialsDiscordLink plugin) throws IOException {
        this.plugin = plugin;
        this.accountFile = new File(plugin.getDataFolder(), "accounts.json");
        if (!plugin.getDataFolder().exists() && !plugin.getDataFolder().mkdirs()) {
            throw new IOException("Unable to create account file!");
        }
        if (!this.accountFile.exists() && !this.accountFile.createNewFile()) {
            throw new IOException("Unable to create account file!");
        }
        try (FileReader reader = new FileReader(this.accountFile);){
            Map map = (Map)this.gson.fromJson((Reader)reader, new TypeToken<Map<String, String>>(){}.getType());
            this.uuidToDiscordIdMap = map == null ? Maps.synchronizedBiMap((BiMap)HashBiMap.create()) : Maps.synchronizedBiMap((BiMap)HashBiMap.create((Map)map));
        }
        this.executorService.scheduleWithFixedDelay(() -> {
            if (!this.mapDirty.compareAndSet(true, false)) {
                return;
            }
            if (plugin.getEss().getSettings().isDebug()) {
                plugin.getLogger().log(Level.INFO, "Saving linked discord accounts to disk...");
            }
            HashMap<String, String> clone = new HashMap<String, String>((Map<String, String>)this.uuidToDiscordIdMap);
            try (FileWriter writer = new FileWriter(this.accountFile);){
                this.gson.toJson(clone, (Appendable)writer);
            }
            catch (IOException e) {
                plugin.getLogger().log(Level.SEVERE, "Failed to save link accounts!", e);
                this.mapDirty.set(true);
            }
        }, 10L, 10L, TimeUnit.SECONDS);
    }

    public BiMap<String, String> getRawStorageMap() {
        return HashBiMap.create(this.uuidToDiscordIdMap);
    }

    public void add(UUID uuid, String discordId) {
        this.uuidToDiscordIdMap.forcePut((Object)uuid.toString(), (Object)discordId);
        this.queueSave();
    }

    public boolean remove(UUID uuid) {
        if (this.uuidToDiscordIdMap.remove((Object)uuid.toString()) != null) {
            this.queueSave();
            return true;
        }
        return false;
    }

    public boolean remove(String discordId) {
        if (this.uuidToDiscordIdMap.values().removeIf(discordId::equals)) {
            this.queueSave();
            return true;
        }
        return false;
    }

    public UUID getUUID(String discordId) {
        String uuid = (String)this.uuidToDiscordIdMap.inverse().get((Object)discordId);
        return uuid == null ? null : UUID.fromString(uuid);
    }

    public String getDiscordId(UUID uuid) {
        return (String)this.uuidToDiscordIdMap.get((Object)uuid.toString());
    }

    public void queueSave() {
        this.mapDirty.set(true);
    }

    public void shutdown() {
        block8: {
            try {
                this.executorService.shutdown();
                if (!this.executorService.awaitTermination(10L, TimeUnit.SECONDS)) {
                    this.plugin.getLogger().log(Level.SEVERE, "Timed out while saving!");
                    this.executorService.shutdownNow();
                }
                if (!this.mapDirty.get()) break block8;
                try (FileWriter writer = new FileWriter(this.accountFile);){
                    this.gson.toJson(this.uuidToDiscordIdMap, (Appendable)writer);
                }
            }
            catch (IOException | InterruptedException e) {
                this.plugin.getLogger().log(Level.SEVERE, "Failed to shutdown link accounts save!", e);
                this.executorService.shutdownNow();
            }
        }
    }
}

