/*
 * Decompiled with CFR 0.152.
 */
package net.essentialsx.discordlink;

import com.earth2me.essentials.EssentialsLogger;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.IConf;
import com.earth2me.essentials.IEssentials;
import com.earth2me.essentials.IEssentialsModule;
import com.earth2me.essentials.metrics.MetricsWrapper;
import com.earth2me.essentials.utils.AdventureUtil;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.essentialsx.api.v2.services.discord.DiscordService;
import net.essentialsx.api.v2.services.discord.InteractionCommand;
import net.essentialsx.api.v2.services.discord.InteractionException;
import net.essentialsx.api.v2.services.discordlink.DiscordLinkService;
import net.essentialsx.discord.EssentialsDiscord;
import net.essentialsx.discordlink.AccountLinkManager;
import net.essentialsx.discordlink.AccountStorage;
import net.essentialsx.discordlink.DiscordLinkSettings;
import net.essentialsx.discordlink.commands.discord.AccountInteractionCommand;
import net.essentialsx.discordlink.commands.discord.LinkInteractionCommand;
import net.essentialsx.discordlink.commands.discord.UnlinkInteractionCommand;
import net.essentialsx.discordlink.listeners.LinkBukkitListener;
import net.essentialsx.discordlink.rolesync.RoleSyncManager;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.java.JavaPlugin;

public class EssentialsDiscordLink
extends JavaPlugin {
    private transient IEssentials ess;
    private transient MetricsWrapper metrics = null;
    private DiscordService api;
    private DiscordLinkSettings settings;
    private AccountStorage accounts;
    private AccountLinkManager linkManager;
    private RoleSyncManager roleSyncManager;

    public void onEnable() {
        this.ess = (IEssentials)this.getServer().getPluginManager().getPlugin("Essentials");
        EssentialsDiscord essDiscord = (EssentialsDiscord)this.getServer().getPluginManager().getPlugin("EssentialsDiscord");
        if (this.ess == null || !this.ess.isEnabled() || essDiscord == null || !essDiscord.isEnabled()) {
            this.setEnabled(false);
            return;
        }
        if (!this.getDescription().getVersion().equals(this.ess.getDescription().getVersion())) {
            this.getLogger().log(Level.WARNING, AdventureUtil.miniToLegacy((String)I18n.tlLiteral((String)"versionMismatchAll", (Object[])new Object[0])));
        }
        this.api = (DiscordService)this.getServer().getServicesManager().load(DiscordService.class);
        this.settings = new DiscordLinkSettings(this);
        this.ess.addReloadListener((IConf)this.settings);
        try {
            this.accounts = new AccountStorage(this);
        }
        catch (IOException e) {
            this.getLogger().log(Level.SEVERE, "Unable to create link accounts file", e);
            this.setEnabled(false);
            return;
        }
        this.roleSyncManager = new RoleSyncManager(this);
        this.linkManager = new AccountLinkManager(this, this.accounts, this.roleSyncManager);
        this.getServer().getPluginManager().registerEvents((Listener)new LinkBukkitListener(this), (Plugin)this);
        this.getServer().getServicesManager().register(DiscordLinkService.class, (Object)this.linkManager, (Plugin)this, ServicePriority.Normal);
        if (!(this.api.getInteractionController().getCommand("link") instanceof LinkInteractionCommand)) {
            try {
                this.api.getInteractionController().registerCommand((InteractionCommand)new AccountInteractionCommand(this.linkManager));
                this.api.getInteractionController().registerCommand((InteractionCommand)new LinkInteractionCommand(this.linkManager));
                this.api.getInteractionController().registerCommand((InteractionCommand)new UnlinkInteractionCommand(this.linkManager));
            }
            catch (InteractionException e) {
                e.printStackTrace();
                this.setEnabled(false);
                return;
            }
        }
        this.ess.getPermissionsHandler().registerContext("essentials:linked", user -> Collections.singleton(String.valueOf(this.linkManager.isLinked(user.getUUID()))), () -> ImmutableSet.of((Object)"true", (Object)"false"));
        if (this.metrics == null) {
            this.metrics = new MetricsWrapper((JavaPlugin)this, 11462, false);
        }
    }

    public void onDisable() {
        if (this.accounts != null) {
            this.accounts.shutdown();
        }
    }

    public void onReload() {
        if (this.roleSyncManager != null) {
            this.roleSyncManager.onReload();
        }
    }

    public IEssentials getEss() {
        return this.ess;
    }

    public DiscordService getApi() {
        return this.api;
    }

    public DiscordLinkSettings getSettings() {
        return this.settings;
    }

    public AccountStorage getAccountStorage() {
        return this.accounts;
    }

    public AccountLinkManager getLinkManager() {
        return this.linkManager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        return this.ess.onCommandEssentials(sender, command, label, args, EssentialsDiscordLink.class.getClassLoader(), "net.essentialsx.discordlink.commands.bukkit.Command", "essentials.", (IEssentialsModule)this.linkManager);
    }

    public Logger getLogger() {
        try {
            return EssentialsLogger.getLoggerProvider((Plugin)this);
        }
        catch (Throwable ignored) {
            return super.getLogger();
        }
    }
}

