/*
 * Decompiled with CFR 0.152.
 */
package net.essentialsx.discordlink.commands.discord;

import com.earth2me.essentials.I18n;
import com.google.common.collect.ImmutableList;
import java.util.List;
import net.ess3.api.IUser;
import net.essentialsx.api.v2.services.discord.InteractionCommand;
import net.essentialsx.api.v2.services.discord.InteractionCommandArgument;
import net.essentialsx.api.v2.services.discord.InteractionCommandArgumentType;
import net.essentialsx.api.v2.services.discord.InteractionEvent;
import net.essentialsx.api.v2.services.discord.InteractionMember;
import net.essentialsx.discordlink.AccountLinkManager;

public class AccountInteractionCommand
implements InteractionCommand {
    private final List<InteractionCommandArgument> arguments = ImmutableList.of((Object)new InteractionCommandArgument("user", I18n.tlLiteral((String)"discordCommandAccountArgumentUser", (Object[])new Object[0]), InteractionCommandArgumentType.USER, false));
    private final AccountLinkManager accounts;

    public AccountInteractionCommand(AccountLinkManager accounts) {
        this.accounts = accounts;
    }

    public boolean isDisabled() {
        return false;
    }

    public boolean isEphemeral() {
        return true;
    }

    public String getName() {
        return "account";
    }

    public String getDescription() {
        return I18n.tlLiteral((String)"discordCommandAccountDescription", (Object[])new Object[0]);
    }

    public List<InteractionCommandArgument> getArguments() {
        return this.arguments;
    }

    public void onCommand(InteractionEvent event) {
        InteractionMember userArg = event.getUserArgument("user");
        InteractionMember effectiveUser = userArg == null ? event.getMember() : userArg;
        IUser user = this.accounts.getUser(effectiveUser.getId());
        if (user == null) {
            event.replyTl(event.getMember().getId().equals(effectiveUser.getId()) ? "discordCommandAccountResponseNotLinked" : "discordCommandAccountResponseNotLinkedOther", new Object[]{effectiveUser.getAsMention()});
            return;
        }
        if (event.getMember().getId().equals(effectiveUser.getId())) {
            event.replyTl("discordCommandAccountResponseLinked", new Object[]{user.getName()});
            return;
        }
        event.replyTl("discordCommandAccountResponseLinkedOther", new Object[]{effectiveUser.getAsMention(), user.getName()});
    }
}

