/*
 * Decompiled with CFR 0.152.
 */
package net.essentialsx.discordlink.commands.discord;

import com.earth2me.essentials.I18n;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.UUID;
import net.essentialsx.api.v2.events.discordlink.DiscordLinkStatusChangeEvent;
import net.essentialsx.api.v2.services.discord.InteractionCommand;
import net.essentialsx.api.v2.services.discord.InteractionCommandArgument;
import net.essentialsx.api.v2.services.discord.InteractionCommandArgumentType;
import net.essentialsx.api.v2.services.discord.InteractionEvent;
import net.essentialsx.discordlink.AccountLinkManager;

public class LinkInteractionCommand
implements InteractionCommand {
    private final List<InteractionCommandArgument> arguments = ImmutableList.of((Object)new InteractionCommandArgument("code", I18n.tlLiteral((String)"discordCommandLinkArgumentCode", (Object[])new Object[0]), InteractionCommandArgumentType.STRING, true));
    private final AccountLinkManager accounts;

    public LinkInteractionCommand(AccountLinkManager accounts) {
        this.accounts = accounts;
    }

    public void onCommand(InteractionEvent event) {
        if (this.accounts.isLinked(event.getMember().getId())) {
            event.replyTl("discordCommandLinkHasAccount", new Object[0]);
            return;
        }
        UUID uuid = this.accounts.getPendingUUID(event.getStringArgument("code"));
        if (uuid == null) {
            event.replyTl("discordCommandLinkInvalidCode", new Object[0]);
            return;
        }
        this.accounts.registerAccount(uuid, event.getMember(), DiscordLinkStatusChangeEvent.Cause.SYNC_PLAYER);
        event.replyTl("discordCommandLinkLinked", new Object[0]);
    }

    public boolean isDisabled() {
        return false;
    }

    public boolean isEphemeral() {
        return true;
    }

    public String getName() {
        return "link";
    }

    public String getDescription() {
        return I18n.tlLiteral((String)"discordCommandLinkDescription", (Object[])new Object[0]);
    }

    public List<InteractionCommandArgument> getArguments() {
        return this.arguments;
    }
}

