/*
 * Decompiled with CFR 0.152.
 */
package net.essentialsx.discordlink.commands.discord;

import com.earth2me.essentials.I18n;
import java.util.List;
import net.essentialsx.api.v2.events.discordlink.DiscordLinkStatusChangeEvent;
import net.essentialsx.api.v2.services.discord.InteractionCommand;
import net.essentialsx.api.v2.services.discord.InteractionCommandArgument;
import net.essentialsx.api.v2.services.discord.InteractionEvent;
import net.essentialsx.discordlink.AccountLinkManager;

public class UnlinkInteractionCommand
implements InteractionCommand {
    private final AccountLinkManager accounts;

    public UnlinkInteractionCommand(AccountLinkManager accounts) {
        this.accounts = accounts;
    }

    public void onCommand(InteractionEvent event) {
        if (!this.accounts.removeAccount(event.getMember(), DiscordLinkStatusChangeEvent.Cause.UNSYNC_PLAYER)) {
            event.replyTl("discordCommandUnlinkInvalidCode", new Object[0]);
            return;
        }
        event.replyTl("discordCommandUnlinkUnlinked", new Object[0]);
    }

    public boolean isDisabled() {
        return false;
    }

    public boolean isEphemeral() {
        return true;
    }

    public String getName() {
        return "unlink";
    }

    public String getDescription() {
        return I18n.tlLiteral((String)"discordCommandUnlinkDescription", (Object[])new Object[0]);
    }

    public List<InteractionCommandArgument> getArguments() {
        return null;
    }
}

