/*
 * Decompiled with CFR 0.152.
 */
package net.essentialsx.discordlink.rolesync;

import com.earth2me.essentials.I18n;
import com.earth2me.essentials.UUIDPlayer;
import com.earth2me.essentials.utils.AdventureUtil;
import com.google.common.collect.BiMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.ess3.api.IUser;
import net.essentialsx.api.v2.events.discordlink.DiscordLinkStatusChangeEvent;
import net.essentialsx.api.v2.services.discord.InteractionMember;
import net.essentialsx.api.v2.services.discord.InteractionRole;
import net.essentialsx.discordlink.EssentialsDiscordLink;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;

public class RoleSyncManager
implements Listener {
    private final EssentialsDiscordLink ess;
    private final Map<String, InteractionRole> groupToRoleMap = new HashMap<String, InteractionRole>();
    private final Map<String, String> roleIdToGroupMap = new HashMap<String, String>();

    public RoleSyncManager(EssentialsDiscordLink ess) {
        this.ess = ess;
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)ess);
        this.onReload();
        this.ess.getEss().runTaskTimerAsynchronously(() -> {
            if (this.groupToRoleMap.isEmpty() && this.roleIdToGroupMap.isEmpty()) {
                return;
            }
            BiMap<String, String> uuidToDiscordCopy = ess.getAccountStorage().getRawStorageMap();
            HashMap<String, InteractionRole> groupToRoleMapCopy = new HashMap<String, InteractionRole>(this.groupToRoleMap);
            HashMap<String, String> roleIdToGroupMapCopy = new HashMap<String, String>(this.roleIdToGroupMap);
            boolean primaryOnly = ess.getSettings().isRoleSyncPrimaryGroupOnly();
            boolean removeGroups = ess.getSettings().isRoleSyncRemoveGroups();
            boolean removeRoles = ess.getSettings().isRoleSyncRemoveRoles();
            for (Map.Entry entry : uuidToDiscordCopy.entrySet()) {
                this.sync((Player)new UUIDPlayer(UUID.fromString((String)entry.getKey())), (String)entry.getValue(), groupToRoleMapCopy, roleIdToGroupMapCopy, primaryOnly, removeGroups, removeRoles);
            }
        }, 0L, (long)ess.getSettings().getRoleSyncResyncDelay() * 1200L);
    }

    public void sync(UUID uuid, String discordId) {
        HashMap<String, InteractionRole> groupToRoleMapCopy = new HashMap<String, InteractionRole>(this.groupToRoleMap);
        HashMap<String, String> roleIdToGroupMapCopy = new HashMap<String, String>(this.roleIdToGroupMap);
        boolean primaryOnly = this.ess.getSettings().isRoleSyncPrimaryGroupOnly();
        boolean removeGroups = this.ess.getSettings().isRoleSyncRemoveGroups();
        boolean removeRoles = this.ess.getSettings().isRoleSyncRemoveRoles();
        this.sync((Player)new UUIDPlayer(uuid), discordId, groupToRoleMapCopy, roleIdToGroupMapCopy, primaryOnly, removeGroups, removeRoles);
    }

    public void sync(Player player, String discordId, Map<String, InteractionRole> groupToRoleMap, Map<String, String> roleIdToGroupMap, boolean primaryOnly, boolean removeGroups, boolean removeRoles) {
        List<String> groups = primaryOnly ? Collections.singletonList(this.ess.getEss().getPermissionsHandler().getGroup((OfflinePlayer)player)) : this.ess.getEss().getPermissionsHandler().getGroups((OfflinePlayer)player);
        InteractionMember member = (InteractionMember)this.ess.getApi().getMemberById(discordId).join();
        if (member == null) {
            if (this.ess.getSettings().isUnlinkOnLeave()) {
                this.ess.getLinkManager().removeAccount((IUser)this.ess.getEss().getUser(player), DiscordLinkStatusChangeEvent.Cause.UNSYNC_LEAVE);
            } else {
                this.unSync(player.getUniqueId(), discordId);
            }
            return;
        }
        ArrayList<InteractionRole> toAdd = new ArrayList<InteractionRole>();
        ArrayList<InteractionRole> toRemove = new ArrayList<InteractionRole>();
        for (Map.Entry<String, InteractionRole> entry : groupToRoleMap.entrySet()) {
            if (groups.contains(entry.getKey()) && !member.hasRole(entry.getValue())) {
                toAdd.add(entry.getValue());
                continue;
            }
            if (!removeRoles || groups.contains(entry.getKey()) || !member.hasRole(entry.getValue())) continue;
            toRemove.add(entry.getValue());
        }
        for (Map.Entry<String, Object> entry : roleIdToGroupMap.entrySet()) {
            if (member.hasRole(entry.getKey()) && !groups.contains(entry.getValue())) {
                this.ess.getEss().getPermissionsHandler().addToGroup((OfflinePlayer)player, (String)entry.getValue());
                continue;
            }
            if (!removeGroups || member.hasRole(entry.getKey()) || !groups.contains(entry.getValue())) continue;
            this.ess.getEss().getPermissionsHandler().removeFromGroup((OfflinePlayer)player, (String)entry.getValue());
        }
        if (toAdd.isEmpty() && toRemove.isEmpty()) {
            return;
        }
        this.ess.getApi().modifyMemberRoles(member, toAdd, toRemove);
    }

    public void unSync(UUID uuid, String discordId) {
        boolean removeGroups = this.ess.getSettings().isRoleSyncRemoveGroups();
        boolean removeRoles = this.ess.getSettings().isRoleSyncRemoveRoles();
        if (!removeGroups && !removeRoles) {
            return;
        }
        HashMap<String, InteractionRole> groupToRoleMapCopy = new HashMap<String, InteractionRole>(this.groupToRoleMap);
        HashMap<String, String> roleIdToGroupMapCopy = new HashMap<String, String>(this.roleIdToGroupMap);
        UUIDPlayer player = new UUIDPlayer(uuid);
        InteractionMember member = (InteractionMember)this.ess.getApi().getMemberById(discordId).join();
        if (removeGroups) {
            for (String group : roleIdToGroupMapCopy.values()) {
                this.ess.getEss().getPermissionsHandler().removeFromGroup((OfflinePlayer)player, group);
            }
        }
        if (removeRoles && member != null) {
            this.ess.getApi().modifyMemberRoles(member, null, groupToRoleMapCopy.values());
        }
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        this.ess.getEss().runTaskAsynchronously(() -> {
            if (this.ess.getLinkManager().isLinked(event.getPlayer().getUniqueId())) {
                this.sync(event.getPlayer().getUniqueId(), this.ess.getLinkManager().getDiscordId(event.getPlayer().getUniqueId()));
            }
        });
    }

    public void onReload() {
        this.groupToRoleMap.clear();
        this.roleIdToGroupMap.clear();
        List groups = this.ess.getEss().getPermissionsHandler().getGroups();
        for (Map.Entry<String, String> entry : this.ess.getSettings().getRoleSyncGroups().entrySet()) {
            if (this.isExampleRole(entry.getValue())) continue;
            String group = entry.getKey();
            InteractionRole role = this.ess.getApi().getRole(entry.getValue());
            if (!groups.contains(group)) {
                this.ess.getLogger().warning(AdventureUtil.miniToLegacy((String)I18n.tlLiteral((String)"discordLinkInvalidGroup", (Object[])new Object[]{group, entry.getValue(), groups})));
                continue;
            }
            if (role == null) {
                this.ess.getLogger().warning(AdventureUtil.miniToLegacy((String)I18n.tlLiteral((String)"discordLinkInvalidRole", (Object[])new Object[]{entry.getValue(), group})));
                continue;
            }
            if (role.isManaged() || role.isPublicRole()) {
                this.ess.getLogger().warning(AdventureUtil.miniToLegacy((String)I18n.tlLiteral((String)"discordLinkInvalidRoleManaged", (Object[])new Object[]{role.getName(), role.getId()})));
                continue;
            }
            if (!role.canInteract()) {
                this.ess.getLogger().warning(AdventureUtil.miniToLegacy((String)I18n.tlLiteral((String)"discordLinkInvalidRoleInteract", (Object[])new Object[]{role.getName(), role.getId()})));
                continue;
            }
            this.groupToRoleMap.put(group, role);
        }
        for (Map.Entry<String, String> entry : this.ess.getSettings().getRoleSyncRoles().entrySet()) {
            if (this.isExampleRole(entry.getKey())) continue;
            InteractionRole role = this.ess.getApi().getRole(entry.getKey());
            String group = entry.getValue();
            if (role == null) {
                this.ess.getLogger().warning(AdventureUtil.miniToLegacy((String)I18n.tlLiteral((String)"discordLinkInvalidRole", (Object[])new Object[]{entry.getKey(), group})));
                continue;
            }
            if (!groups.contains(group)) {
                this.ess.getLogger().warning(AdventureUtil.miniToLegacy((String)I18n.tlLiteral((String)"discordLinkInvalidGroup", (Object[])new Object[]{group, entry.getKey(), groups})));
                continue;
            }
            this.roleIdToGroupMap.put(role.getId(), group);
        }
    }

    private boolean isExampleRole(String role) {
        return role.equals("0") || role.equals("11111111111111111") || role.equals("22222222222222222") || role.equals("33333333333333333");
    }
}

