/*
 * Decompiled with CFR 0.152.
 */
package us.mikebartosh.minecraft;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2596;
import net.minecraft.class_2772;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_7157;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TabTPS
implements ModInitializer {
    public static final String MOD_ID = "tab-tps";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"tab-tps");
    private int tickCounter = 0;
    private final Map<UUID, Boolean> enabled = new HashMap<UUID, Boolean>();
    private final Map<UUID, Boolean> useAverage = new HashMap<UUID, Boolean>();

    public void onInitialize() {
        LOGGER.info("[TabTPS] Initialized");
        ServerTickEvents.END_SERVER_TICK.register(this::onServerTick);
        CommandRegistrationCallback.EVENT.register(this::registerCommands);
    }

    private void registerCommands(CommandDispatcher<class_2168> dispatcher, class_7157 registry, class_2170.class_5364 env) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"tabtps").requires(src -> src.method_9259(2))).then(class_2170.method_9247((String)"toggle").executes(this::toggle))).then(class_2170.method_9247((String)"mode").executes(this::mode)));
    }

    private int toggle(CommandContext<class_2168> ctx) {
        class_3222 player = ((class_2168)ctx.getSource()).method_44023();
        if (player == null) {
            return 0;
        }
        boolean current = this.enabled.getOrDefault(player.method_5667(), true);
        boolean newState = !current;
        this.enabled.put(player.method_5667(), newState);
        if (!newState) {
            player.field_13987.method_14364((class_2596)new class_2772((class_2561)class_2561.method_43473(), (class_2561)class_2561.method_43473()));
        }
        player.method_7353((class_2561)class_2561.method_43470((String)("TabTPS is now " + (newState ? "\u00a7aENABLED" : "\u00a7cDISABLED"))), false);
        return 1;
    }

    private int mode(CommandContext<class_2168> ctx) {
        class_3222 player = ((class_2168)ctx.getSource()).method_44023();
        if (player == null) {
            return 0;
        }
        boolean current = this.useAverage.getOrDefault(player.method_5667(), false);
        this.useAverage.put(player.method_5667(), !current);
        player.method_7353((class_2561)class_2561.method_43470((String)("TabTPS mode set to " + (!current ? "\u00a7aAVERAGE" : "\u00a7bINSTANT"))), false);
        return 1;
    }

    private void onServerTick(MinecraftServer server) {
        ++this.tickCounter;
        if (this.tickCounter % 20 != 0) {
            return;
        }
        for (class_3222 player : server.method_3760().method_14571()) {
            if (!player.method_5687(2) || !this.enabled.getOrDefault(player.method_5667(), true).booleanValue()) continue;
            boolean avg = this.useAverage.getOrDefault(player.method_5667(), false);
            double mspt = avg ? this.getAverageMSPT(server) : this.getCurrentMSPT(server);
            double tps = Math.min(1000.0 / mspt, 20.0);
            int rgb = this.getGradientRgb(mspt);
            class_5250 footer = class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"TPS: ").method_10862(class_2583.field_24360.method_10977(class_124.field_1080))).method_10852((class_2561)class_2561.method_43470((String)String.format("%.2f", tps)).method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)rgb)))).method_10852((class_2561)class_2561.method_43470((String)" | ").method_10862(class_2583.field_24360.method_10977(class_124.field_1063))).method_10852((class_2561)class_2561.method_43470((String)"MSPT: ").method_10862(class_2583.field_24360.method_10977(class_124.field_1080))).method_10852((class_2561)class_2561.method_43470((String)String.format("%.2f", mspt)).method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)rgb))));
            player.field_13987.method_14364((class_2596)new class_2772((class_2561)class_2561.method_43473(), (class_2561)footer));
        }
    }

    private double getCurrentMSPT(MinecraftServer server) {
        long lastTickNanos = server.field_4573[server.field_4573.length - 1];
        return (double)lastTickNanos / 1000000.0;
    }

    private double getAverageMSPT(MinecraftServer server) {
        long total = 0L;
        for (long l : server.field_4573) {
            total += l;
        }
        return (double)total / (double)server.field_4573.length / 1000000.0;
    }

    private int getGradientRgb(double mspt) {
        int g;
        int r;
        double t = Math.min(1.0, Math.max(0.0, (mspt - 20.0) / 30.0));
        if (t < 0.5) {
            r = (int)(t * 2.0 * 255.0);
            g = 255;
        } else {
            r = 255;
            g = (int)((1.0 - (t - 0.5) * 2.0) * 255.0);
        }
        int b = 0;
        return r << 16 | g << 8 | b;
    }
}

