include("display.js");

var shouldRenderWindows = true;

var rawModels = ModelManager.loadPartedRawModel(Resources.manager(), Resources.idRelative("mtr:st_i_18/su_i_18_a.obj"), null);
var head = uploadPartedModels(rawModels, true, true);

var rawModels2 = ModelManager.loadPartedRawModel(Resources.manager(), Resources.idRelative("mtr:st_i_18/uzel.obj"), null);
var uzel = uploadPartedModels(rawModels2, true, true);

var rawModels3 = ModelManager.loadPartedRawModel(Resources.manager(), Resources.idRelative("mtr:st_i_18/su_i_18_b.obj"), null);
var trail = uploadPartedModels(rawModels3, true, true);

function create(ctx, state, train) {
	if (train.trainCars < 4) {
		print("Вагон не рендерится из-за недостатка длины")
		return;
	}

	state.wheelAngle = 0;
	state.steeringAngle = 0.0;
	state.oldFirstCarTurnForSteering = train.lastCarRotation[1] == undefined ? 0.0 :  train.lastCarRotation[1].y() ;
	state.jointOffset = 0;

	displCreate(ctx, state, train)
}

function dispose(ctx, state, train) {
	if (train.trainCars < 4) return
	displDispose(ctx, state, train)
}

function render(ctx, state, train) {
	if (train.trainCars < 4) return
	updateLogic(state, train);
	renderLogic(ctx, state, train);



	displRender(ctx, state, train)
}

function updateLogic(state, train) {
	updateWheelAngle(train, state);
	updateSteeringAngle(train, state, 3.949, 1);

	updateJointScript(state, train) // КОСТЫЛИЩЕЕЕЕ
}

function renderLogic(ctx, state, train) {
	if (train.trainCars < 4) {
		return;
	}

	renderHead(ctx, state, train)
	renderUzel(ctx, state, train)
	renderTail(ctx, state, train)
}

function renderHead(ctx, state, train) {
	let matrices = new Matrices();
	let i = 1;
	let firstAngle = train.doorRightOpen[i] ? 75.0 * Math.PI / 180 * smoothCubic(train.doorValue()) : 0;
	let secondAngle = train.doorRightOpen[i] ? -164.0 * Math.PI / 180 * smoothCubic(train.doorValue()) : 0;
	ctx.drawCarModel(head["body"], i, matrices);
	ctx.drawCarModel(head["salon"], i, matrices);
	ctx.drawCarModel(head["salon_lights"], i, matrices);
	ctx.drawCarModel(head["salon_glass"], i, matrices);
	ctx.drawCarModel(head["lights"], i, matrices);
	ctx.drawCarModel(head["uzel_sn"], i, matrices);
	ctx.drawCarModel(head["tablo_sn"], i, matrices);
	ctx.drawCarModel(head["tablo"], i, matrices);

	{
		// WHEELS
		// front right
		const radius = 1.8;
		let steeringAngle = state.steeringAngle;
		matrices.pushPose();
		matrices.translate(-1.077, -0.5266, 3.036);
		matrices.rotateY(steeringAngle);
		matrices.rotateX(state.wheelAngle * radius);
		matrices.translate(1.077, 0.5266, -3.036);

		ctx.drawCarModel(head["wheel_fr"], i, matrices);

		matrices.popPose();

		matrices.pushPose();
		matrices.translate(1.077, -0.5266, 3.036);
		matrices.rotateY(steeringAngle);
		matrices.rotateX(state.wheelAngle * radius);
		matrices.translate(-1.077, 0.5266, -3.036);

		ctx.drawCarModel(head["wheel_fl"], i, matrices);

		matrices.popPose();

		// BACK WHEELS
		matrices.pushPose();
		matrices.translate(0, -0.5266, -2.082);
		matrices.rotateX(state.wheelAngle * radius);
		matrices.translate(0, 0.5266, 2.082);

		ctx.drawCarModel(head["wheels_b"], i, matrices);

		matrices.popPose();
	}


	{
		// DOORS	
		renderDoorWithChild(matrices, ctx,  head["doorRf_r"],  head["doorRf"], null, head["doorRf_glass"], -firstAngle, -secondAngle, -1.140, 5.315, -1.180, 5.018, i);
		renderDoorWithChild(matrices, ctx,  head["doorLf_r"],  head["doorLf"], null, head["doorLf_glass"], firstAngle, secondAngle, -1.140, 3.894, -1.180, 4.191, i);

		renderDoorWithChild(matrices, ctx,  head["doorRm_r"],  head["doorRm"], null, head["doorRm_glass"], -firstAngle, -secondAngle, -1.140, 0.9297, -1.180, 0.6329, i);
		renderDoorWithChild(matrices, ctx,  head["doorLm_r"],  head["doorLm"], null, head["doorLm_glass"], firstAngle, secondAngle, -1.140, -0.4900, -1.180, -0.1948, i);
	}
}

function renderUzel(ctx, state, train) {
	let matrices = new Matrices()
	let i = 2;

	matrices.pushPose();
	matrices.translate(-state.jointOffset, 0, 0)
	ctx.drawCarModel(uzel["uzel_sn"], i, matrices);
	ctx.drawCarModel(uzel["uzel"], i, matrices);
	matrices.popPose();
}

function renderTail(ctx, state, train) {
	let matrices = new Matrices()
	let i = 3;
	let coef = train.lastCarRotation[3].y() % (3.1415 / 2)
	if (coef > 3.1415 / 4) coef = 3.1415 / 2 - coef;
	coef = coef / (3.1415 / 4);
	let firstAngle = train.doorRightOpen[i] ? 75.0 * Math.PI / 180 * smoothCubic(train.doorValue()) : 0;
	let secondAngle = train.doorRightOpen[i] ? -164.0 * Math.PI / 180 * smoothCubic(train.doorValue()) : 0;
	ctx.drawCarModel(trail["body"], i, matrices);
	ctx.drawCarModel(trail["salon"], i, matrices);
	ctx.drawCarModel(trail["salon_lights"], i, matrices);
	ctx.drawCarModel(trail["salon_glass"], i, matrices);
	ctx.drawCarModel(trail["lights"], i, matrices);
	ctx.drawCarModel(trail["uzel_sn"], i, matrices);
	ctx.drawCarModel(trail["shtangi"], i, matrices);
	ctx.drawCarModel(trail["tablo_sz"], i, matrices);
	ctx.drawCarModel(head["tablo"], i, matrices);
	{
		// WHEEL
		const radius = 1.8;

		matrices.pushPose();
		matrices.translate(0, -0.5266, -0.9970);
		matrices.rotateX(state.wheelAngle * radius);
		matrices.translate(0, 0.5266, 0.9970);

		ctx.drawCarModel(trail["wheels_b"], i, matrices);

		matrices.popPose();
	}

	{
		// DOORS
		renderDoorWithChild(matrices, ctx,  trail["doorR_r"],  trail["doorR"], null, trail["doorR_glass"], -firstAngle, -secondAngle, -1.140, 1.427, -1.180, 1.130, i);
		renderDoorWithChild(matrices, ctx,  trail["doorL_r"],  trail["doorL"], null, trail["doorL_glass"], firstAngle, secondAngle, -1.140, 0.005820, -1.180, 0.3022, i);

		renderDoorWithChild(matrices, ctx,  trail["doorRb_r"],  trail["doorRb"], null, trail["doorRb_glass"], -firstAngle, -secondAngle, -1.140, -2.019, -1.180, -2.315, i);
		renderDoorWithChild(matrices, ctx,  trail["doorLb_r"],  trail["doorLb"], null, trail["doorLb_glass"], firstAngle, secondAngle, -1.140, -3.440, -1.180, -3.143, i);
	}
}

/////////////////////////////////////

function renderDoorWithChild(matrices, ctx, parentDoor, childDoor, parentInt, childInt, firstAngle, secondAngle, x1, z1, x2, z2, i) {
	matrices.pushPose(); // пушим родительскую матрицу в стек
	matrices.translate(x1, 0.0, z1);
	matrices.rotate(0.0, 1.0, 0.0, firstAngle); // поворот двери. Смотри самый нижний комментарий для пояснения 
	matrices.translate(-x1, 0.0, -z1);
	{
		matrices.pushPose();    // пуш матрицы дочерней
		matrices.translate(x2, 0.0, z2);
		matrices.rotate(0.0, 1.0, 0.0, secondAngle); // поворот
		matrices.translate(-x2, 0.0, -z2);
		if (childDoor != null) ctx.drawCarModel(childDoor, i, matrices); // рендер внутренней ширмы либо двери
		if (childInt != null) ctx.drawCarModel(childInt, i, matrices);;
		matrices.popPose(); // дочерняя матрица лопается
	}
	if (parentDoor != null) ctx.drawCarModel(parentDoor, i, matrices); // рендер крайней ширмы либо механизма двери
	if (parentInt != null) ctx.drawCarModel(parentInt, i, matrices);
	matrices.popPose(); // родительская матрица лопается

}

//////////////////////////////

// ПОВОРОТ ВЕДУЩИХ КОЛЕС
function updateSteeringAngle(train, state, l, i) {
	if (Timing.delta() == 0.0) return;

	let delta = getCorrectDelta(train.lastCarRotation[i].y(), state.oldFirstCarTurnForSteering)
	if (delta == 0.0) {
		state.steeringAngle = 0.0;
		state.oldFirstCarTurnForSteering = train.lastCarRotation[i].y();
		return;
	}
	const coef = 0.0625;

	let radius = train.speed() * Timing.delta() / delta;
	let sin = clamp(coef * l / radius, -1.0, 1.0);

	if (train.isReversed()) sin *= -1;

	state.steeringAngle = Math.asin(sin);
	state.oldFirstCarTurnForSteering = train.lastCarRotation[i].y();
}

function updateJointScript(state, train) {
	// тут пока пусто, но возможно тут будет костыльный скрипт


	let delta = getCorrectDelta(train.lastCarRotation[1] == undefined ? 0.0 :  train.lastCarRotation[1].y(), train.lastCarRotation[3] == undefined ? 0.0 :  train.lastCarRotation[3].y())

	delta = delta / 2;
	state.jointOffset = Math.sin(delta) * 2;
}


// ВРАЩЕНИE КОЛЕС
function updateWheelAngle(train, state) {
	const angleLoop = 10000;

	// if (!train.shouldRenderDetail()) return 0;
	let speedMps = 20 * train.speed();
	let delta = Timing.delta();
	if (train.isReversed()) {
		state.wheelAngle -= speedMps * delta;
	} else {
		state.wheelAngle += speedMps * delta;
	}

	if (state.wheelAngle > angleLoop) state["wheelAngle"] = 0;
	if (state.wheelAngle < 0) state["wheelAngle"] = angleLoop;
}

function uploadPartedModels(rawModels, removeRenderType, invertUV) {
	result = {};
	for (it = rawModels.entrySet().iterator(); it.hasNext();) {
		entry = it.next();

		let jsStringKey = "" + entry.getKey();
		if (jsStringKey == "salon") entry.getValue().setAllRenderType("interior"); //включение интерьера
		if (jsStringKey == "tablo") entry.getValue().setAllRenderType("light");
		if (jsStringKey == "lights") entry.getValue().setAllRenderType("light");
		if (jsStringKey == "salon_lights") entry.getValue().setAllRenderType("light");
		if (jsStringKey == "doorRf_glass") entry.getValue().setAllRenderType("exteriortranslucent");
		if (jsStringKey == "doorRm_glass") entry.getValue().setAllRenderType("exteriortranslucent");
		if (jsStringKey == "doorR_glass") entry.getValue().setAllRenderType("exteriortranslucent");
		if (jsStringKey == "doorRb_glass") entry.getValue().setAllRenderType("exteriortranslucent");
		if (jsStringKey == "doorLf_glass") entry.getValue().setAllRenderType("exteriortranslucent");
		if (jsStringKey == "doorLm_glass") entry.getValue().setAllRenderType("exteriortranslucent");
		if (jsStringKey == "doorL_glass") entry.getValue().setAllRenderType("exteriortranslucent");
		if (jsStringKey == "doorLb_glass") entry.getValue().setAllRenderType("exteriortranslucent");
		if (jsStringKey == "salon_glass") entry.getValue().setAllRenderType("interiortranslucent");
		if (jsStringKey == "glass") entry.getValue().setAllRenderType("exteriortranslucent");

		entry.getValue().applyUVMirror(false, invertUV);
		result[jsStringKey] = ModelManager.uploadVertArrays(entry.getValue());
	}
	return result;
}

function getCorrectDelta(angle1, angle2) {
	let delta = angle1 - angle2;
	if (Math.abs(delta) > Math.PI) {
		if (delta < 0) {
			return Math.PI * 2 + delta
		} else {
			return -Math.PI * 2 + delta
		}
	}
	return delta;
}

function clamp(num, min, max) {
	if (num > max) return max;
	if (num < min) return min;
	return num;
}

function smoothCubic(x) { //кубическая функция - в отрезке 0-1 возвращает сглаженную функцию 0-1
	return x * x * (-2 * x + 3);
}
