importPackage(java.awt);
importPackage(java.awt.geom);
importPackage(java.nio);
include(Resources.idRelative("mtr:lib/harrys_lib.js"));
include("display.js");

// выгружаем модель, возвращает java class - Карта (для сишарпнутых - словарь), где к одной строке причисляется одна модель
var rawModels = ModelManager.loadPartedRawModel(Resources.manager(), Resources.idRelative("mtr:su_ii_12_3d/su_ii_12_3d.obj"), null);
// тут же нужно обратиться к нужным элементам карты, чтобы задать им нужный тип рендера, но пока я не отделил интерьер

// конвертим из JAVA класса в ECMA Script объект (ECMA - диалект JS, часто юзается в движках)
var models = uploadVehicleModels(rawModels);
repaint(models)
//спизжено из ютонга Buses4MC - nbt1248
function create(ctx, state, train) {
	initTurnState(train, state);
	initWheelAngle(state);
	initSpeedStates(state);
	displCreate(ctx, state, train);
}

function dispose(ctx, state, train) {
	displDispose(ctx, state, train)
}

// void render() вызывается каждый кадр. Очевидно, зависим от ФПС
function render(ctx, state, train) {

	var matrices = new Matrices(); // стек матриц - супер важная вещь

	for (i = 0; i < train.trainCars(); i++) {

		/*
			smoothCubic - при x = [0, 1] - он выводит то же значение от 0 до 1, но сглаженное функцией кубического многочлена. 
			Забейте в гугле "y = -2x^3 + 3x^2", построите на х от 0 до 1, все станет ясно.

			train.doorValue - величина от 0 до 1. Коэффициент завершенности анимации, если можно так сказать. 
			Когда doorValue = 0, умножая на 90 градусов выходит 0 градусов поворота, когда 0.5 - 45, когда 1 - 90.
			С плавным изменением выходит и плавный поворот или движение. 

			Домножение на Пи и деление на 180 - это перевод из градусов в радианы
		*/
		let firstAngle = train.doorRightOpen[i] ? 75.0 * Math.PI / 180 * smoothCubic(train.doorValue()) : 0;
		let secondAngle = train.doorRightOpen[i] ? -164.0 * Math.PI / 180 * smoothCubic(train.doorValue()) : 0;
		// let thirdAngle = train.doorRightOpen[i] ? -95.0 * Math.PI / 180 * smoothCubic(train.doorValue()) : 0;
		// let fourthAngle = train.doorRightOpen[i] ? 95.0 * Math.PI / 180 * smoothCubic(train.doorValue()) : 0;

		//matrices.pushPose();
		ctx.drawCarModel(models["body"], i, matrices); // отрисовка
		ctx.drawCarModel(models["salon"], i, matrices);
		ctx.drawCarModel(models["tablo_sn"], i, matrices);
		ctx.drawCarModel(models["tablo_sz_1"], i, matrices);
		ctx.drawCarModel(models["tablo"], i, matrices);
		ctx.drawCarModel(models["salon_lights"], i, matrices);
		ctx.drawCarModel(models["salon_glass"], i, matrices);
		ctx.drawCarModel(models["glass"], i, matrices);
		ctx.drawCarModel(models["shtangi"], i, matrices);
		ctx.drawCarModel(models["troll"], i, matrices);
		ctx.drawCarModel(models["zaglushka"], i, matrices);
		ctx.drawCarModel(models["lights"], i, matrices);

		// рендер дверей определен ниже
		renderDoorWithChild(matrices, ctx,  models["doorRf_r"],  models["doorRf"], null, models["doorRf_glass"], -firstAngle, -secondAngle, -1.167, 5.216, -1.21, 4.920, i);
		renderDoorWithChild(matrices, ctx,  models["doorLf_r"],  models["doorLf"], null, models["doorLf_glass"], firstAngle, secondAngle, -1.167, 3.798, -1.21, 4.095, i);

		renderDoorWithChild(matrices, ctx,  models["doorRm_r"],  models["doorRm"], null, models["doorRm_glass"], -firstAngle, -secondAngle, -1.167, 0.04015, -1.21, -0.2565, i);
		renderDoorWithChild(matrices, ctx,  models["doorLm_r"],  models["doorLm"], null, models["doorLm_glass"], firstAngle, secondAngle, -1.167, -1.380, -1.21, -1.083, i);

		renderDoorWithChild(matrices, ctx,  models["doorRb_r"],  models["doorRb"], null, models["doorRb_glass"], -firstAngle, -secondAngle, -1.167, -4.080, -1.21, -4.376, i);
		renderDoorWithChild(matrices, ctx,  models["doorLb_r"],  models["doorLb"], null, models["doorLb_glass"], firstAngle, secondAngle, -1.167, -5.500, -1.21, -5.203, i);

		/* renderDoorWithChild(matrices, ctx,  models["dm3_dm3"],  null, null, null, -thirdAngle, -fourthAngle, -1.136, -0.01922, -1.259, -0.2999, i);
		renderDoorWithChild(matrices, ctx,  null, models["door3_door3"], null, models["door1_door1"], -thirdAngle, -fourthAngle, -1.136, -0.01922, -1.259, -0.2999, i);
		renderDoorWithChild(matrices, ctx, 	models["dm4_dm4"], null, null, null, thirdAngle, fourthAngle, -1.136, -1.171, -1.259, -0.8929, i);
		renderDoorWithChild(matrices, ctx, 	null, models["door4_door4"], null, models["door1_door1"], thirdAngle, fourthAngle, -1.136, -1.171, -1.259, -0.8929, i); */ // AST doors
		// колеса

		renderBackWheels(ctx, state, train, matrices);
		renderFrontWheels(ctx, state, train, matrices);


		// спизжено из ютонга Buses4MC 2 - nbt1248
		updateLogic(state, train);
		renderLights(ctx, state, train, matrices);
		//renderBreakLights(ctx, state, train, matrices);
		//renderTurnLights(ctx, state, train, matrices);
		//renderReverse(ctx, state, train, matrices);	
		displRender(ctx, state, train, matrices);
	}

}

function updateLogic(state, train) {
	updateWheelAngle(train, state);
	updateSteeringAngle(train, state);
	updateTurnState(train, state);
	updateSpeedStates(train, state);
	//updateRocking(train, state, 30, 30, 10, 10);
}



/* function renderTurnLights(ctx, state, train, matrices) {
	let shouldRenderTurnLights = Timing.elapsed() % 1.0 > 0.5;
	if (state.isTurningRight && shouldRenderTurnLights) ctx.drawCarModel(models["povr_povr"], 0, matrices);
	if (state.isTurningLeft && shouldRenderTurnLights) ctx.drawCarModel(models["povl_povl"], 0, matrices);
} */ 


function renderBackWheels(ctx, state, train, matrices) {
	const radius = 1.3;
	matrices.pushPose();
	matrices.translate(0, -0.5174, -3.065);
	matrices.rotateX(state.wheelAngle * radius);
	matrices.translate(0, 0.5174, 3.065);

	ctx.drawCarModel(models["wheels_b"], 0, matrices);
	//ctx.drawCarModel(models["wheelbl_wheelbl"], 0, matrices);

	matrices.popPose();
}

function renderFrontWheels(ctx, state, train, matrices) {
	const radius = 1.3;
	matrices.pushPose();
	matrices.translate(-1.09, -0.5174, 2.936);
	matrices.rotateY(0.0);
	matrices.rotateX(state.wheelAngle * radius);
	matrices.translate(1.09, 0.5174, -2.936);

	ctx.drawCarModel(models["wheel_fr"], 0, matrices);

	matrices.popPose();

	matrices.pushPose();
	matrices.translate(1.10, -0.53, 2.95);
	matrices.rotateY(0.0);
	matrices.rotateX(state.wheelAngle * radius);
	matrices.translate(-1.10, 0.53, -2.95);

	ctx.drawCarModel(models["wheel_fl"], 0, matrices);

	matrices.popPose();
}

/* function renderSteeringWheel(ctx, state, train, matrices) {
	let steeringAngle = state.steeringAngle * 6;
	matrices.pushPose();
	matrices.translate(0.7353, 0.7917, 5.069);
	matrices.rotate(0, 0.774312, -0.632804, steeringAngle);
	matrices.translate(-0.7353, -0.7917, -5.069);

	ctx.drawCarModel(models["steering_steering"], 0, matrices);

	matrices.popPose();
	// 0.7528 4.848
} */
		
/*
	Конвертит из объекта класса джава в объект джаваскрипта:
	а именно из карты<строка, RawModel> в объект JS<строка, ModelCluster>
*/
function uploadVehicleModels(rawModels) {
	result = {};
	for (it = rawModels.entrySet().iterator(); it.hasNext();) {
		entry = it.next();

		let jsStringKey = "" + entry.getKey(); // строка в жс строку
		if (jsStringKey == "salon") entry.getValue().setAllRenderType("interior"); //включение интерьера
		if (jsStringKey == "tablo") entry.getValue().setAllRenderType("light");
		if (jsStringKey == "lights") entry.getValue().setAllRenderType("light");
		if (jsStringKey == "salon_lights") entry.getValue().setAllRenderType("light");
		if (jsStringKey == "ograda") entry.getValue().setAllRenderType("interior");
		if (jsStringKey == "paper_removed") entry.getValue().setAllRenderType("interior");
		if (jsStringKey == "doorRf_glass") entry.getValue().setAllRenderType("exteriortranslucent");
		if (jsStringKey == "doorRm_glass") entry.getValue().setAllRenderType("exteriortranslucent");
		if (jsStringKey == "doorRb_glass") entry.getValue().setAllRenderType("exteriortranslucent");
		if (jsStringKey == "doorLf_glass") entry.getValue().setAllRenderType("exteriortranslucent");
		if (jsStringKey == "doorLm_glass") entry.getValue().setAllRenderType("exteriortranslucent");
		if (jsStringKey == "doorLb_glass") entry.getValue().setAllRenderType("exteriortranslucent");
		if (jsStringKey == "salon_glass") entry.getValue().setAllRenderType("interiortranslucent");
		if (jsStringKey == "glass") entry.getValue().setAllRenderType("exteriortranslucent");

		entry.getValue().applyUVMirror(false, true);
		result[jsStringKey] = ModelManager.uploadVertArrays(entry.getValue());
	}
	return result;
}

function renderLights(ctx, state, train, matrices) {
	let shouldRenderLights = MinecraftClient.worldDayTime() % 24000 > 13000;
	if (shouldRenderLights) {
		ctx.drawCarModel(models["lights"], 0, matrices);
	}
}
/*
function renderBreakLights(ctx, state, train, matrices) {
	if (state.isBreaking) ctx.drawCarModel(models["farystop_farystop"], 0, matrices);
}

function renderReverse(ctx, state, train, matrices) {
	if (train.isReversed()) {
		ctx.drawCarModel(models["faryzad_faryzad"], 0, matrices);
	}
}*/

/*
	Рендер части вместе с дочерней частью
	Работает по принципу, что преобразования матрицы, которая находится глубже в стеке влияет на все матрицы над ней. 
	То есть, есть матрица поворота механизма/крайней ширмы(если это ширмовая дверь) Она пушится, 
	к ней применяется поворот[снизу распишу прикол про поворот, почему там много сдвигов], потом пушится дочерняя матрица, и 
	к ней тоже применяется поворот, дочерняя матрица рендрится, лопается, потом рендерится родительская и тоже лопается.

	К Дочерней матрице применяются все преобразования родительской матрицы - значит она будет прикреплена к матрице родителя и условно будет 
	действовать как звено цепи, которое может вращаться, но ее тянет другое звено. Это нам и нужно для ширмовых/планетарных/любых дверей
	где дверь соединяется с корпусом через 1 механизм на 2 шарнирах.
*/
function renderDoorWithChild(matrices, ctx, parentDoor, childDoor, parentInt, childInt, firstAngle, secondAngle, x1, z1, x2, z2, i) {
	matrices.pushPose(); // пушим родительскую матрицу в стек
	matrices.translate(x1, 0.0, z1);
	matrices.rotate(0.0, 1.0, 0.0, firstAngle); // поворот двери. Смотри самый нижний комментарий для пояснения 
	matrices.translate(-x1, 0.0, -z1);
	{
		matrices.pushPose();    // пуш матрицы дочерней
		matrices.translate(x2, 0.0, z2);
		matrices.rotate(0.0, 1.0, 0.0, secondAngle); // поворот
		matrices.translate(-x2, 0.0, -z2);
		if (childDoor != null) ctx.drawCarModel(childDoor, i, matrices); // рендер внутренней ширмы либо двери
		if (childInt != null) ctx.drawCarModel(childInt, i, matrices);;
		matrices.popPose(); // дочерняя матрица лопается
	}
	if (parentDoor != null) ctx.drawCarModel(parentDoor, i, matrices); // рендер крайней ширмы либо механизма двери
	if (parentInt != null) ctx.drawCarModel(parentInt, i, matrices);
	matrices.popPose(); // родительская матрица лопается

}

/* Это код просчитывания  ̶г̶р̶а̶д̶у̶с̶а̶  радиана поворота колеса - он выполняется каждый кадр. И каждый кадр прога смотрит на 
	 дельту игрового времени (кол-во секунд между прошлым и нынешни кадром) и скорость поезда, высчитывает сколько поезд 
	 прошел с прошлого кадра, конвертит в радиан (в данном случае конвертить ничего не надо, см чуть ниже). 

	 Этот код, в теории, запруфан от изменения ФПС. С разным ФПС анимация колес не будет различаться по скорости.

	 Тут, когда поезд движется на x метров за кадр, колесо радиуса 1 тоже сдвинулось на x метров.
   чтобы посчитать изменение в радианах, поделим x на длину круга, а потом умножим на 2pi радиана, 
   по его определению. Но длина окружности 1 это тоже 2pi, значит они сокращаются, а путь пройденный поездом
   и есть изменение дуги в радианах.
*/

function smoothCubic(x) { //кубическая функция - в отрезке 0-1 возвращает сглаженную функцию 0-1
	return x * x * (-2 * x + 3);
}

function repaint(models) {
	models["body"] = models["body"].copyForMaterialChanges();
	models["troll"] = models["troll"].copyForMaterialChanges();
	models["salon"] = models["salon"].copyForMaterialChanges();

	models["body"].replaceTexture("su12_ii_main_3door.png", Resources.idRelative("mtr:su_ii_12_3d/trollino/su12_ii_main_3door.png"))
	models["salon"].replaceTexture("su12_ii_stangen.png", Resources.idRelative("mtr:su_ii_12_3d/trollino/su12_ii_stangen.png"));
	models["salon"].replaceTexture("su_ii_sitze.png", Resources.idRelative("mtr:su_ii_12_3d/cng/su_ii_sitze.png"));
	models["troll"].replaceTexture("mk3.png", Resources.idRelative("mtr:su_ii_12_3d/trollino/mk3.png"))
}