importPackage(java.awt);
importPackage(java.awt.geom);
include(Resources.id('mtrsteamloco:scripts/display_helper.js'));

let slotHeadDestCfg = {								// ЭМУ ОСНОВНОЙ ГОЛОВНОЙ (БЕЛЫЕ ОГНИ) ВАГОН
    version: 1,
    texSize: [1024, 128],
    slots: [
        {
            name: 'head-dest', // head - dest
            texArea: [0, 0, 1024, 128],
            pos: [
                [
                    [-0.8666, 1.877, 5.369],		// Левый Верхний Угол XZY
                    [-0.8687, 1.593, 5.4002],		// Левый Нижний Угол XZY
                    [0.8687, 1.593, 5.4002],		// Правый Нижний Угол XZY
                    [0.8666, 1.877, 5.369],		// Правый Верхний Угол XZY
                ],
            ],
            offsets: [[0, 0, 0]],
        },
        {
          name: 'head-side-dest', // side split - dest
          texArea: [0, 0, 1024, 128],
          pos: [
              [
                [-1.190, 1.470, 2.418],      // Правый Верхний Угол XZY
                [-1.199, 1.282, 2.418],      // Правый Нижний Угол XZY
                [-1.199, 1.282, 3.662],	    // Левый Нижний Угол XZY
                [-1.190, 1.470, 3.662],	    // Левый Верхний Угол XZY
              ],    
          ],
          offsets: [[-0.026, 0, 0]],
      },
    ],
};

let slotHeadRouteCfg = {							// ЭМУ МАРШРУТ ГОЛОВНОЙ (БЕЛЫЕ ОГНИ) ВАГОН
    version: 1,
    texSize: [256, 128],
    slots: [
        {
            name: 'head-route', // head - route
            texArea: [0, 0, 256, 128],
            pos: [
                [
                    [-0.8666, 1.877, 5.369],		// Левый Верхний Угол XZY
                    [-0.8687, 1.593, 5.4002],		// Левый Нижний Угол XZY
                    [-0.3887, 1.593, 5.4002],		// Правый Нижний Угол XZY
                    [-0.3866, 1.877, 5.369],		// Правый Верхний Угол XZY
                ],
            ],
            offsets: [[0, 0, 0.001]],
        },
        {
            name: 'head-side-route', // side split - route
            texArea: [0, 0, 256, 128],
            pos: [  
                [
                    [-1.190, 1.470, 2.418],		// Правый Верхний Угол XZY
                    [-1.199, 1.282, 2.418],		// Правый Нижний Угол XZY
                    [-1.199, 1.282, 2.768],		// Левый Нижний Угол XZY
                    [-1.190, 1.470, 2.768],		// Левый Верхний Угол XZY

                ],
            ],
            offsets: [[-0.0264, 0, 0]],
        },
        {
            name: 'head-alone-route',            // back - dest
            texArea: [0, 0, 256, 128],
            pos: [  
                [
                    [0.164539, 1.85591, -6.129],     // Левый Верхний Угол XZY
                    [0.164199, 1.67936, -6.129],     // Левый Нижний Угол XZY
                    [-0.164201, 1.67936, -6.129],     // Правый Нижний Угол XZY
                    [-0.164551, 1.85591, -6.129],     // Правый Верхний Угол XZY
                ],
            ],
            offsets: [[0, 0, 0]],
        },     
    ],
};

let dhHeadBaseDest = new DisplayHelper(slotHeadDestCfg);
let dhHeadBaseRoute = new DisplayHelper(slotHeadRouteCfg);

function displCreate(ctx, state, train) {
    state.pisRateLimit = new RateLimit(0.05);
    state.dhHeadDest = dhHeadBaseDest.create();
    state.dhHeadRoute = dhHeadBaseRoute.create();

    // Получаем номер маршрута через getRouteNum
    state.routeIDmath = getRouteNum(train);
    return (state.routeID = state.routeIDmath);
}



function displDispose(ctx, state, train) {                                       // В душе не ебу что это но это важно
    state.dhHeadDest.close();
    state.dhHeadRoute.close();
}
var EMUFont = Resources.readFont(                                           // Шрифт ЭМУ
    Resources.idRelative('mtr:font/buse.otf') //FFB200
);

function displRender(ctx, state, train) {  
    if (state.pisRateLimit.shouldUpdate()) {
        let g;

        // Default Messages for No Service
        const defaultDestMessage = "NO BOARDING";
        const defaultRouteMessage = "";

        let EMUText = getDestinationStation(train) || defaultDestMessage;  // Get destination or default message
        let EMURouteText = getRouteNum(train) || defaultRouteMessage;      // Get route or default

        state.routeScrollPos = (state.routeScrollPos || 0) + 30; // Increment scroll position
        const maxScrollWidth = 1024; // Adjust based on display width

        // Destination Display Rendering
        [
            { dh: state.dhHeadDest, graphicsName: 'head-dest', text: EMUText },
            { dh: state.dhHeadDest, graphicsName: 'head-side-dest', text: EMUText },
        ].forEach((element) => {
            renderScrollingText(
                element.dh,
                element.graphicsName,
                element.text,
                state.routeScrollPos,
                maxScrollWidth,
                1024,
                128
            );
        });

        // Route Display Rendering
        [
            { dh: state.dhHeadRoute, graphicsName: 'head-route', text: EMURouteText },
            { dh: state.dhHeadRoute, graphicsName: 'head-side-route', text: EMURouteText },
        ].forEach((element) => {
            renderScrollingText(
                element.dh,
                element.graphicsName,
                element.text,
                state.routeScrollPos,
                maxScrollWidth,
                256,
                128
            );
        });
    }

    // Draw models
    ctx.drawCarModel(state.dhHeadDest.model, 0, null);
    ctx.drawCarModel(state.dhHeadRoute.model, 0, null);
}

// Helper function to render scrolling text
function renderScrollingText(dh, graphicsName, text, scrollPos, maxScrollWidth, texWidth, texHeight) {
    let g = dh.graphicsFor(graphicsName);
    g.setComposite(AlphaComposite.Clear);
    g.fillRect(0, 0, texWidth, texHeight);
    g.setComposite(AlphaComposite.SrcOver);
    g.setColor(Color(0xFFB200));

    let fontSize = 140; // Initial font size
    g.setFont(EMUFont.deriveFont(Font.PLAIN, fontSize));
    let fontMetrics = g.getFontMetrics();
    let textWidth = fontMetrics.stringWidth(text);

    // Adjust scroll position
    if (textWidth > texWidth) {
        scrollPos = scrollPos % (textWidth + texWidth);
        g.drawString(text, texWidth - scrollPos, 135);
    } else {
        // Center the text if it fits within the bounds
        let xPosition = (texWidth - textWidth) / 2;
        g.drawString(text, xPosition, 135);
    }

    dh.upload();
}

// Adjust getRouteNum for default behavior
function getRouteNum(train) {
    let stationList = train.getThisRoutePlatforms();
    if (!stationList || stationList.size() === 0) {
        return "";
    }
    return stationList[0].route.lightRailRouteNumber.toString();
}

// Функция для получения конечной станции
function getEndStation(train) {
    let stationList = train.getThisRoutePlatforms();
    let ret = "";
    ret = stationList[stationList.size() - 1].destinationName; // Исправлено на последнюю станцию
    return ret;
}

// Функция для получения первой станции
function getFirstStation(train) {
    let stationList = train.getThisRoutePlatforms();
    let station = stationList[0].station;

    let ret = station == null ? "ERROR" : station.name;
    return ret;
}

function getDestinationStation(train) {
    let stationList = train.getThisRoutePlatforms();
    if (!stationList || stationList.size() === 0) {
        // Если станций нет, выводим сообщение по умолчанию
        return "TO THE DEPOT";
    }

    // Получаем первую и конечную станции
    let firstStation = getFirstStation(train);
    let endStation = getEndStation(train);

    // Возвращаем строку вида "Первая станция - Конечная станция"
    return getEndStation(train);
}


