importPackage(java.awt);
importPackage(java.awt.geom);
include(Resources.id('mtrsteamloco:scripts/display_helper.js'));

let slotHeadDestCfg = {								// ЭМУ ОСНОВНОЙ ГОЛОВНОЙ (БЕЛЫЕ ОГНИ) ВАГОН
    version: 1,
    texSize: [1024, 128],
    slots: [
        {
            name: 'head-dest', // head - dest
            texArea: [0, 0, 1024, 128],
            pos: [
                [[-0.84035, 1.72218, 5.52352], [-0.84035, 1.51851, 5.52352], [0.84347, 1.51851, 5.52352], [0.84347, 1.72218, 5.52352]],
            ],
            offsets: [[0, 0, 0]],
        },
        {
          name: 'head-side-dest', // side split - dest
          texArea: [0, 0, 1024, 128],
          pos: [
              [[-1.22563, 1.3403, 2.60682], [-1.23398, 1.17265, 2.60682], [-1.23398, 1.17265, 3.62837], [-1.22563, 1.3403, 3.62837]]  
          ],
          offsets: [[-0.026, 0, 0]],
      },
    ],
};

let slotHeadRouteCfg = {							// ЭМУ МАРШРУТ ГОЛОВНОЙ (БЕЛЫЕ ОГНИ) ВАГОН
    version: 1,
    texSize: [256, 128],
    slots: [
        {
            name: 'head-route', // head - route
            texArea: [0, 0, 256, 128],
            pos: [
                [[-0.84035, 1.72192, 5.52352], [-0.84035, 1.50726, 5.52352], [-0.50671, 1.50726, 5.52352], [-0.50671, 1.72192, 5.52352]],
            ],
            offsets: [[0, 0, 0.001]],
        },
        {
            name: 'head-right-side-route', // side split - route
            texArea: [0, 0, 256, 128],
            pos: [  
                [[-1.22405, 1.341, 1.83847], [-1.23305, 1.169, 1.83847], [-1.23315, 1.169, 2.22184], [-1.23315, 1.341, 2.22184]],
            ],
            offsets: [[-0.0264, 0, 0]],
        },
        {
            name: 'head-left-side-route', // side split - route
            texArea: [0, 0, 256, 128],
            pos: [  
                [[1.29357, 1.341, 2.99212], [1.29711, 1.169, 2.99212], [1.29711, 1.169, 2.60412], [1.29357, 1.341, 2.60412]],
            ],
            offsets: [[-0.0264, 0, 0]],
        }
    ],
};
let slotBackRouteCfg = {							// ЭМУ МАРШРУТ ГОЛОВНОЙ (БЕЛЫЕ ОГНИ) ВАГОН
    version: 1,
    texSize: [256, 128],
    slots: [
        {
            name: 'head-alone-route',            // back - dest
            texArea: [0, 0, 256, 128],
            pos: [  
                [[0.19543, 1.74052, -4.24897], [0.19543, 1.57008, -4.24897], [-0.19277, 1.57008, -4.24897], [-0.19277, 1.74052, -4.24897]],
            ],
            offsets: [[0, 0, 0]],
        },  
    ]
};   

let dhHeadBaseDest = new DisplayHelper(slotHeadDestCfg);
let dhHeadBaseRoute = new DisplayHelper(slotHeadRouteCfg);
let dhBackBaseRoute = new DisplayHelper(slotBackRouteCfg);

function displCreate(ctx, state, train) {
    state.pisRateLimit = new RateLimit(3);
    state.dhHeadDest = dhHeadBaseDest.create();
    state.dhHeadRoute = dhHeadBaseRoute.create();
    state.dhBackRoute = dhBackBaseRoute.create();

    // Получаем номер маршрута через getRouteNum
    state.routeIDmath = getRouteNum(train);
    return (state.routeID = state.routeIDmath);
}



function displDispose(ctx, state, train) {                                       // В душе не ебу что это но это важно
    state.dhHeadDest.close();
    state.dhHeadRoute.close();
    state.dhBackRoute.close();
}
var EMUFont = Resources.readFont(                                           // Шрифт ЭМУ
    Resources.idRelative('mtr:font/buse.otf')
);

function displRender(ctx, state, train) {  
    if (state.pisRateLimit.shouldUpdate()) {
        let g;

        // Default Messages for No Service
        const defaultDestMessage = "SOR NB 18";
        const defaultRouteMessage = "";

        let EMUText = getDestinationStation(train) || defaultDestMessage;  // Get destination or default message
        let EMURouteText = getRouteNum(train) || defaultRouteMessage;      // Get route or default

        state.routeScrollPos = (state.routeScrollPos || 0) + 30; // Increment scroll position
        const maxScrollWidth = 1024; // Adjust based on display width

        // Destination Display Rendering
        [
            { dh: state.dhHeadDest, graphicsName: 'head-dest', text: EMUText },
            { dh: state.dhHeadDest, graphicsName: 'head-side-dest', text: EMUText },
        ].forEach((element) => {
            renderScrollingText(
                element.dh,
                element.graphicsName,
                element.text,
                state.routeScrollPos,
                maxScrollWidth,
                1024,
                128
            );
        });

        // Route Display Rendering
        [
            { dh: state.dhHeadRoute, graphicsName: 'head-route', text: EMURouteText },
            { dh: state.dhHeadRoute, graphicsName: 'head-right-side-route', text: EMURouteText },
            { dh: state.dhHeadRoute, graphicsName: 'head-left-side-route', text: EMURouteText },
            { dh: state.dhBackRoute, graphicsName: 'head-alone-route', text: EMURouteText },
        ].forEach((element) => {
            renderScrollingText(
                element.dh,
                element.graphicsName,
                element.text,
                state.routeScrollPos,
                maxScrollWidth,
                256,
                128
            );
        });
    }

    // Draw models
    ctx.drawCarModel(state.dhHeadDest.model, 1, null);
    ctx.drawCarModel(state.dhHeadRoute.model, 1, null);
    ctx.drawCarModel(state.dhBackRoute.model, 3, null);
}

// Helper function to render scrolling text
function renderScrollingText(dh, graphicsName, text, scrollPos, maxScrollWidth, texWidth, texHeight) {
    let g = dh.graphicsFor(graphicsName);
    g.setComposite(AlphaComposite.Clear);
    g.fillRect(0, 0, texWidth, texHeight);
    g.setComposite(AlphaComposite.SrcOver);
    g.setColor(new Color(1, 0.5, 0));

    let fontSize = 140; // Initial font size
    g.setFont(EMUFont.deriveFont(Font.PLAIN, fontSize));
    let fontMetrics = g.getFontMetrics();
    let textWidth = fontMetrics.stringWidth(text);

    // Adjust scroll position
    if (textWidth > texWidth) {
        scrollPos = scrollPos % (textWidth + texWidth);
        g.drawString(text, texWidth - scrollPos, 135);
    } else {
        // Center the text if it fits within the bounds
        let xPosition = (texWidth - textWidth) / 2;
        g.drawString(text, xPosition, 135);
    }

    dh.upload();
}

// Adjust getRouteNum for default behavior
function getRouteNum(train) {
    let stationList = train.getThisRoutePlatforms();
    if (!stationList || stationList.size() === 0) {
        return "";
    }
    return stationList[0].route.lightRailRouteNumber.toString();
}

// Функция для получения конечной станции
function getEndStation(train) {
    let stationList = train.getThisRoutePlatforms();
    let ret = "";
    ret = stationList[stationList.size() - 1].destinationName; // Исправлено на последнюю станцию
    return ret;
}

// Функция для получения первой станции
function getFirstStation(train) {
    let stationList = train.getThisRoutePlatforms();
    let station = stationList[0].station;

    let ret = station == null ? "ERROR" : station.name;
    return ret;
}

function getDestinationStation(train) {
    let stationList = train.getThisRoutePlatforms();
    if (!stationList || stationList.size() === 0) {
        // Если станций нет, выводим сообщение по умолчанию
        return "TO THE DEPORT";
    }

    // Получаем первую и конечную станции
    let firstStation = getFirstStation(train);
    let endStation = getEndStation(train);

    // Возвращаем строку вида "Первая станция - Конечная станция"
    return getEndStation(train);
}


