include("display.js");

var shouldRenderWindows = true;

var rawModels = ModelManager.loadPartedRawModel(Resources.manager(), Resources.idRelative("mtr:su_ii_18_3d/su_ii_18_3d_a.obj"), null);
var head = uploadPartedModels(rawModels, true, true);

var rawModels2 = ModelManager.loadPartedRawModel(Resources.manager(), Resources.idRelative("mtr:su_ii_18_3d/uzel.obj"), null);
var uzel = uploadPartedModels(rawModels2, true, true);

var rawModels3 = ModelManager.loadPartedRawModel(Resources.manager(), Resources.idRelative("mtr:su_ii_18_3d/su_ii_18_3d_b.obj"), null);
var trail = uploadPartedModels(rawModels3, true, true);
repaint(head)
repaint2(uzel)
repaint3(trail)

function create(ctx, state, train) {
	if (train.trainCars < 4) {
		print("Вагон не рендерится из-за недостатка длины")
		return;
	}

	state.wheelAngle = 0;
	state.steeringAngle = 0.0;
	state.oldFirstCarTurnForSteering = train.lastCarRotation[1] == undefined ? 0.0 :  train.lastCarRotation[1].y() ;
	state.jointOffset = 0;

	displCreate(ctx, state, train)
}

function dispose(ctx, state, train) {
	if (train.trainCars < 4) return
	displDispose(ctx, state, train)
}

function render(ctx, state, train) {
	if (train.trainCars < 4) return
	updateLogic(state, train);
	renderLogic(ctx, state, train);



	displRender(ctx, state, train)
}

function updateLogic(state, train) {
	updateWheelAngle(train, state);
	updateSteeringAngle(train, state, 3.949, 1);

	updateJointScript(state, train) // КОСТЫЛИЩЕЕЕЕ
}

function renderLogic(ctx, state, train) {
	if (train.trainCars < 4) {
		return;
	}

	renderHead(ctx, state, train)
	renderUzel(ctx, state, train)
	renderTail(ctx, state, train)
}

function renderHead(ctx, state, train) {
	let matrices = new Matrices();
	let i = 1;
	let firstAngle = train.doorRightOpen[i] ? 75.0 * Math.PI / 180 * smoothCubic(train.doorValue()) : 0;
	let secondAngle = train.doorRightOpen[i] ? -164.0 * Math.PI / 180 * smoothCubic(train.doorValue()) : 0;
	ctx.drawCarModel(head["body"], i, matrices);
	ctx.drawCarModel(head["salon"], i, matrices);
	ctx.drawCarModel(head["salon_lights"], i, matrices);
	ctx.drawCarModel(head["salon_glass"], i, matrices);
	ctx.drawCarModel(head["lights"], i, matrices);
	ctx.drawCarModel(head["uzel_sn"], i, matrices);
	ctx.drawCarModel(head["tablo_sn"], i, matrices);
	ctx.drawCarModel(head["tablo"], i, matrices);
	ctx.drawCarModel(head["tank_cng"], i, matrices);
	ctx.drawCarModel(head["cond_driv"], i, matrices);

	{
		// WHEELS
		// front right
		const radius = 1.8;
		let steeringAngle = state.steeringAngle;
		matrices.pushPose();
		matrices.translate(-1.050, -0.5266, 3.040);
		matrices.rotateY(steeringAngle);
		matrices.rotateX(state.wheelAngle * radius);
		matrices.translate(1.050, 0.5266, -3.040);

		ctx.drawCarModel(head["wheel_fr"], i, matrices);

		matrices.popPose();

		matrices.pushPose();
		matrices.translate(1.050, -0.5266, 3.040);
		matrices.rotateY(steeringAngle);
		matrices.rotateX(state.wheelAngle * radius);
		matrices.translate(-1.050, 0.5266, -3.040);

		ctx.drawCarModel(head["wheel_fl"], i, matrices);

		matrices.popPose();

		// BACK WHEELS
		matrices.pushPose();
		matrices.translate(0, -0.5266, -2.078);
		matrices.rotateX(state.wheelAngle * radius);
		matrices.translate(0, 0.5266, 2.078);

		ctx.drawCarModel(head["wheels_b"], i, matrices);

		matrices.popPose();
	}


	{
		// DOORS	
		renderDoorWithChild(matrices, ctx,  head["doorRf_r"],  head["doorRf"], null, head["doorRf_glass"], -firstAngle, -secondAngle, -1.169, 5.319, -1.180, 5.021, i);
		renderDoorWithChild(matrices, ctx,  head["doorLf_r"],  head["doorLf"], null, head["doorLf_glass"], firstAngle, secondAngle, -1.169, 3.897, -1.180, 4.194, i);

		renderDoorWithChild(matrices, ctx,  head["doorRm_r"],  head["doorRm"], null, head["doorRm_glass"], -firstAngle, -secondAngle, -1.169, 0.9318, -1.180, 0.6357, i);
		renderDoorWithChild(matrices, ctx,  head["doorLm_r"],  head["doorLm"], null, head["doorLm_glass"], firstAngle, secondAngle, -1.169, -0.4879, -1.180, -0.1912, i);
	}
}

function renderUzel(ctx, state, train) {
	let matrices = new Matrices()
	let i = 2;

	matrices.pushPose();
	matrices.translate(-state.jointOffset, 0, 0)
	ctx.drawCarModel(uzel["uzel_sn"], i, matrices);
	ctx.drawCarModel(uzel["uzel"], i, matrices);
	matrices.popPose();
}

function renderTail(ctx, state, train) {
	let matrices = new Matrices()
	let i = 3;
	let coef = train.lastCarRotation[3].y() % (3.1415 / 2)
	if (coef > 3.1415 / 4) coef = 3.1415 / 2 - coef;
	coef = coef / (3.1415 / 4);
	let firstAngle = train.doorRightOpen[i] ? 75.0 * Math.PI / 180 * smoothCubic(train.doorValue()) : 0;
	let secondAngle = train.doorRightOpen[i] ? -164.0 * Math.PI / 180 * smoothCubic(train.doorValue()) : 0;
	ctx.drawCarModel(trail["body"], i, matrices);
	ctx.drawCarModel(trail["salon"], i, matrices);
	ctx.drawCarModel(trail["salon_lights"], i, matrices);
	ctx.drawCarModel(trail["salon_glass"], i, matrices);
	ctx.drawCarModel(trail["lights"], i, matrices);
	ctx.drawCarModel(trail["uzel_sn"], i, matrices);
	ctx.drawCarModel(trail["tablo_sz"], i, matrices);
	ctx.drawCarModel(trail["tablo"], i, matrices);
	ctx.drawCarModel(trail["cond"], i, matrices);
	ctx.drawCarModel(trail["zaglushka"], i, matrices);
	{
		// WHEEL
		const radius = 1.8;

		matrices.pushPose();
		matrices.translate(0, -0.5266, -0.9862);
		matrices.rotateX(state.wheelAngle * radius);
		matrices.translate(0, 0.5266, 0.9862);

		ctx.drawCarModel(trail["wheels_b"], i, matrices);

		matrices.popPose();
	}

	{
		// DOORS
		renderDoorWithChild(matrices, ctx,  trail["doorR_r"],  trail["doorR"], null, trail["doorR_glass"], -firstAngle, -secondAngle, -1.169, 1.434, -1.180, 1.138, i);
		renderDoorWithChild(matrices, ctx,  trail["doorL_r"],  trail["doorL"], null, trail["doorL_glass"], firstAngle, secondAngle, -1.169, 0.01392, -1.180, 0.3105, i);

		//renderDoorWithChild(matrices, ctx,  trail["doorRb_r"],  trail["doorRb"], null, trail["doorRb_glass"], -firstAngle, -secondAngle, -1.169, -2.010, -1.180, -2.307, i);
		//renderDoorWithChild(matrices, ctx,  trail["doorLb_r"],  trail["doorLb"], null, trail["doorLb_glass"], firstAngle, secondAngle, -1.169, -3.430, -1.180, -3.135, i);
	}
}

/////////////////////////////////////

function renderDoorWithChild(matrices, ctx, parentDoor, childDoor, parentInt, childInt, firstAngle, secondAngle, x1, z1, x2, z2, i) {
	matrices.pushPose(); // пушим родительскую матрицу в стек
	matrices.translate(x1, 0.0, z1);
	matrices.rotate(0.0, 1.0, 0.0, firstAngle); // поворот двери. Смотри самый нижний комментарий для пояснения 
	matrices.translate(-x1, 0.0, -z1);
	{
		matrices.pushPose();    // пуш матрицы дочерней
		matrices.translate(x2, 0.0, z2);
		matrices.rotate(0.0, 1.0, 0.0, secondAngle); // поворот
		matrices.translate(-x2, 0.0, -z2);
		if (childDoor != null) ctx.drawCarModel(childDoor, i, matrices); // рендер внутренней ширмы либо двери
		if (childInt != null) ctx.drawCarModel(childInt, i, matrices);;
		matrices.popPose(); // дочерняя матрица лопается
	}
	if (parentDoor != null) ctx.drawCarModel(parentDoor, i, matrices); // рендер крайней ширмы либо механизма двери
	if (parentInt != null) ctx.drawCarModel(parentInt, i, matrices);
	matrices.popPose(); // родительская матрица лопается

}

//////////////////////////////

// ПОВОРОТ ВЕДУЩИХ КОЛЕС
function updateSteeringAngle(train, state, l, i) {
	if (Timing.delta() == 0.0) return;

	let delta = getCorrectDelta(train.lastCarRotation[i].y(), state.oldFirstCarTurnForSteering)
	if (delta == 0.0) {
		state.steeringAngle = 0.0;
		state.oldFirstCarTurnForSteering = train.lastCarRotation[i].y();
		return;
	}
	const coef = 0.0625;

	let radius = train.speed() * Timing.delta() / delta;
	let sin = clamp(coef * l / radius, -1.0, 1.0);

	if (train.isReversed()) sin *= -1;

	state.steeringAngle = Math.asin(sin);
	state.oldFirstCarTurnForSteering = train.lastCarRotation[i].y();
}

function updateJointScript(state, train) {
	// тут пока пусто, но возможно тут будет костыльный скрипт


	let delta = getCorrectDelta(train.lastCarRotation[1] == undefined ? 0.0 :  train.lastCarRotation[1].y(), train.lastCarRotation[3] == undefined ? 0.0 :  train.lastCarRotation[3].y())

	delta = delta / 2;
	state.jointOffset = Math.sin(delta) * 2;
}


// ВРАЩЕНИE КОЛЕС
function updateWheelAngle(train, state) {
	const angleLoop = 10000;

	// if (!train.shouldRenderDetail()) return 0;
	let speedMps = 20 * train.speed();
	let delta = Timing.delta();
	if (train.isReversed()) {
		state.wheelAngle -= speedMps * delta;
	} else {
		state.wheelAngle += speedMps * delta;
	}

	if (state.wheelAngle > angleLoop) state["wheelAngle"] = 0;
	if (state.wheelAngle < 0) state["wheelAngle"] = angleLoop;
}

function uploadPartedModels(rawModels, removeRenderType, invertUV) {
	result = {};
	for (it = rawModels.entrySet().iterator(); it.hasNext();) {
		entry = it.next();

		let jsStringKey = "" + entry.getKey();
		if (jsStringKey == "salon") entry.getValue().setAllRenderType("interior"); //включение интерьера
		if (jsStringKey == "tablo") entry.getValue().setAllRenderType("light");
		if (jsStringKey == "lights") entry.getValue().setAllRenderType("light");
		if (jsStringKey == "salon_lights") entry.getValue().setAllRenderType("light");
		if (jsStringKey == "doorRf_glass") entry.getValue().setAllRenderType("exteriortranslucent");
		if (jsStringKey == "doorRm_glass") entry.getValue().setAllRenderType("exteriortranslucent");
		if (jsStringKey == "doorR_glass") entry.getValue().setAllRenderType("exteriortranslucent");
		if (jsStringKey == "doorRb_glass") entry.getValue().setAllRenderType("exteriortranslucent");
		if (jsStringKey == "doorLf_glass") entry.getValue().setAllRenderType("exteriortranslucent");
		if (jsStringKey == "doorLm_glass") entry.getValue().setAllRenderType("exteriortranslucent");
		if (jsStringKey == "doorL_glass") entry.getValue().setAllRenderType("exteriortranslucent");
		if (jsStringKey == "doorLb_glass") entry.getValue().setAllRenderType("exteriortranslucent");
		if (jsStringKey == "salon_glass") entry.getValue().setAllRenderType("interiortranslucent");
		if (jsStringKey == "glass") entry.getValue().setAllRenderType("exteriortranslucent");

		entry.getValue().applyUVMirror(false, invertUV);
		result[jsStringKey] = ModelManager.uploadVertArrays(entry.getValue());
	}
	return result;
}

function getCorrectDelta(angle1, angle2) {
	let delta = angle1 - angle2;
	if (Math.abs(delta) > Math.PI) {
		if (delta < 0) {
			return Math.PI * 2 + delta
		} else {
			return -Math.PI * 2 + delta
		}
	}
	return delta;
}

function clamp(num, min, max) {
	if (num > max) return max;
	if (num < min) return min;
	return num;
}

function smoothCubic(x) { //кубическая функция - в отрезке 0-1 возвращает сглаженную функцию 0-1
	return x * x * (-2 * x + 3);
}

function repaint(models) {
	models["body"] = models["body"].copyForMaterialChanges();
	models["tank_cng"] = models["tank_cng"].copyForMaterialChanges();
	models["salon"] = models["salon"].copyForMaterialChanges();
	models["salon_glass"] = models["salon_glass"].copyForMaterialChanges();

	models["body"].replaceTexture("su18_ii_v_main.png", Resources.idRelative("mtr:su_ii_18_3d/cng/su18_ii_v_main.png"))
	models["body"].replaceTexture("SU_II_Lightframes.png", Resources.idRelative("mtr:su_ii_18_3d/cng/SU_II_Lightframes.png"));
	models["salon"].replaceTexture("su18_ii_v_int.png", Resources.idRelative("mtr:su_ii_18_3d/cng/su18_ii_v_int.png"));
	models["salon"].replaceTexture("su18_ii_v_int2.png", Resources.idRelative("mtr:su_ii_18_3d/cng/su18_ii_v_int2.png"));
	models["salon"].replaceTexture("su18_ii_h_int_3door.png", Resources.idRelative("mtr:su_ii_18_3d/cng/su18_ii_h_int_3door.png"));
	models["salon"].replaceTexture("su18_ii_h_int2_3door.png", Resources.idRelative("mtr:su_ii_18_3d/cng/su18_ii_h_int2_3door.png"));
	models["salon"].replaceTexture("su_ii_stangen.png", Resources.idRelative("mtr:su_ii_18_3d/cng/su_ii_stangen.png"));
	models["salon"].replaceTexture("su_ii_stangen_h.png", Resources.idRelative("mtr:su_ii_18_3d/cng/su_ii_stangen_h.png"));
	models["salon"].replaceTexture("su_ii_sitze.png", Resources.idRelative("mtr:su_ii_18_3d/cng/su_ii_sitze.png"));
	models["salon_glass"].replaceTexture("su_ii_trennscheibe.png", Resources.idRelative("mtr:su_ii_18_3d/cng/su_ii_trennscheibe.png"));
	models["salon"].replaceTexture("su_ii_pictogramme.png", Resources.idRelative("mtr:su_ii_18_3d/cng/su_ii_pictogramme"));
	models["tank_cng"].replaceTexture("tank_cng.png", Resources.idRelative("mtr:su_ii_18_3d/cng/tank_cng.png"))
}

function repaint2(models) {
	models["uzel"] = models["uzel"].copyForMaterialChanges();

	models["uzel"].replaceTexture("su_ii_stangen.png", Resources.idRelative("mtr:su_ii_18_3d/cng/su_ii_stangen.png"))
}

function repaint3(models) {
	models["body"] = models["body"].copyForMaterialChanges();
	models["salon"] = models["salon"].copyForMaterialChanges();
	models["salon_glass"] = models["salon_glass"].copyForMaterialChanges();

	models["body"].replaceTexture("su18_ii_h_main_3door.png", Resources.idRelative("mtr:su_ii_18_3d/cng/su18_ii_h_main_3door.png"))
	models["body"].replaceTexture("SU_II_Lightframes.png", Resources.idRelative("mtr:su_ii_18_3d/cng/SU_II_Lightframes.png"));
	models["salon"].replaceTexture("su18_ii_v_int.png", Resources.idRelative("mtr:su_ii_18_3d/cng/su18_ii_v_int.png"));
	models["salon"].replaceTexture("su18_ii_v_int2.png", Resources.idRelative("mtr:su_ii_18_3d/cng/su18_ii_v_int2.png"));
	models["salon"].replaceTexture("su18_ii_h_int_3door.png", Resources.idRelative("mtr:su_ii_18_3d/cng/su18_ii_h_int_3door.png"));
	models["salon"].replaceTexture("su18_ii_h_int2_3door.png", Resources.idRelative("mtr:su_ii_18_3d/cng/su18_ii_h_int2_3door.png"));
	models["salon"].replaceTexture("su_ii_stangen.png", Resources.idRelative("mtr:su_ii_18_3d/cng/su_ii_stangen.png"));
	models["salon"].replaceTexture("su_ii_stangen_h.png", Resources.idRelative("mtr:su_ii_18_3d/cng/su_ii_stangen_h.png"));
	models["salon"].replaceTexture("su_ii_sitze.png", Resources.idRelative("mtr:su_ii_18_3d/cng/su_ii_sitze.png"));
	models["salon_glass"].replaceTexture("su_ii_trennscheibe.png", Resources.idRelative("mtr:su_ii_18_3d/cng/su_ii_trennscheibe.png"));
	models["salon"].replaceTexture("su_ii_pictogramme.png", Resources.idRelative("mtr:su_ii_18_3d/cng/su_ii_pictogramme"));
}