/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import mchorse.bbs_mod.BBSCommands;
import mchorse.bbs_mod.BBSSettings;
import mchorse.bbs_mod.actions.ActionHandler;
import mchorse.bbs_mod.actions.ActionManager;
import mchorse.bbs_mod.actions.types.AttackActionClip;
import mchorse.bbs_mod.actions.types.DamageActionClip;
import mchorse.bbs_mod.actions.types.SwipeActionClip;
import mchorse.bbs_mod.actions.types.blocks.BreakBlockActionClip;
import mchorse.bbs_mod.actions.types.blocks.InteractBlockActionClip;
import mchorse.bbs_mod.actions.types.blocks.PlaceBlockActionClip;
import mchorse.bbs_mod.actions.types.chat.ChatActionClip;
import mchorse.bbs_mod.actions.types.chat.CommandActionClip;
import mchorse.bbs_mod.actions.types.item.ItemDropActionClip;
import mchorse.bbs_mod.actions.types.item.UseBlockItemActionClip;
import mchorse.bbs_mod.actions.types.item.UseItemActionClip;
import mchorse.bbs_mod.blocks.ModelBlock;
import mchorse.bbs_mod.blocks.entities.ModelBlockEntity;
import mchorse.bbs_mod.blocks.entities.ModelProperties;
import mchorse.bbs_mod.camera.clips.ClipFactoryData;
import mchorse.bbs_mod.camera.clips.converters.DollyToKeyframeConverter;
import mchorse.bbs_mod.camera.clips.converters.DollyToPathConverter;
import mchorse.bbs_mod.camera.clips.converters.IdleConverter;
import mchorse.bbs_mod.camera.clips.converters.IdleToDollyConverter;
import mchorse.bbs_mod.camera.clips.converters.IdleToKeyframeConverter;
import mchorse.bbs_mod.camera.clips.converters.IdleToPathConverter;
import mchorse.bbs_mod.camera.clips.converters.PathToDollyConverter;
import mchorse.bbs_mod.camera.clips.converters.PathToKeyframeConverter;
import mchorse.bbs_mod.camera.clips.misc.AudioClip;
import mchorse.bbs_mod.camera.clips.misc.CurveClip;
import mchorse.bbs_mod.camera.clips.misc.SubtitleClip;
import mchorse.bbs_mod.camera.clips.modifiers.AngleClip;
import mchorse.bbs_mod.camera.clips.modifiers.DollyZoomClip;
import mchorse.bbs_mod.camera.clips.modifiers.DragClip;
import mchorse.bbs_mod.camera.clips.modifiers.LookClip;
import mchorse.bbs_mod.camera.clips.modifiers.MathClip;
import mchorse.bbs_mod.camera.clips.modifiers.OrbitClip;
import mchorse.bbs_mod.camera.clips.modifiers.RemapperClip;
import mchorse.bbs_mod.camera.clips.modifiers.ShakeClip;
import mchorse.bbs_mod.camera.clips.modifiers.TrackerClip;
import mchorse.bbs_mod.camera.clips.modifiers.TranslateClip;
import mchorse.bbs_mod.camera.clips.overwrite.DollyClip;
import mchorse.bbs_mod.camera.clips.overwrite.IdleClip;
import mchorse.bbs_mod.camera.clips.overwrite.KeyframeClip;
import mchorse.bbs_mod.camera.clips.overwrite.PathClip;
import mchorse.bbs_mod.entity.ActorEntity;
import mchorse.bbs_mod.entity.GunProjectileEntity;
import mchorse.bbs_mod.film.FilmManager;
import mchorse.bbs_mod.forms.FormArchitect;
import mchorse.bbs_mod.forms.forms.AnchorForm;
import mchorse.bbs_mod.forms.forms.BillboardForm;
import mchorse.bbs_mod.forms.forms.BlockForm;
import mchorse.bbs_mod.forms.forms.ExtrudedForm;
import mchorse.bbs_mod.forms.forms.FramebufferForm;
import mchorse.bbs_mod.forms.forms.ItemForm;
import mchorse.bbs_mod.forms.forms.LabelForm;
import mchorse.bbs_mod.forms.forms.MobForm;
import mchorse.bbs_mod.forms.forms.ModelForm;
import mchorse.bbs_mod.forms.forms.ParticleForm;
import mchorse.bbs_mod.forms.forms.TrailForm;
import mchorse.bbs_mod.forms.forms.VanillaParticleForm;
import mchorse.bbs_mod.items.GunItem;
import mchorse.bbs_mod.morphing.Morph;
import mchorse.bbs_mod.network.ServerNetwork;
import mchorse.bbs_mod.resources.AssetProvider;
import mchorse.bbs_mod.resources.ISourcePack;
import mchorse.bbs_mod.resources.Link;
import mchorse.bbs_mod.resources.packs.DynamicSourcePack;
import mchorse.bbs_mod.resources.packs.ExternalAssetsSourcePack;
import mchorse.bbs_mod.resources.packs.InternalAssetsSourcePack;
import mchorse.bbs_mod.settings.Settings;
import mchorse.bbs_mod.settings.SettingsBuilder;
import mchorse.bbs_mod.settings.SettingsManager;
import mchorse.bbs_mod.ui.utils.icons.Icon;
import mchorse.bbs_mod.ui.utils.icons.Icons;
import mchorse.bbs_mod.utils.clips.Clip;
import mchorse.bbs_mod.utils.factory.MapFactory;
import mchorse.bbs_mod.utils.pose.Transform;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.gamerule.v1.GameRuleFactory;
import net.fabricmc.fabric.api.gamerule.v1.GameRuleRegistry;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.fabricmc.fabric.api.networking.v1.EntityTrackingEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.object.builder.v1.block.entity.FabricBlockEntityTypeBuilder;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1747;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_4970;
import net.minecraft.class_5132;
import net.minecraft.class_5218;
import net.minecraft.class_7923;
import net.minecraft.class_9279;
import net.minecraft.class_9334;

public class BBSMod
implements ModInitializer {
    public static final String MOD_ID = "bbs";
    private static ActionManager actions;
    private static File gameFolder;
    private static File assetsFolder;
    private static File settingsFolder;
    private static AssetProvider provider;
    private static DynamicSourcePack dynamicSourcePack;
    private static ExternalAssetsSourcePack originalSourcePack;
    private static SettingsManager settings;
    private static FormArchitect forms;
    private static FilmManager films;
    private static List<Runnable> runnables;
    private static MapFactory<Clip, ClipFactoryData> factoryCameraClips;
    private static MapFactory<Clip, ClipFactoryData> factoryActionClips;
    public static final class_1299<ActorEntity> ACTOR_ENTITY;
    public static final class_1299<GunProjectileEntity> GUN_PROJECTILE_ENTITY;
    public static final class_2248 MODEL_BLOCK;
    public static final class_2248 CHROMA_RED_BLOCK;
    public static final class_2248 CHROMA_GREEN_BLOCK;
    public static final class_2248 CHROMA_BLUE_BLOCK;
    public static final class_2248 CHROMA_CYAN_BLOCK;
    public static final class_2248 CHROMA_MAGENTA_BLOCK;
    public static final class_2248 CHROMA_YELLOW_BLOCK;
    public static final class_2248 CHROMA_BLACK_BLOCK;
    public static final class_2248 CHROMA_WHITE_BLOCK;
    public static final class_1747 MODEL_BLOCK_ITEM;
    public static final GunItem GUN_ITEM;
    public static final class_1747 CHROMA_RED_BLOCK_ITEM;
    public static final class_1747 CHROMA_GREEN_BLOCK_ITEM;
    public static final class_1747 CHROMA_BLUE_BLOCK_ITEM;
    public static final class_1747 CHROMA_CYAN_BLOCK_ITEM;
    public static final class_1747 CHROMA_MAGENTA_BLOCK_ITEM;
    public static final class_1747 CHROMA_YELLOW_BLOCK_ITEM;
    public static final class_1747 CHROMA_BLACK_BLOCK_ITEM;
    public static final class_1747 CHROMA_WHITE_BLOCK_ITEM;
    public static final class_1928.class_4313<class_1928.class_4310> BBS_EDITING_RULE;
    public static final class_2591<ModelBlockEntity> MODEL_BLOCK_ENTITY;
    public static final class_1761 ITEM_GROUP;
    public static final class_3414 CLICK;
    private static File worldFolder;

    private static class_3414 registerSound(String path) {
        class_2960 id = class_2960.method_60655((String)MOD_ID, (String)path);
        return (class_3414)class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)id, (Object)class_3414.method_47908((class_2960)id));
    }

    private static class_2248 createChromaBlock() {
        return new class_2248(class_4970.class_2251.method_9637().method_45477().method_42327().method_29292().method_9629(-1.0f, 3600000.0f));
    }

    private static class_1799 createModelBlockStack(Link texture) {
        class_1799 stack = new class_1799((class_1935)MODEL_BLOCK_ITEM);
        ModelBlockEntity entity = new ModelBlockEntity(class_2338.field_10980, MODEL_BLOCK.method_9564());
        BillboardForm form = new BillboardForm();
        ModelProperties properties = entity.getProperties();
        ((Transform)form.transform.get()).translate.set(0.0f, 0.5f, 0.0f);
        form.texture.set(texture);
        properties.setForm(form);
        properties.getTransformFirstPerson().translate.set(0.0f, 0.0f, -0.25f);
        class_2487 compound = entity.toNbtForItemStack();
        stack.method_57379(class_9334.field_49611, (Object)class_9279.method_57456((class_2487)compound));
        return stack;
    }

    public static File getGameFolder() {
        return gameFolder;
    }

    public static File getGamePath(String path) {
        return new File(gameFolder, path);
    }

    public static File getAssetsFolder() {
        ISourcePack sourcePack = BBSMod.getDynamicSourcePack().getSourcePack();
        if (sourcePack instanceof ExternalAssetsSourcePack) {
            ExternalAssetsSourcePack pack = (ExternalAssetsSourcePack)sourcePack;
            return pack.getFolder();
        }
        return assetsFolder;
    }

    public static File getAudioFolder() {
        return BBSMod.getAssetsPath("audio");
    }

    public static File getAssetsPath(String path) {
        return new File(BBSMod.getAssetsFolder(), path);
    }

    public static File getSettingsFolder() {
        return settingsFolder;
    }

    public static File getSettingsPath(String path) {
        return new File(settingsFolder, path);
    }

    public static File getExportFolder() {
        return BBSMod.getGamePath("export");
    }

    public static ActionManager getActions() {
        return actions;
    }

    public static AssetProvider getProvider() {
        return provider;
    }

    public static DynamicSourcePack getDynamicSourcePack() {
        return dynamicSourcePack;
    }

    public static ExternalAssetsSourcePack getOriginalSourcePack() {
        return originalSourcePack;
    }

    public static SettingsManager getSettings() {
        return settings;
    }

    public static FormArchitect getForms() {
        return forms;
    }

    public static FilmManager getFilms() {
        return films;
    }

    public static MapFactory<Clip, ClipFactoryData> getFactoryCameraClips() {
        return factoryCameraClips;
    }

    public static MapFactory<Clip, ClipFactoryData> getFactoryActionClips() {
        return factoryActionClips;
    }

    public void onInitialize() {
        gameFolder = FabricLoader.getInstance().getGameDir().toFile();
        assetsFolder = new File(gameFolder, "config/bbs/assets");
        settingsFolder = new File(gameFolder, "config/bbs/settings");
        assetsFolder.mkdirs();
        actions = new ActionManager();
        originalSourcePack = new ExternalAssetsSourcePack("assets", assetsFolder).providesFiles();
        dynamicSourcePack = new DynamicSourcePack(originalSourcePack);
        provider = new AssetProvider();
        provider.register(dynamicSourcePack);
        provider.register(new InternalAssetsSourcePack());
        settings = new SettingsManager();
        forms = new FormArchitect();
        forms.register(Link.bbs("billboard"), BillboardForm.class, null).register(Link.bbs("label"), LabelForm.class, null).register(Link.bbs("model"), ModelForm.class, null).register(Link.bbs("particle"), ParticleForm.class, null).register(Link.bbs("extruded"), ExtrudedForm.class, null).register(Link.bbs("block"), BlockForm.class, null).register(Link.bbs("item"), ItemForm.class, null).register(Link.bbs("anchor"), AnchorForm.class, null).register(Link.bbs("mob"), MobForm.class, null).register(Link.bbs("vanilla_particles"), VanillaParticleForm.class, null).register(Link.bbs("trail"), TrailForm.class, null).register(Link.bbs("framebuffer"), FramebufferForm.class, null);
        films = new FilmManager(() -> new File(worldFolder, "bbs/films"));
        factoryCameraClips = new MapFactory<IdleClip, ClipFactoryData>().register(Link.bbs("idle"), IdleClip.class, new ClipFactoryData(Icons.FRUSTUM, 1416804).withConverter(Link.bbs("dolly"), new IdleToDollyConverter()).withConverter(Link.bbs("path"), new IdleToPathConverter()).withConverter(Link.bbs("keyframe"), new IdleToKeyframeConverter())).register(Link.bbs("dolly"), DollyClip.class, new ClipFactoryData(Icons.CAMERA, 16753920).withConverter(Link.bbs("idle"), IdleConverter.CONVERTER).withConverter(Link.bbs("path"), new DollyToPathConverter()).withConverter(Link.bbs("keyframe"), new DollyToKeyframeConverter())).register(Link.bbs("path"), PathClip.class, new ClipFactoryData(Icons.GALLERY, 6824109).withConverter(Link.bbs("idle"), IdleConverter.CONVERTER).withConverter(Link.bbs("dolly"), new PathToDollyConverter()).withConverter(Link.bbs("keyframe"), new PathToKeyframeConverter())).register(Link.bbs("keyframe"), KeyframeClip.class, new ClipFactoryData(Icons.CURVES, 14560927).withConverter(Link.bbs("idle"), IdleConverter.CONVERTER)).register(Link.bbs("translate"), TranslateClip.class, new ClipFactoryData(Icons.UPLOAD, 4956222)).register(Link.bbs("angle"), AngleClip.class, new ClipFactoryData(Icons.ARC, 14121482)).register(Link.bbs("drag"), DragClip.class, new ClipFactoryData(Icons.FADING, 4960247)).register(Link.bbs("shake"), ShakeClip.class, new ClipFactoryData(Icons.EXCHANGE, 1416804)).register(Link.bbs("math"), MathClip.class, new ClipFactoryData(Icons.GRAPH, 6824109)).register(Link.bbs("look"), LookClip.class, new ClipFactoryData(Icons.VISIBLE, 1671167)).register(Link.bbs("orbit"), OrbitClip.class, new ClipFactoryData(Icons.GLOBE, 14164563)).register(Link.bbs("remapper"), RemapperClip.class, new ClipFactoryData(Icons.TIME, 0x222222)).register(Link.bbs("audio"), AudioClip.class, new ClipFactoryData(Icons.SOUND, 16762917)).register(Link.bbs("subtitle"), SubtitleClip.class, new ClipFactoryData(Icons.FONT, 0x888899)).register(Link.bbs("curve"), CurveClip.class, new ClipFactoryData(Icons.ARC, 16716947)).register(Link.bbs("tracker"), TrackerClip.class, new ClipFactoryData(Icons.USER, 0xFFFFFF)).register(Link.bbs("dolly_zoom"), DollyZoomClip.class, new ClipFactoryData(Icons.FILTER, 8214217));
        factoryActionClips = new MapFactory<ChatActionClip, ClipFactoryData>().register(Link.bbs("chat"), ChatActionClip.class, new ClipFactoryData(Icons.BUBBLE, 0xFFFF33)).register(Link.bbs("command"), CommandActionClip.class, new ClipFactoryData(Icons.PROPERTIES, 35071)).register(Link.bbs("place_block"), PlaceBlockActionClip.class, new ClipFactoryData(Icons.BLOCK, 0xFFBB00)).register(Link.bbs("interact_block"), InteractBlockActionClip.class, new ClipFactoryData(Icons.FULLSCREEN, 0xFF66FF)).register(Link.bbs("break_block"), BreakBlockActionClip.class, new ClipFactoryData(Icons.BULLET, 0x33FF33)).register(Link.bbs("use_item"), UseItemActionClip.class, new ClipFactoryData(Icons.POINTER, 0x3366FF)).register(Link.bbs("use_block_item"), UseBlockItemActionClip.class, new ClipFactoryData(Icons.BUCKET, 0x33FFFF)).register(Link.bbs("drop_item"), ItemDropActionClip.class, new ClipFactoryData(Icons.ARROW_DOWN, 16716947)).register(Link.bbs("attack"), AttackActionClip.class, new ClipFactoryData(Icons.DROP, 0xFF3333)).register(Link.bbs("damage"), DamageActionClip.class, new ClipFactoryData(Icons.SKULL, -11012822)).register(Link.bbs("swipe"), SwipeActionClip.class, new ClipFactoryData(Icons.LIMB, 0xFF8822));
        BBSMod.setupConfig(Icons.PROCESSOR, MOD_ID, new File(settingsFolder, "bbs.json"), BBSSettings::register);
        ServerNetwork.setup();
        CommandRegistrationCallback.EVENT.register(BBSCommands::register);
        this.registerEvents();
        FabricDefaultAttributeRegistry.register(ACTOR_ENTITY, (class_5132.class_5133)ActorEntity.createActorAttributes());
        class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)class_2960.method_60655((String)MOD_ID, (String)"model"), (Object)MODEL_BLOCK);
        class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)class_2960.method_60655((String)MOD_ID, (String)"chroma_red"), (Object)CHROMA_RED_BLOCK);
        class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)class_2960.method_60655((String)MOD_ID, (String)"chroma_green"), (Object)CHROMA_GREEN_BLOCK);
        class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)class_2960.method_60655((String)MOD_ID, (String)"chroma_blue"), (Object)CHROMA_BLUE_BLOCK);
        class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)class_2960.method_60655((String)MOD_ID, (String)"chroma_cyan"), (Object)CHROMA_CYAN_BLOCK);
        class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)class_2960.method_60655((String)MOD_ID, (String)"chroma_magenta"), (Object)CHROMA_MAGENTA_BLOCK);
        class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)class_2960.method_60655((String)MOD_ID, (String)"chroma_yellow"), (Object)CHROMA_YELLOW_BLOCK);
        class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)class_2960.method_60655((String)MOD_ID, (String)"chroma_black"), (Object)CHROMA_BLACK_BLOCK);
        class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)class_2960.method_60655((String)MOD_ID, (String)"chroma_white"), (Object)CHROMA_WHITE_BLOCK);
        class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)class_2960.method_60655((String)MOD_ID, (String)"model"), (Object)MODEL_BLOCK_ITEM);
        class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)class_2960.method_60655((String)MOD_ID, (String)"gun"), (Object)((Object)GUN_ITEM));
        class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)class_2960.method_60655((String)MOD_ID, (String)"chroma_red"), (Object)CHROMA_RED_BLOCK_ITEM);
        class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)class_2960.method_60655((String)MOD_ID, (String)"chroma_green"), (Object)CHROMA_GREEN_BLOCK_ITEM);
        class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)class_2960.method_60655((String)MOD_ID, (String)"chroma_blue"), (Object)CHROMA_BLUE_BLOCK_ITEM);
        class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)class_2960.method_60655((String)MOD_ID, (String)"chroma_cyan"), (Object)CHROMA_CYAN_BLOCK_ITEM);
        class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)class_2960.method_60655((String)MOD_ID, (String)"chroma_magenta"), (Object)CHROMA_MAGENTA_BLOCK_ITEM);
        class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)class_2960.method_60655((String)MOD_ID, (String)"chroma_yellow"), (Object)CHROMA_YELLOW_BLOCK_ITEM);
        class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)class_2960.method_60655((String)MOD_ID, (String)"chroma_black"), (Object)CHROMA_BLACK_BLOCK_ITEM);
        class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)class_2960.method_60655((String)MOD_ID, (String)"chroma_white"), (Object)CHROMA_WHITE_BLOCK_ITEM);
        class_2378.method_10230((class_2378)class_7923.field_44687, (class_2960)class_2960.method_60655((String)MOD_ID, (String)"main"), (Object)ITEM_GROUP);
    }

    private void registerEvents() {
        ServerEntityEvents.ENTITY_LOAD.register((entity, world) -> {
            if (entity instanceof class_3222) {
                class_3222 player = (class_3222)entity;
                Morph morph = Morph.getMorph((class_1297)player);
                ServerNetwork.sendMorphToTracked(player, morph.getForm());
            }
        });
        ServerLifecycleEvents.SERVER_STARTED.register(event -> {
            worldFolder = event.method_27050(class_5218.field_24188).toFile();
        });
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> ServerNetwork.sendHandshake(server, handler));
        ActionHandler.registerHandlers(actions);
        ServerTickEvents.START_SERVER_TICK.register(server -> actions.tick());
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            for (Runnable runnable : runnables) {
                runnable.run();
            }
            runnables.clear();
        });
        ServerLifecycleEvents.SERVER_STOPPED.register(server -> {
            actions.reset();
            ServerNetwork.reset();
        });
        EntityTrackingEvents.START_TRACKING.register((trackedEntity, player) -> runnables.add(() -> {
            if (trackedEntity instanceof class_3222) {
                class_3222 playerTwo = (class_3222)trackedEntity;
                Morph morph = Morph.getMorph(trackedEntity);
                if (morph != null) {
                    ServerNetwork.sendMorph(player, playerTwo.method_5628(), morph.getForm());
                }
            }
        }));
    }

    public static Settings setupConfig(Icon icon, String id, File destination, Consumer<SettingsBuilder> registerer) {
        SettingsBuilder builder = new SettingsBuilder(icon, id, destination);
        Settings settings = builder.getConfig();
        registerer.accept(builder);
        BBSMod.settings.modules.put(settings.getId(), settings);
        BBSMod.settings.load(settings, settings.file);
        return settings;
    }

    static {
        runnables = new ArrayList<Runnable>();
        ACTOR_ENTITY = (class_1299)class_2378.method_10230((class_2378)class_7923.field_41177, (class_2960)class_2960.method_60655((String)MOD_ID, (String)"actor"), (Object)class_1299.class_1300.method_5903(ActorEntity::new, (class_1311)class_1311.field_6294).method_17687(0.6f, 1.8f).method_27299(16).method_27300(1).build());
        GUN_PROJECTILE_ENTITY = (class_1299)class_2378.method_10230((class_2378)class_7923.field_41177, (class_2960)class_2960.method_60655((String)MOD_ID, (String)"gun_projectile"), (Object)class_1299.class_1300.method_5903(GunProjectileEntity::new, (class_1311)class_1311.field_6294).method_17687(0.25f, 0.25f).method_27299(24).method_27300(1).build());
        MODEL_BLOCK = new ModelBlock(class_4970.class_2251.method_9637().method_45477().method_42327().method_9634().method_22488().method_9632(0.0f));
        CHROMA_RED_BLOCK = BBSMod.createChromaBlock();
        CHROMA_GREEN_BLOCK = BBSMod.createChromaBlock();
        CHROMA_BLUE_BLOCK = BBSMod.createChromaBlock();
        CHROMA_CYAN_BLOCK = BBSMod.createChromaBlock();
        CHROMA_MAGENTA_BLOCK = BBSMod.createChromaBlock();
        CHROMA_YELLOW_BLOCK = BBSMod.createChromaBlock();
        CHROMA_BLACK_BLOCK = BBSMod.createChromaBlock();
        CHROMA_WHITE_BLOCK = BBSMod.createChromaBlock();
        MODEL_BLOCK_ITEM = new class_1747(MODEL_BLOCK, new class_1792.class_1793());
        GUN_ITEM = new GunItem(new class_1792.class_1793().method_7889(1));
        CHROMA_RED_BLOCK_ITEM = new class_1747(CHROMA_RED_BLOCK, new class_1792.class_1793());
        CHROMA_GREEN_BLOCK_ITEM = new class_1747(CHROMA_GREEN_BLOCK, new class_1792.class_1793());
        CHROMA_BLUE_BLOCK_ITEM = new class_1747(CHROMA_BLUE_BLOCK, new class_1792.class_1793());
        CHROMA_CYAN_BLOCK_ITEM = new class_1747(CHROMA_CYAN_BLOCK, new class_1792.class_1793());
        CHROMA_MAGENTA_BLOCK_ITEM = new class_1747(CHROMA_MAGENTA_BLOCK, new class_1792.class_1793());
        CHROMA_YELLOW_BLOCK_ITEM = new class_1747(CHROMA_YELLOW_BLOCK, new class_1792.class_1793());
        CHROMA_BLACK_BLOCK_ITEM = new class_1747(CHROMA_BLACK_BLOCK, new class_1792.class_1793());
        CHROMA_WHITE_BLOCK_ITEM = new class_1747(CHROMA_WHITE_BLOCK, new class_1792.class_1793());
        BBS_EDITING_RULE = GameRuleRegistry.register((String)"bbsEditing", (class_1928.class_5198)class_1928.class_5198.field_24100, (class_1928.class_4314)GameRuleFactory.createBooleanRule((boolean)true));
        MODEL_BLOCK_ENTITY = (class_2591)class_2378.method_10230((class_2378)class_7923.field_41181, (class_2960)class_2960.method_60655((String)MOD_ID, (String)"model_block_entity"), (Object)FabricBlockEntityTypeBuilder.create(ModelBlockEntity::new, (class_2248[])new class_2248[]{MODEL_BLOCK}).build());
        ITEM_GROUP = FabricItemGroup.builder().method_47320(() -> BBSMod.createModelBlockStack(Link.assets("textures/icon.png"))).method_47321((class_2561)class_2561.method_43471((String)"itemGroup.bbs.main")).method_47317((context, entries) -> {
            entries.method_45420(BBSMod.createModelBlockStack(Link.assets("textures/model_block.png")));
            entries.method_45421((class_1935)CHROMA_RED_BLOCK_ITEM);
            entries.method_45421((class_1935)CHROMA_GREEN_BLOCK_ITEM);
            entries.method_45421((class_1935)CHROMA_BLUE_BLOCK_ITEM);
            entries.method_45421((class_1935)CHROMA_CYAN_BLOCK_ITEM);
            entries.method_45421((class_1935)CHROMA_MAGENTA_BLOCK_ITEM);
            entries.method_45421((class_1935)CHROMA_YELLOW_BLOCK_ITEM);
            entries.method_45421((class_1935)CHROMA_BLACK_BLOCK_ITEM);
            entries.method_45421((class_1935)CHROMA_WHITE_BLOCK_ITEM);
            entries.method_45420(new class_1799((class_1935)GUN_ITEM));
        }).method_47324();
        CLICK = BBSMod.registerSound("click");
    }
}

