/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.client.renderer.item;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import mchorse.bbs_mod.BBSMod;
import mchorse.bbs_mod.blocks.entities.ModelBlockEntity;
import mchorse.bbs_mod.blocks.entities.ModelProperties;
import mchorse.bbs_mod.forms.FormUtilsClient;
import mchorse.bbs_mod.forms.entities.IEntity;
import mchorse.bbs_mod.forms.entities.StubEntity;
import mchorse.bbs_mod.forms.forms.Form;
import mchorse.bbs_mod.forms.renderers.FormRenderType;
import mchorse.bbs_mod.forms.renderers.FormRenderingContext;
import mchorse.bbs_mod.utils.MatrixStackUtils;
import mchorse.bbs_mod.utils.pose.Transform;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.BuiltinItemRendererRegistry;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_7225;
import net.minecraft.class_811;
import net.minecraft.class_9279;
import net.minecraft.class_9334;

@Environment(value=EnvType.CLIENT)
public class ModelBlockItemRenderer
implements BuiltinItemRendererRegistry.DynamicItemRenderer {
    private Map<class_1799, Item> map = new HashMap<class_1799, Item>();

    public void update() {
        Iterator<Item> it = this.map.values().iterator();
        while (it.hasNext()) {
            Item item = it.next();
            if (item.expiration <= 0) {
                it.remove();
            }
            --item.expiration;
            item.entity.getProperties().update(item.formEntity);
        }
    }

    public void render(class_1799 stack, class_811 mode, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        ModelProperties properties;
        Form form;
        Item item = this.get(stack);
        if (item != null && (form = (properties = item.entity.getProperties()).getForm(mode)) != null) {
            item.expiration = 20;
            Transform transform = properties.getTransform(mode);
            matrices.method_22903();
            matrices.method_46416(0.5f, 0.0f, 0.5f);
            if (mode == class_811.field_4317) {
                matrices.method_22905(0.4f, 0.4f, 0.4f);
                matrices.method_46416(0.0f, 0.5f, 0.0f);
            }
            MatrixStackUtils.applyTransform(matrices, transform);
            RenderSystem.enableDepthTest();
            FormUtilsClient.render(form, new FormRenderingContext().set(FormRenderType.fromModelMode(mode), item.formEntity, matrices, light, overlay, class_310.method_1551().method_60646().method_60637(false)).camera(class_310.method_1551().field_1773.method_19418()));
            RenderSystem.disableDepthTest();
            matrices.method_22909();
        }
    }

    public Item get(class_1799 stack) {
        if (stack == null || stack.method_7909() != BBSMod.MODEL_BLOCK_ITEM) {
            return null;
        }
        if (this.map.containsKey(stack)) {
            return this.map.get(stack);
        }
        class_9279 blockEntityData = (class_9279)stack.method_57824(class_9334.field_49611);
        ModelBlockEntity entity = new ModelBlockEntity(class_2338.field_10980, BBSMod.MODEL_BLOCK.method_9564());
        Item item = new Item(entity);
        this.map.put(stack, item);
        if (blockEntityData == null) {
            return item;
        }
        blockEntityData.method_57449((class_2586)entity, (class_7225.class_7874)class_310.method_1551().field_1687.method_30349());
        return item;
    }

    @Environment(value=EnvType.CLIENT)
    public static class Item {
        public ModelBlockEntity entity;
        public IEntity formEntity;
        public int expiration = 20;

        public Item(ModelBlockEntity entity) {
            this.entity = entity;
            this.formEntity = new StubEntity((class_1937)class_310.method_1551().field_1687);
        }
    }
}

