/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.film;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mchorse.bbs_mod.BBSModClient;
import mchorse.bbs_mod.BBSSettings;
import mchorse.bbs_mod.audio.AudioRenderer;
import mchorse.bbs_mod.camera.clips.misc.AudioClip;
import mchorse.bbs_mod.camera.controller.ICameraController;
import mchorse.bbs_mod.camera.controller.PlayCameraController;
import mchorse.bbs_mod.camera.controller.RunnerCameraController;
import mchorse.bbs_mod.camera.utils.TimeUtils;
import mchorse.bbs_mod.film.BaseFilmController;
import mchorse.bbs_mod.film.Film;
import mchorse.bbs_mod.film.FirstPersonFilmController;
import mchorse.bbs_mod.film.Recorder;
import mchorse.bbs_mod.film.replays.Replay;
import mchorse.bbs_mod.forms.forms.Form;
import mchorse.bbs_mod.morphing.Morph;
import mchorse.bbs_mod.network.ClientNetwork;
import mchorse.bbs_mod.ui.ContentType;
import mchorse.bbs_mod.ui.UIKeys;
import mchorse.bbs_mod.ui.framework.elements.utils.Batcher2D;
import mchorse.bbs_mod.ui.utils.icons.Icons;
import mchorse.bbs_mod.utils.CollectionUtils;
import mchorse.bbs_mod.utils.clips.Clip;
import mchorse.bbs_mod.utils.keyframes.KeyframeChannel;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_1297;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public class Films {
    private List<BaseFilmController> controllers = new ArrayList<BaseFilmController>();
    private Recorder recorder;
    public Map<String, Map<String, Integer>> actors = new HashMap<String, Map<String, Integer>>();

    public static void playFilm(String filmId, boolean withCamera) {
        if (ClientNetwork.isIsBBSModOnServer()) {
            ClientNetwork.sendToggleFilm(filmId, withCamera);
        } else if (BBSModClient.getFilms().has(filmId)) {
            Films.stopFilm(filmId);
        } else {
            ContentType.FILMS.getRepository().load(filmId, data -> class_310.method_1551().execute(() -> Films.playFilm((Film)data, withCamera)));
        }
    }

    public static void playFilm(Film film, boolean withCamera) {
        FirstPersonFilmController filmController = new FirstPersonFilmController(film);
        if (withCamera && !film.hasFirstPerson()) {
            PlayCameraController controller = new PlayCameraController(film.camera);
            controller.getContext().entities.putAll(filmController.getEntities());
            BBSModClient.getCameraController().add(controller);
        }
        BBSModClient.getFilms().add(filmController);
    }

    public static void pauseFilm(String filmId) {
        if (ClientNetwork.isIsBBSModOnServer()) {
            ClientNetwork.sendPauseFilm(filmId);
        } else if (BBSModClient.getFilms().has(filmId)) {
            Films.togglePauseFilm(filmId);
        }
    }

    public static void togglePauseFilm(String filmId) {
        BaseFilmController controller = BBSModClient.getFilms().getController(filmId);
        if (controller != null) {
            controller.togglePause();
        }
    }

    public static void stopFilm(String filmId) {
        Film film = BBSModClient.getFilms().remove(filmId);
        ICameraController current = BBSModClient.getCameraController().getCurrent();
        if (film != null && current instanceof PlayCameraController) {
            ICameraController iCameraController;
            PlayCameraController play = (PlayCameraController)current;
            if (play.getContext().clips == film.camera && (iCameraController = BBSModClient.getCameraController().remove(play)) instanceof RunnerCameraController) {
                RunnerCameraController controller = (RunnerCameraController)iCameraController;
                controller.getContext().shutdown();
            }
        }
    }

    public BaseFilmController getController(String filmId) {
        for (BaseFilmController controller : this.controllers) {
            if (!controller.film.getId().equals(filmId)) continue;
            return controller;
        }
        return null;
    }

    public Recorder getRecorder() {
        return this.recorder;
    }

    public void startRecording(Film film, int replayId, int tick) {
        Replay replay;
        Morph morph = Morph.getMorph((class_1297)class_310.method_1551().field_1724);
        this.recorder = new Recorder(film, morph == null ? null : morph.getForm(), replayId, tick);
        if (ClientNetwork.isIsBBSModOnServer()) {
            ClientNetwork.sendActionRecording(film.getId(), replayId, this.recorder.getTick(), this.recorder.countdown, true);
        }
        if ((replay = (Replay)CollectionUtils.getSafe(film.replays.getList(), replayId)) != null) {
            ClientNetwork.sendPlayerForm((Form)replay.form.get());
        }
    }

    public Recorder stopRecording() {
        Recorder recorder = this.recorder;
        this.recorder = null;
        if (recorder != null) {
            for (KeyframeChannel<?> channel : recorder.keyframes.getChannels()) {
                channel.simplify();
            }
            if (ClientNetwork.isIsBBSModOnServer()) {
                ClientNetwork.sendActionRecording(recorder.film.getId(), recorder.exception, recorder.initialTick, 0, false);
            }
            recorder.shutdown();
        }
        return recorder;
    }

    public void add(BaseFilmController controller) {
        this.controllers.add(controller);
    }

    public boolean has(String filmId) {
        for (BaseFilmController controller : this.controllers) {
            if (!controller.film.getId().equals(filmId)) continue;
            return true;
        }
        return false;
    }

    public Film remove(String id) {
        Iterator<BaseFilmController> it = this.controllers.iterator();
        while (it.hasNext()) {
            BaseFilmController next = it.next();
            if (!next.film.getId().equals(id)) continue;
            next.shutdown();
            it.remove();
            return next.film;
        }
        return null;
    }

    public void updateActors(String filmId, Map<String, Integer> actors) {
        this.actors.put(filmId, actors);
    }

    public void startRenderFrame(float transition) {
        if (this.recorder != null) {
            this.recorder.startRenderFrame(transition);
        }
        for (BaseFilmController controller : this.controllers) {
            controller.startRenderFrame(transition);
        }
    }

    public void update() {
        this.controllers.removeIf(film -> {
            film.update();
            if (film.hasFinished()) {
                film.shutdown();
            }
            return film.hasFinished();
        });
        if (this.recorder != null) {
            this.recorder.update();
        }
    }

    public void updateEndWorld() {
        for (BaseFilmController controller : this.controllers) {
            controller.updateEndWorld();
        }
    }

    public void render(WorldRenderContext context) {
        RenderSystem.enableDepthTest();
        for (BaseFilmController controller : this.controllers) {
            controller.render(context);
        }
        if (this.recorder != null) {
            this.recorder.render(context);
        }
        RenderSystem.disableDepthTest();
    }

    public void renderHud(Batcher2D batcher2D, float tickDelta) {
        Recorder recorder = BBSModClient.getFilms().getRecorder();
        if (recorder != null && ((Boolean)BBSSettings.recordingOverlays.get()).booleanValue()) {
            String label = recorder.hasNotStarted() ? String.valueOf(TimeUtils.toSeconds(recorder.countdown)) : UIKeys.FILM_RECORDING.format(recorder.getTick()).get();
            int x = 5;
            int y = 5;
            int w = batcher2D.getFont().getWidth(label);
            batcher2D.box(x, y, x + 18 + w + 3, y + 16, -2013265920);
            batcher2D.icon(Icons.SPHERE, -52429, x, y);
            batcher2D.textShadow(label, x + 18, y + 4);
            ArrayList<AudioClip> audioClips = new ArrayList<AudioClip>();
            for (Clip clip : recorder.film.camera.get()) {
                if (!(clip instanceof AudioClip)) continue;
                audioClips.add((AudioClip)clip);
            }
            int sw = class_310.method_1551().method_22683().method_4486();
            int sh = class_310.method_1551().method_22683().method_4502();
            w = (int)((float)sw * ((Float)BBSSettings.audioWaveformWidth.get()).floatValue());
            x = sw / 2 - w / 2;
            y = sh / 2 + 100;
            AudioRenderer.renderAll(batcher2D, audioClips, (float)recorder.getTick() + tickDelta, x, y, w, (Integer)BBSSettings.audioWaveformHeight.get(), sw, sh);
        }
    }

    public void reset() {
        this.controllers.clear();
        this.recorder = null;
    }
}

