/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.film;

import com.mojang.blaze3d.systems.RenderSystem;
import mchorse.bbs_mod.BBSSettings;
import mchorse.bbs_mod.camera.data.Position;
import mchorse.bbs_mod.camera.utils.TimeUtils;
import mchorse.bbs_mod.client.BBSRendering;
import mchorse.bbs_mod.film.Film;
import mchorse.bbs_mod.film.WorldFilmController;
import mchorse.bbs_mod.film.replays.FormProperties;
import mchorse.bbs_mod.film.replays.Inventory;
import mchorse.bbs_mod.film.replays.ReplayKeyframes;
import mchorse.bbs_mod.forms.FormUtils;
import mchorse.bbs_mod.forms.forms.Form;
import mchorse.bbs_mod.graphics.Draw;
import mchorse.bbs_mod.morphing.Morph;
import mchorse.bbs_mod.network.ClientNetwork;
import mchorse.bbs_mod.utils.MathUtils;
import mchorse.bbs_mod.utils.PlayerUtils;
import mchorse.bbs_mod.utils.joml.Matrices;
import mchorse.bbs_mod.utils.joml.Vectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_746;
import net.minecraft.class_757;
import net.minecraft.class_9801;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3d;
import org.joml.Vector4f;

@Environment(value=EnvType.CLIENT)
public class Recorder
extends WorldFilmController {
    public ReplayKeyframes keyframes = new ReplayKeyframes("keyframes");
    public FormProperties properties = new FormProperties("properties");
    public Inventory inventory = new Inventory("inventory");
    public float hp;
    public float hunger;
    public int xpLevel;
    public float xpProgress;
    private static Matrix4f perspective = new Matrix4f();
    public Form lastForm;
    public Vector3d lastPosition;
    public Vector4f lastRotation;
    public int countdown;
    public final int initialTick;

    public static void renderCameraPreview(Position position, class_4184 camera, class_4587 stack) {
        if (!((Boolean)BBSSettings.recordingOverlays.get()).booleanValue()) {
            return;
        }
        Vector4f vector = Vectors.TEMP_4F;
        Matrix4f matrix = Matrices.TEMP_4F;
        float x = (float)(position.point.x - camera.method_19326().field_1352);
        float y = (float)(position.point.y - camera.method_19326().field_1351);
        float z = (float)(position.point.z - camera.method_19326().field_1350);
        float fov = MathUtils.toRad(position.angle.fov);
        float aspect = (float)BBSRendering.getVideoWidth() / (float)BBSRendering.getVideoHeight();
        float thickness = 0.025f;
        perspective.identity().perspective(fov, aspect, 0.001f, 100.0f).invert();
        matrix.identity().rotateY(MathUtils.toRad(position.angle.yaw + 180.0f)).rotateX(MathUtils.toRad(-position.angle.pitch));
        RenderSystem.setShader(class_757::method_34540);
        class_287 builder = class_289.method_1348().method_60827(class_293.class_5596.field_27379, class_290.field_1576);
        Recorder.transformFrustum(vector, matrix, 1.0f, 1.0f);
        Draw.fillBoxTo(builder, stack, x, y, z, x + vector.x, y + vector.y, z + vector.z, thickness, 1.0f, 1.0f, 1.0f, 1.0f);
        Recorder.transformFrustum(vector, matrix, -1.0f, 1.0f);
        Draw.fillBoxTo(builder, stack, x, y, z, x + vector.x, y + vector.y, z + vector.z, thickness, 1.0f, 1.0f, 1.0f, 1.0f);
        Recorder.transformFrustum(vector, matrix, 1.0f, -1.0f);
        Draw.fillBoxTo(builder, stack, x, y, z, x + vector.x, y + vector.y, z + vector.z, thickness, 1.0f, 1.0f, 1.0f, 1.0f);
        Recorder.transformFrustum(vector, matrix, -1.0f, -1.0f);
        Draw.fillBoxTo(builder, stack, x, y, z, x + vector.x, y + vector.y, z + vector.z, thickness, 1.0f, 1.0f, 1.0f, 1.0f);
        Recorder.transformFrustum(vector, matrix, 0.0f, 0.0f);
        Draw.fillBoxTo(builder, stack, x, y, z, x + vector.x, y + vector.y, z + vector.z, thickness, 0.0f, 0.5f, 1.0f, 1.0f);
        class_286.method_43433((class_9801)builder.method_60800());
        RenderSystem.disableDepthTest();
    }

    private static void transformFrustum(Vector4f vector, Matrix4f matrix, float x, float y) {
        vector.set(x, y, 0.0f, 1.0f);
        vector.mul((Matrix4fc)perspective);
        vector.w = 1.0f;
        vector.normalize().mul(100.0f);
        vector.w = 1.0f;
        vector.mul((Matrix4fc)matrix);
    }

    public Recorder(Film film, Form form, int replayId, int tick) {
        super(film);
        this.lastForm = FormUtils.copy(form);
        this.exception = replayId;
        this.tick = tick;
        this.countdown = TimeUtils.toTick(((Float)BBSSettings.recordingCountdown.get()).floatValue());
        this.initialTick = tick;
    }

    public boolean hasNotStarted() {
        return this.countdown > 0;
    }

    @Override
    public void update() {
        if (this.hasNotStarted()) {
            --this.countdown;
            return;
        }
        class_746 player = class_310.method_1551().field_1724;
        if (this.lastPosition == null) {
            this.lastPosition = new Vector3d(player.method_23317(), player.method_23318(), player.method_23321());
            this.lastRotation = new Vector4f(player.method_36454(), player.method_36455(), player.method_5791(), player.method_43078());
            this.inventory.fromPlayer((class_1657)player);
            this.hp = player.method_6032();
            this.hunger = player.method_7344().method_7589();
            this.xpLevel = player.field_7520;
            this.xpProgress = player.field_7510;
        }
        if (this.tick >= 0) {
            Morph morph = Morph.getMorph((class_1297)player);
            this.keyframes.record(this.tick, morph.entity, null);
        }
        super.update();
    }

    @Override
    public void render(WorldRenderContext context) {
        super.render(context);
        Recorder.renderCameraPreview(this.position, context.camera(), context.matrixStack());
    }

    @Override
    public void shutdown() {
        Vector3d pos = this.lastPosition;
        if (pos != null) {
            Vector4f rot = this.lastRotation;
            PlayerUtils.teleport(pos.x, pos.y, pos.z, rot.z, rot.y);
            ClientNetwork.sendPlayerForm(this.lastForm);
        }
        super.shutdown();
    }
}

