/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.forms.forms;

import mchorse.bbs_mod.data.types.BaseType;
import mchorse.bbs_mod.data.types.MapType;
import mchorse.bbs_mod.forms.FormUtils;
import mchorse.bbs_mod.forms.entities.IEntity;
import mchorse.bbs_mod.forms.entities.StubEntity;
import mchorse.bbs_mod.forms.forms.BodyPartManager;
import mchorse.bbs_mod.forms.forms.Form;
import mchorse.bbs_mod.settings.values.base.BaseValue;
import mchorse.bbs_mod.settings.values.core.ValueGroup;
import mchorse.bbs_mod.settings.values.core.ValueString;
import mchorse.bbs_mod.settings.values.core.ValueTransform;
import mchorse.bbs_mod.settings.values.numeric.ValueBoolean;
import mchorse.bbs_mod.utils.pose.Transform;

public class BodyPart
extends ValueGroup {
    private Form form;
    public final ValueTransform transform = new ValueTransform("transform", new Transform());
    public final ValueString bone = new ValueString("bone", "");
    public final ValueBoolean useTarget = new ValueBoolean("useTarget", false);
    private IEntity entity = new StubEntity();

    public BodyPart(String id) {
        super(id);
        this.add(this.transform);
        this.add(this.bone);
        this.add(this.useTarget);
    }

    public Form getForm() {
        return this.form;
    }

    public IEntity getEntity() {
        return this.entity;
    }

    public BodyPartManager getManager() {
        BodyPartManager parts;
        BaseValue baseValue = this.parent;
        return baseValue instanceof BodyPartManager ? (parts = (BodyPartManager)baseValue) : null;
    }

    public void setForm(Form form) {
        this.preNotify();
        this.setInternalForm(form);
        this.postNotify();
    }

    private void setInternalForm(Form form) {
        if (this.form != null) {
            this.remove(this.form);
        }
        this.form = form;
        if (this.form != null) {
            form.setId("form");
            this.add(this.form);
        }
    }

    public void update(IEntity target) {
        if (this.form != null) {
            this.form.update((Boolean)this.useTarget.get() != false ? target : this.entity);
        }
        this.entity.update();
    }

    public BodyPart copy() {
        BodyPart part = new BodyPart(this.id);
        part.fromData(this.toData());
        return part;
    }

    @Override
    public void fromData(BaseType data) {
        super.fromData(data);
        if (data.isMap()) {
            MapType map = data.asMap();
            Form form = map.has("form") ? FormUtils.fromData(map.getMap("form")) : null;
            this.setInternalForm(form);
        }
    }
}

