/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.forms.renderers;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.brigadier.StringReader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import mchorse.bbs_mod.BBSModClient;
import mchorse.bbs_mod.client.BBSShaders;
import mchorse.bbs_mod.forms.CustomVertexConsumerProvider;
import mchorse.bbs_mod.forms.FormUtilsClient;
import mchorse.bbs_mod.forms.ITickable;
import mchorse.bbs_mod.forms.entities.IEntity;
import mchorse.bbs_mod.forms.forms.MobForm;
import mchorse.bbs_mod.forms.renderers.FormRenderer;
import mchorse.bbs_mod.forms.renderers.FormRenderingContext;
import mchorse.bbs_mod.forms.renderers.ModelFormRenderer;
import mchorse.bbs_mod.mixin.LimbAnimatorAccessor;
import mchorse.bbs_mod.resources.Link;
import mchorse.bbs_mod.ui.framework.UIContext;
import mchorse.bbs_mod.utils.MatrixStackUtils;
import mchorse.bbs_mod.utils.PlayerUtils;
import mchorse.bbs_mod.utils.joml.Vectors;
import mchorse.bbs_mod.utils.pose.Pose;
import mchorse.bbs_mod.utils.pose.Transform;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4050;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_583;
import net.minecraft.class_630;
import net.minecraft.class_745;
import net.minecraft.class_7833;
import net.minecraft.class_7923;
import net.minecraft.class_8080;
import net.minecraft.class_897;
import net.minecraft.class_922;
import org.joml.Matrix4f;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class MobFormRenderer
extends FormRenderer<MobForm>
implements ITickable {
    private static final Map<Class, Map<String, class_630>> parts = new HashMap<Class, Map<String, class_630>>();
    private static final Map<class_630, Transform> cache = new HashMap<class_630, Transform>();
    private static Pose currentPose;
    private static Pose currentPoseOverlay;
    public static final GameProfile WIDE;
    public static final GameProfile SLIM;
    private class_1297 entity;
    private String lastId = "";
    private String lastNBT = "";
    private boolean lastSlim;
    public float prevHandSwing;
    private float prevYawHead;
    private float prevPitch;

    public static Pose getCurrentPose() {
        return currentPose;
    }

    public static Pose getCurrentPoseOverlay() {
        return currentPoseOverlay;
    }

    public static Map<Class, Map<String, class_630>> getParts() {
        return parts;
    }

    public static Map<class_630, Transform> getCache() {
        return cache;
    }

    public MobFormRenderer(MobForm form) {
        super(form);
    }

    @Override
    public List<String> getBones() {
        this.ensureEntity();
        if (this.entity != null) {
            Map<String, class_630> stringModelPartMap = parts.get(this.entity.getClass());
            if (stringModelPartMap == null) {
                stringModelPartMap = new HashMap<String, class_630>();
                class_897 class_8972 = class_310.method_1551().method_1561().method_3953(this.entity);
                if (class_8972 instanceof class_922) {
                    class_922 renderer = (class_922)class_8972;
                    class_583 model = renderer.method_4038();
                    HashSet<Object> fields = new HashSet<Object>();
                    for (Class<?> aClass = model.getClass(); aClass != Object.class; aClass = aClass.getSuperclass()) {
                        for (Field field : aClass.getDeclaredFields()) {
                            fields.add(field);
                        }
                    }
                    for (Field field : fields) {
                        if (!field.getType().equals(class_630.class)) continue;
                        try {
                            field.setAccessible(true);
                            class_630 part = (class_630)field.get(model);
                            stringModelPartMap.put(field.getName(), part);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                parts.put(this.entity.getClass(), stringModelPartMap);
            }
            return new ArrayList<String>(stringModelPartMap.keySet());
        }
        return super.getBones();
    }

    private void bindTexture() {
        Link link = (Link)((MobForm)this.form).texture.get();
        if (link != null) {
            BBSModClient.getTextures().bindTexture(link);
        }
    }

    private void ensureEntity() {
        String id = (String)((MobForm)this.form).mobID.get();
        String nbt = (String)((MobForm)this.form).mobNBT.get();
        boolean slim = (Boolean)((MobForm)this.form).slim.get();
        if (!this.lastId.equals(id) || !this.lastNBT.equals(nbt) || slim != this.lastSlim) {
            this.lastId = id;
            this.lastNBT = nbt;
            this.lastSlim = slim;
            this.entity = null;
        }
        if (this.entity != null) {
            return;
        }
        class_2487 compound = new class_2487();
        try {
            compound = new class_2522(new StringReader(nbt)).method_10727();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.entity = ((class_1299)class_7923.field_41177.method_10223(class_2960.method_12829((String)id))).method_5883((class_1937)class_310.method_1551().field_1687);
        if (this.entity == null && ((MobForm)this.form).isPlayer()) {
            this.entity = new class_745(class_310.method_1551().field_1687, slim ? SLIM : WIDE);
            this.entity.method_5841().method_12778(PlayerUtils.ProtectedAccess.getModelParts(), (Object)127);
        }
        if (this.entity != null) {
            compound.method_10582("id", id);
            this.entity.method_5651(compound);
            this.entity.field_5960 = true;
        }
    }

    @Override
    protected void renderInUI(UIContext context, int x1, int y1, int x2, int y2) {
        this.ensureEntity();
        if (this.entity != null) {
            class_4587 stack = context.batcher.getContext().method_51448();
            stack.method_22903();
            Matrix4f uiMatrix = ModelFormRenderer.getUIMatrix(context, x1, y1, x2, y2);
            CustomVertexConsumerProvider consumers = FormUtilsClient.getProvider();
            float scale = ((Float)((MobForm)this.form).uiScale.get()).floatValue();
            float width = this.entity.method_17681();
            float height = this.entity.method_17682();
            this.applyTransforms(uiMatrix, context.getTransition());
            MatrixStackUtils.multiply(stack, uiMatrix);
            stack.method_22905(scale *= Math.min(1.8f / Math.max(width, height), 1.0f), scale, scale);
            if (!((String)((MobForm)this.form).mobID.get()).equals("minecraft:ender_dragon")) {
                stack.method_22907(class_7833.field_40716.rotation((float)Math.PI));
            }
            stack.method_23760().method_23762().getScale(Vectors.EMPTY_3F);
            stack.method_23760().method_23762().scale(1.0f / Vectors.EMPTY_3F.x, -1.0f / Vectors.EMPTY_3F.y, 1.0f / Vectors.EMPTY_3F.z);
            RenderSystem.setupLevelDiffuseLighting((Vector3f)new Vector3f(0.0f, 0.85f, -1.0f).normalize(), (Vector3f)new Vector3f(0.0f, 0.85f, 1.0f).normalize());
            BooleanHolder first = new BooleanHolder();
            CustomVertexConsumerProvider.hijackVertexFormat(layer -> {
                if (!first.bool) {
                    this.bindTexture();
                    first.bool = true;
                }
            });
            consumers.setUI(true);
            class_310.method_1551().method_1561().method_3954(this.entity, 0.0, 0.0, 0.0, 0.0f, context.getTransition(), stack, (class_4597)consumers, 240);
            consumers.method_22993();
            consumers.setUI(false);
            CustomVertexConsumerProvider.clearRunnables();
            stack.method_22909();
            RenderSystem.depthFunc((int)519);
        }
    }

    @Override
    protected void render3D(FormRenderingContext context) {
        this.ensureEntity();
        if (this.entity != null) {
            class_1297 class_12972;
            CustomVertexConsumerProvider consumers = FormUtilsClient.getProvider();
            int light = context.light;
            BooleanHolder first = new BooleanHolder();
            if (context.isPicking()) {
                CustomVertexConsumerProvider.hijackVertexFormat(layer -> {
                    if (!first.bool) {
                        this.bindTexture();
                        this.setupTarget(context, BBSShaders.getPickerModelsProgram());
                        RenderSystem.setShader(BBSShaders::getPickerModelsProgram);
                        first.bool = true;
                    }
                });
                light = 0;
            } else {
                CustomVertexConsumerProvider.hijackVertexFormat(layer -> {
                    if (!first.bool) {
                        this.bindTexture();
                        first.bool = true;
                    }
                });
            }
            context.stack.method_22903();
            if (((String)((MobForm)this.form).mobID.get()).equals("minecraft:ender_dragon")) {
                context.stack.method_22907(class_7833.field_40716.rotation((float)Math.PI));
            }
            if ((class_12972 = this.entity) instanceof class_1309) {
                class_1309 entity = (class_1309)class_12972;
                int u = context.overlay & 0xFFFF;
                int v = context.overlay >> 16 & 0xFFFF;
                entity.field_6235 = v != 10 ? 100 : 0;
            }
            currentPose = (Pose)((MobForm)this.form).pose.get();
            currentPoseOverlay = (Pose)((MobForm)this.form).poseOverlay.get();
            class_310.method_1551().method_1561().method_3954(this.entity, 0.0, 0.0, 0.0, 0.0f, context.getTransition(), context.stack, (class_4597)consumers, light);
            currentPoseOverlay = null;
            currentPose = null;
            consumers.method_22993();
            CustomVertexConsumerProvider.clearRunnables();
            context.stack.method_22909();
            RenderSystem.enableDepthTest();
        }
    }

    @Override
    public void tick(IEntity entity) {
        this.ensureEntity();
        if (this.entity != null) {
            this.entity.method_5773();
            this.entity.field_6004 = this.prevPitch;
            this.entity.field_5982 = 0.0f;
            class_1297 class_12972 = this.entity;
            if (class_12972 instanceof class_1309) {
                float handSwingProgress;
                class_1309 livingEntity = (class_1309)class_12972;
                livingEntity.field_6259 = this.prevYawHead;
                livingEntity.field_6220 = 0.0f;
                class_8080 class_80802 = livingEntity.field_42108;
                if (class_80802 instanceof LimbAnimatorAccessor) {
                    LimbAnimatorAccessor a = (LimbAnimatorAccessor)class_80802;
                    class_80802 = entity.getLimbAnimator();
                    if (class_80802 instanceof LimbAnimatorAccessor) {
                        LimbAnimatorAccessor b = (LimbAnimatorAccessor)class_80802;
                        a.setPrevSpeed(b.getPrevSpeed());
                        a.setSpeed(b.getSpeed());
                        a.setPos(b.getPos());
                    }
                }
                if ((handSwingProgress = entity.getHandSwingProgress(0.0f)) < this.prevHandSwing) {
                    this.prevHandSwing = 0.0f;
                }
                if (handSwingProgress > 0.0f && this.prevHandSwing == 0.0f) {
                    livingEntity.method_6104(class_1268.field_5808);
                }
                this.prevHandSwing = handSwingProgress;
            }
            this.entity.method_36456(0.0f);
            this.entity.method_5847(entity.getHeadYaw() - entity.getBodyYaw());
            this.entity.method_36457(entity.getPitch());
            this.entity.method_5636(0.0f);
            this.entity.method_23327(entity.getX(), entity.getY(), entity.getZ());
            this.entity.method_24830(entity.isOnGround());
            this.entity.method_5660(entity.isSneaking());
            this.entity.method_5728(entity.isSprinting());
            this.entity.method_18380(entity.isSneaking() ? class_4050.field_18081 : class_4050.field_18076);
            class_12972 = this.entity;
            if (class_12972 instanceof class_1309) {
                class_1309 livingTarget = (class_1309)class_12972;
                livingTarget.method_5673(class_1304.field_6173, entity.getEquipmentStack(class_1304.field_6173));
                livingTarget.method_5673(class_1304.field_6171, entity.getEquipmentStack(class_1304.field_6171));
                livingTarget.method_5673(class_1304.field_6169, entity.getEquipmentStack(class_1304.field_6169));
                livingTarget.method_5673(class_1304.field_6174, entity.getEquipmentStack(class_1304.field_6174));
                livingTarget.method_5673(class_1304.field_6172, entity.getEquipmentStack(class_1304.field_6172));
                livingTarget.method_5673(class_1304.field_6166, entity.getEquipmentStack(class_1304.field_6166));
            }
            this.entity.field_6012 = entity.getAge();
            this.entity.field_5960 = true;
            this.prevYawHead = entity.getHeadYaw() - entity.getBodyYaw();
            this.prevPitch = entity.getPitch();
        }
    }

    static {
        WIDE = new GameProfile(UUID.fromString("b99a2400-28a8-4288-92dc-924beafbf756"), "McHorse( Ported to 1.21.1 by Over )");
        SLIM = new GameProfile(UUID.fromString("5477bd28-e672-4f87-a209-c03cf75f3606"), "osmiq");
    }

    @Environment(value=EnvType.CLIENT)
    private static class BooleanHolder {
        public boolean bool;

        private BooleanHolder() {
        }
    }
}

